/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.types.transfer.auth.TokenAuthData;

public class RequestHelper {
    private static final String BATCH_URL = "/beta/$batch";

    private RequestHelper() {
    }

    public static Map<String, Object> createRequest(int id, String url, LinkedHashMap data) {
        LinkedHashMap<String, Object> request = new LinkedHashMap<String, Object>();
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        request.put("headers", headers);
        request.put("id", "" + id);
        request.put("method", "POST");
        request.put("url", url);
        request.put("body", data);
        return request;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static BatchResponse batchRequest(TokenAuthData authData, List<Map<String, Object>> requests, String baseUrl, OkHttpClient client, ObjectMapper objectMapper) {
        try {
            LinkedHashMap<String, List<Map<String, Object>>> batch = new LinkedHashMap<String, List<Map<String, Object>>>();
            batch.put("requests", requests);
            Request.Builder requestBuilder = new Request.Builder().url(baseUrl + BATCH_URL);
            requestBuilder.header("Authorization", "Bearer " + authData.getToken());
            requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)objectMapper.writeValueAsString(batch)));
            try (Response response = client.newCall(requestBuilder.build()).execute();){
                int code = response.code();
                if (code >= 200 && code <= 299) {
                    ResponseBody body = response.body();
                    if (body == null) {
                        BatchResponse batchResponse = new BatchResponse(new ImportResult(ImportResult.ResultType.ERROR));
                        return batchResponse;
                    }
                    Map responseData = (Map)objectMapper.readValue(body.bytes(), Map.class);
                    BatchResponse batchResponse = new BatchResponse(new ImportResult(ImportResult.ResultType.OK), (List)responseData.get("responses"));
                    return batchResponse;
                }
                BatchResponse batchResponse = new BatchResponse(new ImportResult(ImportResult.ResultType.ERROR));
                return batchResponse;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new BatchResponse(new ImportResult((Throwable)e));
        }
    }

    public static class BatchResponse {
        private final ImportResult result;
        private final List<Map<String, Object>> batchResponse;

        public BatchResponse(ImportResult result, List<Map<String, Object>> batchResponse) {
            this.result = result;
            this.batchResponse = batchResponse;
        }

        public BatchResponse(ImportResult result) {
            this.result = result;
            this.batchResponse = null;
        }

        public ImportResult getResult() {
            return this.result;
        }

        public List<Map<String, Object>> getBatchResponse() {
            return this.batchResponse;
        }
    }
}

