/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.transformer.calendar;

import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.datatransferproject.transfer.microsoft.transformer.TransformerContext;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;

public class ToGraphEventTransformer
implements BiFunction<CalendarEventModel, TransformerContext, Map<String, Object>> {
    @Override
    public Map<String, Object> apply(CalendarEventModel eventModel, TransformerContext context) {
        LinkedHashMap<String, Object> graphCalendar = new LinkedHashMap<String, Object>();
        graphCalendar.put("subject", eventModel.getTitle());
        this.copyDateTime("start", eventModel.getStartTime(), graphCalendar);
        this.copyDateTime("end", eventModel.getStartTime(), graphCalendar);
        this.copyLocation(eventModel, graphCalendar);
        this.copyBody(eventModel, graphCalendar);
        this.copyAttendees(eventModel, graphCalendar);
        return graphCalendar;
    }

    private void copyLocation(CalendarEventModel eventModel, Map<String, Object> graphCalendar) {
        if (eventModel.getLocation() == null) {
            return;
        }
        HashMap<String, String> graphLocation = new HashMap<String, String>();
        graphLocation.put("displayName", eventModel.getLocation());
        graphLocation.put("locationType", "Default");
        graphCalendar.put("location", graphLocation);
    }

    private void copyDateTime(String key, CalendarEventModel.CalendarEventTime dateTime, Map<String, Object> graphCalendar) {
        HashMap<String, String> graphDateTime = new HashMap<String, String>();
        graphDateTime.put("dateTime", dateTime.getDateTime().atZoneSameInstant(ZoneId.of("UTC")).toLocalDateTime().toString());
        graphDateTime.put("timeZone", "UTC");
        graphCalendar.put(key, graphDateTime);
    }

    private void copyAttendees(CalendarEventModel eventModel, Map<String, Object> graphCalendar) {
        List attendees = eventModel.getAttendees();
        if (attendees == null) {
            return;
        }
        ArrayList graphAttendees = new ArrayList();
        attendees.forEach(attendee -> {
            HashMap<String, Object> graphAttendee = new HashMap<String, Object>();
            graphAttendee.put("type", attendee.getOptional() ? "optional" : "required");
            HashMap<String, String> emailAddress = new HashMap<String, String>();
            emailAddress.put("address", attendee.getEmail());
            emailAddress.put("name", attendee.getDisplayName());
            graphAttendee.put("emailAddress", emailAddress);
            graphAttendees.add(graphAttendee);
        });
        graphCalendar.put("attendees", graphAttendees);
    }

    private void copyBody(CalendarEventModel eventModel, Map<String, Object> graphCalendar) {
        String notes = eventModel.getNotes();
        if (notes == null) {
            return;
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("contentType", "HTML");
        body.put("content", notes);
        graphCalendar.put("body", body);
    }
}

