/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.offline;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.transfer.microsoft.spi.types.MicrosoftOfflineData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.transfer.auth.TokenAuthData;

public class MicrosoftOfflineDataExporter
implements Exporter<TokenAuthData, MicrosoftOfflineData> {
    private static final String OFFLINE_DATA = "offlinedata.json";
    private final String offlineDataUrl;
    private final String contentTemplate;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;

    public MicrosoftOfflineDataExporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper) {
        this.offlineDataUrl = baseUrl + "/v1.0/me/drive/root:/offlinedata:/children";
        this.contentTemplate = baseUrl + "/v1.0/me/drive/items/%s/content";
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public ExportResult<MicrosoftOfflineData> export(UUID jobId, TokenAuthData authData, Optional<ExportInformation> exportInformation) {
        try {
            String data = this.getDataFile(jobId, this.offlineDataUrl, authData);
            MicrosoftOfflineData offlineData = new MicrosoftOfflineData(data);
            return new ExportResult(ExportResult.ResultType.END, (DataModel)offlineData);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ExportResult((Throwable)e);
        }
    }

    /*
     * Loose catch block
     */
    private String getDataFile(UUID jobId, String url, TokenAuthData authData) throws IOException {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        requestBuilder.header("Authorization", "Bearer " + authData.getToken());
        try (Response folderResponse = this.client.newCall(requestBuilder.build()).execute();){
            String string;
            block23: {
                ResponseBody contentBody;
                Response contentResponse;
                block21: {
                    String string2;
                    block22: {
                        ResponseBody folderBody = folderResponse.body();
                        if (folderBody == null) {
                            String string3 = "";
                            return string3;
                        }
                        String folderContent = new String(folderBody.bytes());
                        Map filesMap = (Map)this.objectMapper.reader().forType(Map.class).readValue(folderContent);
                        String id = this.parseOfflineDataId(filesMap);
                        if (id == null) {
                            String string4 = "";
                            return string4;
                        }
                        String contentUrl = String.format(this.contentTemplate, id);
                        Request.Builder requestBuilder2 = new Request.Builder().url(contentUrl);
                        requestBuilder2.header("Authorization", "Bearer " + authData.getToken());
                        contentResponse = this.client.newCall(requestBuilder2.build()).execute();
                        contentBody = contentResponse.body();
                        if (contentBody != null) break block21;
                        string2 = "";
                        if (contentResponse == null) break block22;
                        contentResponse.close();
                    }
                    return string2;
                }
                string = contentBody.string();
                if (contentResponse == null) break block23;
                {
                    catch (Throwable throwable) {
                        try {
                            if (contentResponse != null) {
                                try {
                                    contentResponse.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                            String string5 = "";
                            return string5;
                        }
                    }
                }
                contentResponse.close();
            }
            return string;
        }
    }

    private String parseOfflineDataId(Map filesMap) {
        List items = (List)filesMap.get("value");
        if (items != null) {
            for (Map item : items) {
                String name = (String)item.get("name");
                if (!OFFLINE_DATA.equals(name)) continue;
                return (String)item.get("id");
            }
        }
        return null;
    }
}

