/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.driveModels;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftDriveFolder;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftFileMetadata;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftPhotoMetadata;
import org.datatransferproject.transfer.microsoft.driveModels.MicrosoftVideoMetadata;

public class MicrosoftDriveItem {
    @JsonProperty(value="id")
    public String id;
    @JsonProperty(value="name")
    public String name;
    @JsonProperty(value="folder")
    public MicrosoftDriveFolder folder;
    @JsonProperty(value="photo")
    public MicrosoftPhotoMetadata photo;
    @JsonProperty(value="video")
    public MicrosoftVideoMetadata video;
    @JsonProperty(value="file")
    public MicrosoftFileMetadata file;
    @JsonProperty(value="description")
    public String description;
    @JsonProperty(value="@microsoft.graph.downloadUrl")
    public String downloadUrl;

    public boolean isFolder() {
        return this.folder != null;
    }

    public boolean isFile() {
        return this.file != null;
    }

    private boolean isMimeType(MimeTypePrefix prefix) {
        return prefix.containsType(this.file.mimeType);
    }

    public boolean isImage() {
        return this.isFile() && this.isMimeType(MimeTypePrefix.IMAGE);
    }

    public boolean isVideo() {
        return this.isFile() && this.isMimeType(MimeTypePrefix.VIDEO);
    }

    private static enum MimeTypePrefix {
        IMAGE("image"),
        VIDEO("video");

        private final String prefix;

        private MimeTypePrefix(String prefix) {
            this.prefix = prefix;
        }

        public boolean containsType(String mimeType) {
            return mimeType != null && mimeType.startsWith(this.prefix + "/");
        }
    }
}

