/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.common;

import com.google.api.client.auth.oauth2.BearerToken;
import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.RefreshTokenRequest;
import com.google.api.client.auth.oauth2.TokenResponse;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import java.io.IOException;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class MicrosoftCredentialFactory {
    private static final long EXPIRE_TIME_IN_SECONDS = 0L;
    private final HttpTransport httpTransport;
    private final JsonFactory jsonFactory;
    private final AppCredentials appCredentials;

    public MicrosoftCredentialFactory(HttpTransport httpTransport, JsonFactory jsonFactory, AppCredentials appCredentials) {
        this.httpTransport = httpTransport;
        this.jsonFactory = jsonFactory;
        this.appCredentials = appCredentials;
    }

    public HttpTransport getHttpTransport() {
        return this.httpTransport;
    }

    public JsonFactory getJsonFactory() {
        return this.jsonFactory;
    }

    public Credential createCredential(TokensAndUrlAuthData authData) {
        return new Credential.Builder(BearerToken.authorizationHeaderAccessMethod()).setTransport(this.httpTransport).setJsonFactory(this.jsonFactory).setClientAuthentication((HttpExecuteInterceptor)new ClientParametersAuthentication(this.appCredentials.getKey(), this.appCredentials.getSecret())).setTokenServerEncodedUrl(authData.getTokenServerEncodedUrl()).build().setAccessToken(authData.getAccessToken()).setRefreshToken(authData.getRefreshToken()).setExpiresInSeconds(Long.valueOf(0L));
    }

    public Credential refreshCredential(Credential credential) throws IOException {
        TokenResponse tokenResponse = new RefreshTokenRequest(this.httpTransport, this.jsonFactory, new GenericUrl(credential.getTokenServerEncodedUrl()), credential.getRefreshToken()).setClientAuthentication(credential.getClientAuthentication()).setRequestInitializer(credential.getRequestInitializer()).execute();
        return credential.setFromTokenResponse(tokenResponse);
    }
}

