/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft.calendar;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.transfer.microsoft.transformer.TransformResult;
import org.datatransferproject.transfer.microsoft.transformer.TransformerService;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.calendar.CalendarContainerResource;
import org.datatransferproject.types.common.models.calendar.CalendarEventModel;
import org.datatransferproject.types.common.models.calendar.CalendarModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class MicrosoftCalendarExporter
implements Exporter<TokensAndUrlAuthData, CalendarContainerResource> {
    private static final String CALENDARS_SUBPATH = "/v1.0/me/calendars";
    private static final String EVENTS_URL = "/v1.0/me/calendars/%s/events";
    private static final String ODATA_NEXT = "@odata.nextLink";
    private final String baseUrl;
    private final OkHttpClient client;
    private final ObjectMapper objectMapper;
    private final TransformerService transformerService;

    @VisibleForTesting
    public MicrosoftCalendarExporter(String baseUrl, OkHttpClient client, ObjectMapper objectMapper, TransformerService transformerService) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.transformerService = transformerService;
        this.baseUrl = baseUrl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ExportResult<CalendarContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        ExportResult result;
        Object body;
        if (exportInformation.isPresent()) {
            throw new UnsupportedOperationException();
        }
        Request.Builder calendarsBuilder = this.getBuilder(this.baseUrl + CALENDARS_SUBPATH, authData);
        ArrayList<CalendarModel> calendarModels = new ArrayList<CalendarModel>();
        try (Response graphResponse = this.client.newCall(calendarsBuilder.build()).execute();){
            body = graphResponse.body();
            if (body == null) {
                ExportResult exportResult = new ExportResult((Throwable)new Exception("Error retrieving contacts: response body was null"));
                return exportResult;
            }
            String graphBody = new String(body.bytes());
            Map graphMap = (Map)this.objectMapper.reader().forType(Map.class).readValue(graphBody);
            List rawCalendars = (List)graphMap.get("value");
            if (rawCalendars == null) {
                ExportResult exportResult = new ExportResult(ExportResult.ResultType.END);
                return exportResult;
            }
            for (Map rawCalendar : rawCalendars) {
                result = this.transformerService.transform(CalendarModel.class, rawCalendar);
                if (result.hasProblems()) continue;
                calendarModels.add(result.getTransformed());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ExportResult((Throwable)e);
        }
        ArrayList<CalendarEventModel> calendarEventModels = new ArrayList<CalendarEventModel>();
        body = calendarModels.iterator();
        block19: while (true) {
            if (!body.hasNext()) {
                CalendarContainerResource resource = new CalendarContainerResource(calendarModels, calendarEventModels);
                return new ExportResult(ExportResult.ResultType.END, (DataModel)resource, null);
            }
            CalendarModel calendarModel = (CalendarModel)body.next();
            String id = calendarModel.getId();
            Request.Builder eventsBuilder = this.getBuilder(this.calculateEventsUrl(id), authData);
            try {
                Response graphResponse = this.client.newCall(eventsBuilder.build()).execute();
                try {
                    ExportResult exportResult;
                    ResponseBody body2 = graphResponse.body();
                    if (body2 == null) {
                        result = new ExportResult((Throwable)new Exception("Error retrieving calendar: response body was null"));
                        return result;
                    }
                    String graphBody = new String(body2.bytes());
                    Map graphMap = (Map)this.objectMapper.reader().forType(Map.class).readValue(graphBody);
                    List rawEvents = (List)graphMap.get("value");
                    if (rawEvents == null) {
                        exportResult = new ExportResult(ExportResult.ResultType.END);
                        return exportResult;
                    }
                    exportResult = rawEvents.iterator();
                    while (true) {
                        if (!exportResult.hasNext()) continue block19;
                        Map rawEvent = (Map)exportResult.next();
                        HashMap<String, String> properties = new HashMap<String, String>();
                        properties.put("calendar.id", id);
                        TransformResult<CalendarEventModel> result2 = this.transformerService.transform(CalendarEventModel.class, rawEvent, properties);
                        if (result2.hasProblems()) continue;
                        calendarEventModels.add(result2.getTransformed());
                    }
                }
                finally {
                    if (graphResponse == null) continue;
                    graphResponse.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return new ExportResult((Throwable)e);
            }
        }
    }

    private String calculateEventsUrl(String eventId) {
        return this.baseUrl + String.format(EVENTS_URL, eventId);
    }

    private Request.Builder getBuilder(String url, TokensAndUrlAuthData authData) {
        Request.Builder calendarsRequestBuilder = new Request.Builder().url(url);
        calendarsRequestBuilder.header("Authorization", "Bearer " + authData.getAccessToken());
        return calendarsRequestBuilder;
    }
}

