/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class DataChunk {
    private static final int CHUNK_SIZE = 32768000;
    private final byte[] data;
    private final int size;
    private final int rangeStart;

    public DataChunk(byte[] data, int size, int rangeStart) {
        this.data = data;
        this.size = size;
        this.rangeStart = rangeStart;
    }

    public int getSize() {
        return this.size;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getStart() {
        return this.rangeStart;
    }

    public int getEnd() {
        return this.rangeStart + this.size - 1;
    }

    public static List<DataChunk> splitData(InputStream inputStream) throws IOException {
        int quantityToSend;
        ArrayList<DataChunk> chunksToSend = new ArrayList<DataChunk>();
        byte[] data = new byte[32768000];
        int totalFileSize = 0;
        int roomLeft = 32768000;
        int offset = 0;
        int chunksRead = 0;
        while ((quantityToSend = inputStream.read(data, offset, roomLeft)) != -1) {
            offset += quantityToSend;
            if ((roomLeft -= quantityToSend) != 0) continue;
            chunksToSend.add(new DataChunk(data, 32768000, chunksRead * 32768000));
            ++chunksRead;
            roomLeft = 32768000;
            offset = 0;
            totalFileSize += 32768000;
            data = new byte[32768000];
        }
        if (offset != 0) {
            chunksToSend.add(new DataChunk(data, offset, chunksRead * 32768000));
            totalFileSize += offset;
            ++chunksRead;
        }
        return chunksToSend;
    }
}

