/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.photos;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.apache.commons.imaging.Imaging;
import org.apache.commons.imaging.common.ImageMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegImageMetadata;
import org.apache.commons.imaging.formats.tiff.TiffImageMetadata;
import org.apache.commons.imaging.formats.tiff.constants.ExifTagConstants;
import org.apache.commons.io.IOUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.transfer.koofr.KoofrTransmogrificationConfig;
import org.datatransferproject.transfer.koofr.common.KoofrClient;
import org.datatransferproject.transfer.koofr.common.KoofrClientFactory;
import org.datatransferproject.transfer.koofr.exceptions.KoofrClientIOException;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.TransmogrificationConfig;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class KoofrPhotosImporter
implements Importer<TokensAndUrlAuthData, PhotosContainerResource> {
    private static final String SKIPPED_FILE_RESULT_FORMAT = "skipped-%s";
    private static final String TITLE_DATE_FORMAT = "yyyy-MM-dd HH.mm.ss ";
    private final KoofrClientFactory koofrClientFactory;
    private final JobStore jobStore;
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;
    private final KoofrTransmogrificationConfig transmogrificationConfig = new KoofrTransmogrificationConfig();
    private final SimpleDateFormat exifDateFormat = new SimpleDateFormat("yyyy:MM:dd HH:mm:ss");
    private volatile HashMap<UUID, SimpleDateFormat> titleDateFormats = new HashMap();

    public KoofrPhotosImporter(KoofrClientFactory koofrClientFactory, Monitor monitor, JobStore jobStore) {
        this.koofrClientFactory = koofrClientFactory;
        this.connectionProvider = new ConnectionProvider((TemporaryPerJobDataStore)jobStore);
        this.monitor = monitor;
        this.jobStore = jobStore;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, PhotosContainerResource resource) throws Exception {
        KoofrClient koofrClient = this.koofrClientFactory.create(authData);
        this.monitor.debug(() -> String.format("%s: Importing %s albums and %s photos before transmogrification", jobId, resource.getAlbums().size(), resource.getPhotos().size()), new Object[0]);
        resource.transmogrify((TransmogrificationConfig)this.transmogrificationConfig);
        this.monitor.debug(() -> String.format("%s: Importing %s albums and %s photos after transmogrification", jobId, resource.getAlbums().size(), resource.getPhotos().size()), new Object[0]);
        for (PhotoAlbum album : resource.getAlbums()) {
            idempotentImportExecutor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.createAlbumFolder(album, koofrClient));
        }
        LongAdder totalImportedFilesSizes = new LongAdder();
        for (PhotoModel photoModel : resource.getPhotos()) {
            idempotentImportExecutor.importAndSwallowIOExceptions((ImportableItem)photoModel, photo -> {
                ItemImportResult<String> fileImportResult = this.importSinglePhoto(photoModel, jobId, idempotentImportExecutor, koofrClient);
                if (fileImportResult != null && fileImportResult.hasBytes()) {
                    totalImportedFilesSizes.add(fileImportResult.getBytes());
                }
                return fileImportResult;
            });
        }
        return ImportResult.OK.copyWithBytes(Long.valueOf(totalImportedFilesSizes.longValue()));
    }

    private String createAlbumFolder(PhotoAlbum album, KoofrClient koofrClient) throws IOException, InvalidTokenException {
        String albumName = KoofrTransmogrificationConfig.getAlbumName(album.getName());
        this.monitor.debug(() -> String.format("Create Koofr folder %s", albumName), new Object[0]);
        String rootPath = koofrClient.ensureRootFolder();
        String fullPath = rootPath + "/" + albumName;
        koofrClient.ensureFolder(rootPath, albumName);
        String description = KoofrClient.trimDescription(album.getDescription());
        if (description != null && description.length() > 0) {
            koofrClient.addDescription(fullPath, description);
        }
        return fullPath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ItemImportResult<String> importSinglePhoto(PhotoModel photo, UUID jobId, IdempotentImportExecutor idempotentImportExecutor, KoofrClient koofrClient) throws IOException, InvalidTokenException, DestinationMemoryFullException {
        this.monitor.debug(() -> String.format("Import single photo %s", photo.getTitle()), new Object[0]);
        Long size = null;
        try {
            TemporaryPerJobDataStore.InputStreamWrapper inputStreamWrapper = this.connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)photo);
            try (InputStream inputStream = inputStreamWrapper.getStream();){
                ItemImportResult response;
                byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
                Date dateCreated = this.getDateCreated(photo, bytes);
                String title = this.buildPhotoTitle(jobId, photo.getTitle(), dateCreated);
                String description = KoofrClient.trimDescription(photo.getDescription());
                String parentPath = (String)((Object)idempotentImportExecutor.getCachedValue(photo.getAlbumId()));
                String fullPath = parentPath + "/" + title;
                if (koofrClient.fileExists(fullPath)) {
                    this.monitor.debug(() -> String.format("Photo already exists %s", photo.getTitle()), new Object[0]);
                    ItemImportResult itemImportResult = ItemImportResult.success((Serializable)((Object)fullPath));
                    return itemImportResult;
                }
                ByteArrayInputStream inMemoryInputStream = new ByteArrayInputStream(bytes);
                try {
                    long inputStreamBytes = inputStreamWrapper.getBytes();
                    String stringResult = koofrClient.uploadFile(parentPath, title, inMemoryInputStream, photo.getMediaType(), dateCreated, description);
                    response = stringResult != null && !stringResult.isEmpty() ? ItemImportResult.success((Serializable)((Object)stringResult), (Long)inputStreamBytes) : ItemImportResult.success((Serializable)((Object)String.format(SKIPPED_FILE_RESULT_FORMAT, photo.getDataId())));
                    size = inputStreamBytes;
                }
                catch (KoofrClientIOException exception) {
                    if (exception.getCode() != 404) {
                        ItemImportResult itemImportResult = ItemImportResult.error((Exception)exception, size);
                        if (inputStream == null) return itemImportResult;
                        inputStream.close();
                        return itemImportResult;
                    }
                    this.monitor.info(() -> String.format("Can't find album during importSingleItem for id: %s", photo.getDataId()), new Object[]{exception});
                    response = ItemImportResult.success((Serializable)((Object)String.format(SKIPPED_FILE_RESULT_FORMAT, photo.getDataId())));
                }
                try {
                    if (!photo.isInTempStore()) return response;
                    this.jobStore.removeData(jobId, photo.getFetchableUrl());
                    return response;
                }
                catch (Exception e) {
                    this.monitor.info(() -> String.format("Exception swallowed while removing data for jobId %s, localPath %s", jobId, photo.getFetchableUrl()), new Object[]{e});
                    return response;
                }
            }
        }
        catch (KoofrClientIOException exception) {
            return ItemImportResult.error((Exception)exception, size);
        }
    }

    private String buildPhotoTitle(UUID jobId, String originalTitle, Date dateCreated) {
        if (dateCreated == null) {
            return originalTitle;
        }
        SimpleDateFormat dateFormat = this.getOrCreateTitleDateFormat(jobId);
        return dateFormat.format(dateCreated) + originalTitle;
    }

    private Date getDateCreated(PhotoModel photo, byte[] bytes) {
        if (photo.getUploadedTime() != null) {
            return photo.getUploadedTime();
        }
        try {
            ImageMetadata metadata = Imaging.getMetadata((byte[])bytes);
            if (metadata == null) {
                return null;
            }
            JpegImageMetadata jpegMetadata = (JpegImageMetadata)metadata;
            TiffImageMetadata exif = jpegMetadata.getExif();
            if (exif == null) {
                return null;
            }
            String[] values = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_ORIGINAL);
            if (values == null || values.length == 0) {
                values = exif.getFieldValue(ExifTagConstants.EXIF_TAG_DATE_TIME_DIGITIZED);
            }
            if (values == null || values.length == 0) {
                return null;
            }
            return this.exifDateFormat.parse(values[0]);
        }
        catch (Exception e) {
            this.monitor.info(() -> String.format("There was an issue when reading the exif data of %s", photo.getDataId()), new Object[]{e});
            return null;
        }
    }

    private synchronized SimpleDateFormat getOrCreateTitleDateFormat(UUID jobId) {
        if (this.titleDateFormats.containsKey(jobId)) {
            return this.titleDateFormats.get(jobId);
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(TITLE_DATE_FORMAT);
        TimeZone userTimeZone = this.jobStore.findJob(jobId).userTimeZone();
        if (null != userTimeZone) {
            dateFormat.setTimeZone(userTimeZone);
        }
        this.titleDateFormats.put(jobId, dateFormat);
        return dateFormat;
    }
}

