/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.videos;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.koofr.common.KoofrClient;
import org.datatransferproject.transfer.koofr.common.KoofrClientFactory;
import org.datatransferproject.transfer.koofr.common.KoofrMediaExport;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.videos.VideoAlbum;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class KoofrVideosExporter
implements Exporter<TokensAndUrlAuthData, VideosContainerResource> {
    private final Monitor monitor;
    private final KoofrClientFactory koofrClientFactory;

    public KoofrVideosExporter(KoofrClientFactory koofrClientFactory, Monitor monitor) {
        this.koofrClientFactory = koofrClientFactory;
        this.monitor = monitor;
    }

    public ExportResult<VideosContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws CopyExceptionWithFailureReason {
        Preconditions.checkNotNull((Object)authData);
        KoofrClient koofrClient = this.koofrClientFactory.create(authData);
        KoofrMediaExport export = new KoofrMediaExport(koofrClient, this.monitor);
        try {
            export.export();
            List<VideoAlbum> exportAlbums = export.getVideoAlbums();
            List<VideoModel> exportVideos = export.getVideos();
            VideosContainerResource containerResource = new VideosContainerResource(exportAlbums, exportVideos);
            return new ExportResult(ExportResult.ResultType.END, (DataModel)containerResource, null);
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
    }
}

