/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.transfer.koofr.common.FilesFile;
import org.datatransferproject.transfer.koofr.common.FilesListRecursiveItem;
import org.datatransferproject.transfer.koofr.common.KoofrClient;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.videos.VideoAlbum;
import org.datatransferproject.types.common.models.videos.VideoModel;

public class KoofrMediaExport {
    protected final KoofrClient koofrClient;
    protected final Monitor monitor;
    protected ArrayList<PhotoAlbum> albums;
    protected HashSet<String> albumsWithPhotos;
    protected ArrayList<PhotoModelContainer> photos;
    protected HashSet<String> albumsWithVideos;
    protected ArrayList<VideoObjectContainer> videos;
    protected String rootPath;
    protected List<FilesListRecursiveItem> items;

    public KoofrMediaExport(KoofrClient koofrClient, Monitor monitor) {
        this.koofrClient = koofrClient;
        this.monitor = monitor;
    }

    public void export() throws IOException, InvalidTokenException {
        this.albums = new ArrayList();
        this.albumsWithPhotos = new HashSet();
        this.photos = new ArrayList();
        this.albumsWithVideos = new HashSet();
        this.videos = new ArrayList();
        this.rootPath = this.koofrClient.getRootPath();
        this.items = this.koofrClient.listRecursive(this.rootPath);
        this.processItems();
    }

    public List<PhotoAlbum> getPhotoAlbums() {
        ArrayList<PhotoAlbum> exportAlbums = new ArrayList<PhotoAlbum>();
        for (PhotoAlbum album : this.albums) {
            if (!this.albumsWithPhotos.contains(album.getId())) continue;
            exportAlbums.add(album);
        }
        return exportAlbums;
    }

    public List<PhotoModel> getPhotos() throws IOException, InvalidTokenException {
        ArrayList<PhotoModel> exportPhotos = new ArrayList<PhotoModel>();
        for (PhotoModelContainer photoContainer : this.photos) {
            PhotoModel photo = photoContainer.photoModel;
            String fetchableUrl = this.getFetchableUrl(photoContainer.fullPath);
            if (fetchableUrl == null) continue;
            exportPhotos.add(new PhotoModel(photo.getTitle(), fetchableUrl, photo.getDescription(), photo.getMediaType(), photo.getDataId(), photo.getAlbumId(), photo.isInTempStore(), photo.getUploadedTime()));
        }
        return exportPhotos;
    }

    public List<VideoAlbum> getVideoAlbums() {
        ArrayList<VideoAlbum> exportAlbums = new ArrayList<VideoAlbum>();
        for (PhotoAlbum album : this.albums) {
            if (!this.albumsWithVideos.contains(album.getId())) continue;
            exportAlbums.add(new VideoAlbum(album.getId(), album.getName(), album.getDescription()));
        }
        return exportAlbums;
    }

    public List<VideoModel> getVideos() throws IOException, InvalidTokenException {
        ArrayList<VideoModel> exportVideos = new ArrayList<VideoModel>();
        for (VideoObjectContainer container : this.videos) {
            VideoModel video = container.videoModel;
            String fetchableUrl = this.getFetchableUrl(container.fullPath);
            if (fetchableUrl == null) continue;
            exportVideos.add(new VideoModel(video.getName(), fetchableUrl, video.getDescription(), video.getEncodingFormat(), video.getDataId(), video.getAlbumId(), video.isInTempStore(), video.getUploadedTime()));
        }
        return exportVideos;
    }

    protected void processItems() {
        for (FilesListRecursiveItem item : this.items) {
            this.processItem(item);
        }
    }

    protected void processItem(FilesListRecursiveItem item) {
        if ("file".equals(item.getType())) {
            this.processItemFile(item.getFile(), item.getPath());
        } else if ("error".equals(item.getType())) {
            this.monitor.severe(() -> String.format("Koofr list item error: %s: %s: %s", item.getPath(), item.getError().getCode(), item.getError().getMessage()), new Object[0]);
        }
    }

    protected void processItemFile(FilesFile file, String path) {
        String[] pathParts = path.split("/");
        if ("dir".equals(file.getType())) {
            if (pathParts.length == 2 && !pathParts[1].isEmpty()) {
                this.processAlbum(file, path);
            }
        } else if (pathParts.length > 2 && file.getContentType().startsWith("image/")) {
            String albumId = this.getAlbumId(pathParts);
            this.processPhoto(file, path, albumId);
        } else if (pathParts.length > 2 && file.getContentType().startsWith("video/")) {
            String albumId = this.getAlbumId(pathParts);
            this.processVideo(file, path, albumId);
        }
    }

    protected void processAlbum(FilesFile file, String path) {
        String albumId = path;
        String albumName = this.getFileName(file);
        String description = this.getFileDescription(file);
        this.albums.add(new PhotoAlbum(albumId, albumName, description));
    }

    protected void processPhoto(FilesFile file, String path, String albumId) {
        String photoId = path;
        String name = this.getFileName(file);
        String description = this.getFileDescription(file);
        String contentType = file.getContentType();
        Date uploadedTime = new Date(file.getModified());
        String fullPath = this.rootPath + path;
        this.albumsWithPhotos.add(albumId);
        PhotoModelContainer container = new PhotoModelContainer();
        container.photoModel = new PhotoModel(name, "", description, contentType, photoId, albumId, false, uploadedTime);
        container.fullPath = fullPath;
        this.photos.add(container);
    }

    protected void processVideo(FilesFile file, String path, String albumId) {
        String videoId = path;
        String name = this.getFileName(file);
        String description = this.getFileDescription(file);
        String contentType = file.getContentType();
        Date uploadedTime = new Date(file.getModified());
        String fullPath = this.rootPath + path;
        this.albumsWithVideos.add(albumId);
        VideoObjectContainer container = new VideoObjectContainer();
        container.videoModel = new VideoModel(name, "", description, contentType, videoId, albumId, false, uploadedTime);
        container.fullPath = fullPath;
        this.videos.add(container);
    }

    protected String getAlbumId(String[] pathParts) {
        return String.join((CharSequence)"/", Arrays.copyOfRange(pathParts, 0, 2));
    }

    protected String getFileName(FilesFile file) {
        String albumName = file.getName();
        if (file.getTags() != null && file.getTags().containsKey("originalName")) {
            albumName = file.getTags().get("originalName").get(0);
        }
        return albumName;
    }

    protected String getFileDescription(FilesFile file) {
        String description = null;
        if (file.getTags() != null && file.getTags().containsKey("description")) {
            description = file.getTags().get("description").get(0);
        }
        return description;
    }

    protected String getFetchableUrl(String fullPath) throws IOException, InvalidTokenException {
        try {
            return this.koofrClient.fileLink(fullPath);
        }
        catch (IOException e) {
            this.monitor.severe(() -> String.format("Koofr file link error: %s", fullPath), new Object[]{e});
            return null;
        }
    }

    public static class VideoObjectContainer {
        VideoModel videoModel;
        String fullPath;
    }

    public static class PhotoModelContainer {
        PhotoModel photoModel;
        String fullPath;
    }
}

