/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr.common;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.http.client.utils.URIBuilder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.transfer.koofr.common.FilesListRecursiveItem;
import org.datatransferproject.transfer.koofr.common.InputStreamRequestBody;
import org.datatransferproject.transfer.koofr.common.KoofrCredentialFactory;
import org.datatransferproject.transfer.koofr.exceptions.KoofrClientIOException;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class KoofrClient {
    private final String baseUrl;
    private final OkHttpClient client;
    private final OkHttpClient fileUploadClient;
    private final ObjectMapper objectMapper;
    private final Monitor monitor;
    private final KoofrCredentialFactory credentialFactory;
    private Credential credential;
    private boolean rootEnsured;
    private boolean videosEnsured;
    private static final String API_PATH_PREFIX = "/api/v2";
    private static final String CONTENT_API_PATH_PREFIX = "/content/api/v2";
    private static final String ROOT_NAME = "Data transfer";
    private static final String VIDEOS_NAME = "Videos";

    public KoofrClient(String baseUrl, OkHttpClient client, OkHttpClient fileUploadClient, ObjectMapper objectMapper, Monitor monitor, KoofrCredentialFactory credentialFactory) {
        this.baseUrl = baseUrl;
        this.client = client;
        this.fileUploadClient = fileUploadClient;
        this.objectMapper = objectMapper;
        this.monitor = monitor;
        this.credentialFactory = credentialFactory;
        this.credential = null;
        this.rootEnsured = false;
        this.videosEnsured = false;
    }

    public boolean fileExists(String path) throws IOException, InvalidTokenException {
        String url;
        try {
            url = this.getUriBuilder().setPath("/api/v2/mounts/primary/files/info").setParameter("path", path).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
        Request.Builder requestBuilder = this.getRequestBuilder(url);
        try (Response response = this.getResponse(requestBuilder);){
            int code = response.code();
            if (code == 200) {
                boolean bl = true;
                return bl;
            }
            if (code == 404) {
                boolean bl = false;
                return bl;
            }
            throw new KoofrClientIOException(response);
        }
    }

    public void ensureFolder(String parentPath, String name) throws IOException, InvalidTokenException {
        String url;
        LinkedHashMap<String, String> rawFolder = new LinkedHashMap<String, String>();
        rawFolder.put("name", name);
        try {
            url = this.getUriBuilder().setPath("/api/v2/mounts/primary/files/folder").setParameter("path", parentPath).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
        Request.Builder requestBuilder = this.getRequestBuilder(url);
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString(rawFolder)));
        try (Response response = this.getResponse(requestBuilder);){
            int code = response.code();
            if ((code < 200 || code > 299) && code != 409) {
                throw new KoofrClientIOException(response);
            }
        }
    }

    public void addDescription(String path, String description) throws IOException, InvalidTokenException {
        String url;
        LinkedHashMap<String, String[]> tags = new LinkedHashMap<String, String[]>();
        tags.put("description", new String[]{description});
        LinkedHashMap<String, LinkedHashMap<String, String[]>> body = new LinkedHashMap<String, LinkedHashMap<String, String[]>>();
        body.put("tags", tags);
        try {
            url = this.getUriBuilder().setPath("/api/v2/mounts/primary/files/tags/add").setParameter("path", path).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
        Request.Builder requestBuilder = this.getRequestBuilder(url);
        requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.objectMapper.writeValueAsString(body)));
        try (Response response = this.getResponse(requestBuilder);){
            int code = response.code();
            if ((code < 200 || code > 299) && code != 409) {
                throw new KoofrClientIOException(response);
            }
        }
    }

    public String uploadFile(String parentPath, String name, InputStream inputStream, String mediaType, Date modified, String description) throws IOException, InvalidTokenException, DestinationMemoryFullException {
        String url;
        try {
            URIBuilder builder = this.getUriBuilder().setPath("/content/api/v2/mounts/primary/files/put").setParameter("path", parentPath).setParameter("filename", name).setParameter("autorename", "true").setParameter("info", "true");
            if (description != null && description.length() > 0) {
                builder.setParameter("tags", "description=" + description);
            }
            if (modified != null) {
                builder.setParameter("modified", Long.toString(modified.getTime()));
            }
            url = builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
        Request.Builder requestBuilder = this.getRequestBuilder(url);
        InputStreamRequestBody uploadBody = new InputStreamRequestBody(MediaType.parse((String)mediaType), inputStream);
        requestBuilder.post((RequestBody)uploadBody);
        try (Response response = this.getResponse(this.fileUploadClient, requestBuilder, inputStream::reset);){
            int code = response.code();
            ResponseBody body = response.body();
            if (code == 413) {
                throw new DestinationMemoryFullException("Koofr quota exceeded", (Throwable)new Exception("Koofr file upload response code " + code));
            }
            if (code < 200 || code > 299) {
                throw new KoofrClientIOException(response);
            }
            Map responseData = (Map)this.objectMapper.readValue(body.bytes(), Map.class);
            String newName = (String)responseData.get("name");
            Preconditions.checkState((!Strings.isNullOrEmpty((String)newName) ? 1 : 0) != 0, (String)"Expected name value to be present in %s", (Object)responseData);
            String string = parentPath + "/" + newName;
            return string;
        }
    }

    /*
     * Exception decompiling
     */
    public List<FilesListRecursiveItem> listRecursive(String path) throws IOException, InvalidTokenException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String fileLink(String path) throws IOException, InvalidTokenException {
        String url;
        try {
            url = this.getUriBuilder().setPath("/api/v2/mounts/primary/files/download").setParameter("path", path).build().toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
        Request.Builder requestBuilder = this.getRequestBuilder(url);
        try (Response response = this.getResponse(requestBuilder);){
            int code = response.code();
            ResponseBody body = response.body();
            if (code < 200 || code > 299) {
                throw new KoofrClientIOException(response);
            }
            Map responseData = (Map)this.objectMapper.readValue(body.bytes(), Map.class);
            String string = (String)responseData.get("link");
            return string;
        }
    }

    public String getRootPath() {
        return "/Data transfer";
    }

    public String ensureRootFolder() throws IOException, InvalidTokenException {
        if (!this.rootEnsured) {
            this.ensureFolder("/", ROOT_NAME);
            this.rootEnsured = true;
        }
        return this.getRootPath();
    }

    public String ensureVideosFolder() throws IOException, InvalidTokenException {
        String rootFolder = this.ensureRootFolder();
        if (!this.videosEnsured) {
            this.ensureFolder(rootFolder, VIDEOS_NAME);
            this.videosEnsured = true;
        }
        return rootFolder + "/Videos";
    }

    public Credential getOrCreateCredential(TokensAndUrlAuthData authData) {
        if (this.credential == null) {
            this.credential = this.credentialFactory.createCredential(authData);
        }
        return this.credential;
    }

    private Request.Builder getRequestBuilder(String url) {
        Request.Builder requestBuilder = new Request.Builder().url(url);
        requestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
        requestBuilder.header("X-Koofr-Version", "2.1");
        return requestBuilder;
    }

    private URIBuilder getUriBuilder() {
        try {
            return new URIBuilder(this.baseUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("Could not produce url.", e);
        }
    }

    private Response getResponse(OkHttpClient httpClient, Request.Builder requestBuilder, OnRetry onRetry) throws IOException, InvalidTokenException {
        Response response = this.client.newCall(requestBuilder.build()).execute();
        if (response.code() == 401) {
            response.close();
            this.credentialFactory.refreshCredential(this.credential);
            this.monitor.info(() -> "Refreshed authorization token successfuly", new Object[0]);
            requestBuilder.header("Authorization", "Bearer " + this.credential.getAccessToken());
            if (onRetry != null) {
                onRetry.run();
            }
            response = httpClient.newCall(requestBuilder.build()).execute();
        }
        return response;
    }

    private Response getResponse(Request.Builder requestBuilder) throws IOException, InvalidTokenException {
        return this.getResponse(this.client, requestBuilder, null);
    }

    public static String trimDescription(String description) {
        if (description == null) {
            return description;
        }
        if (description.length() > 1000) {
            return description.substring(0, 1000);
        }
        return description;
    }

    @FunctionalInterface
    private static interface OnRetry {
        public void run() throws IOException, InvalidTokenException;
    }
}

