/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.koofr;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import okhttp3.OkHttpClient;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.koofr.common.KoofrClientFactory;
import org.datatransferproject.transfer.koofr.common.KoofrCredentialFactory;
import org.datatransferproject.transfer.koofr.photos.KoofrPhotosExporter;
import org.datatransferproject.transfer.koofr.photos.KoofrPhotosImporter;
import org.datatransferproject.transfer.koofr.videos.KoofrVideosExporter;
import org.datatransferproject.transfer.koofr.videos.KoofrVideosImporter;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class KoofrTransferExtension
implements TransferExtension {
    public static final String SERVICE_ID = "koofr";
    private static final ImmutableList<DataVertical> SUPPORTED_IMPORT_SERVICES = ImmutableList.of((Object)DataVertical.PHOTOS, (Object)DataVertical.VIDEOS);
    private static final ImmutableList<DataVertical> SUPPORTED_EXPORT_SERVICES = ImmutableList.of((Object)DataVertical.PHOTOS, (Object)DataVertical.VIDEOS);
    private static final String BASE_API_URL = "https://app.koofr.net";
    private ImmutableMap<DataVertical, Importer> importerMap;
    private ImmutableMap<DataVertical, Exporter> exporterMap;
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkState((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_EXPORT_SERVICES.contains((Object)transferDataType));
        return (Exporter)this.exporterMap.get((Object)transferDataType);
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkState((boolean)this.initialized);
        Preconditions.checkArgument((boolean)SUPPORTED_IMPORT_SERVICES.contains((Object)transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        JobStore jobStore = (JobStore)context.getService(JobStore.class);
        HttpTransport httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        JsonFactory jsonFactory = (JsonFactory)context.getService(JsonFactory.class);
        OkHttpClient client = new OkHttpClient.Builder().build();
        ObjectMapper mapper = new ObjectMapper();
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials("KOOFR_KEY", "KOOFR_SECRET");
        }
        catch (IOException e) {
            Monitor monitor = context.getMonitor();
            monitor.info(() -> "Unable to retrieve Koofr AppCredentials. Did you set KOOFR_KEY and KOOFR_SECRET?", new Object[0]);
            return;
        }
        KoofrCredentialFactory credentialFactory = new KoofrCredentialFactory(httpTransport, jsonFactory, appCredentials);
        Monitor monitor = context.getMonitor();
        int fileUploadReadTimeout = (Integer)context.getSetting("koofrFileUploadReadTimeout", (Object)60000);
        int fileUploadWriteTimeout = (Integer)context.getSetting("koofrFileUploadWriteTimeout", (Object)60000);
        monitor.info(() -> String.format("Configuring Koofr HTTP file upload client with read timeout %d ms and write timeout %d ms", fileUploadReadTimeout, fileUploadWriteTimeout), new Object[0]);
        OkHttpClient fileUploadClient = client.newBuilder().readTimeout((long)fileUploadReadTimeout, TimeUnit.MILLISECONDS).writeTimeout((long)fileUploadReadTimeout, TimeUnit.MILLISECONDS).build();
        KoofrClientFactory koofrClientFactory = new KoofrClientFactory(BASE_API_URL, client, fileUploadClient, mapper, monitor, credentialFactory);
        ImmutableMap.Builder importBuilder = ImmutableMap.builder();
        importBuilder.put((Object)DataVertical.PHOTOS, (Object)new KoofrPhotosImporter(koofrClientFactory, monitor, jobStore));
        importBuilder.put((Object)DataVertical.VIDEOS, (Object)new KoofrVideosImporter(koofrClientFactory, monitor, jobStore));
        this.importerMap = importBuilder.build();
        ImmutableMap.Builder exportBuilder = ImmutableMap.builder();
        exportBuilder.put((Object)DataVertical.PHOTOS, (Object)new KoofrPhotosExporter(koofrClientFactory, monitor));
        exportBuilder.put((Object)DataVertical.VIDEOS, (Object)new KoofrVideosExporter(koofrClientFactory, monitor));
        this.exporterMap = exportBuilder.build();
        this.initialized = true;
    }
}

