/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.videos;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.ArrayMap;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.UnauthenticatedException;
import com.google.auth.Credentials;
import com.google.auth.oauth2.AccessToken;
import com.google.auth.oauth2.UserCredentials;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.google.photos.library.v1.PhotosLibraryClient;
import com.google.photos.library.v1.PhotosLibrarySettings;
import com.google.photos.library.v1.proto.BatchCreateMediaItemsResponse;
import com.google.photos.library.v1.proto.NewMediaItem;
import com.google.photos.library.v1.proto.NewMediaItemResult;
import com.google.photos.library.v1.upload.UploadMediaItemRequest;
import com.google.photos.library.v1.upload.UploadMediaItemResponse;
import com.google.photos.library.v1.util.NewMediaItemFactory;
import com.google.rpc.Status;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GooglePhotosImportUtils;
import org.datatransferproject.datatransfer.google.mediaModels.BatchMediaItemResponse;
import org.datatransferproject.datatransfer.google.mediaModels.MediaItemSearchResponse;
import org.datatransferproject.datatransfer.google.mediaModels.NewMediaItemUpload;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.UploadErrorException;
import org.datatransferproject.types.common.DownloadableFile;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleVideosInterface {
    private static final int ALBUM_PAGE_SIZE = 20;
    private static final int MEDIA_PAGE_SIZE = 50;
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final String TOKEN_KEY = "pageToken";
    private static final String ALBUM_ID_KEY = "albumId";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String FILTERS_KEY = "filters";
    private static final String INCLUDE_ARCHIVED_KEY = "includeArchivedMedia";
    private static final String MEDIA_FILTER_KEY = "mediaTypeFilter";
    private static final String BASE_URL = "https://photoslibrary.googleapis.com/v1/";
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final HttpTransport httpTransport = new NetHttpTransport();
    private final Credential credential;
    private JsonFactory jsonFactory;

    GoogleVideosInterface(Credential credential, JsonFactory jsonFactory) {
        this.credential = credential;
        this.jsonFactory = jsonFactory;
    }

    String uploadVideoContent(InputStream inputStream, String filename) throws IOException {
        InputStreamContent content = new InputStreamContent(null, inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        byte[] contentBytes = outputStream.toByteArray();
        ByteArrayContent httpContent = new ByteArrayContent(null, contentBytes);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/uploads/", Optional.empty(), (HttpContent)httpContent, String.class);
    }

    BatchMediaItemResponse createVideo(NewMediaItemUpload newMediaItemUpload) throws IOException {
        HashMap<String, Object> map = this.createJsonMap(newMediaItemUpload);
        JsonHttpContent httpContent = new JsonHttpContent(this.jsonFactory, map);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/mediaItems:batchCreate", Optional.empty(), (HttpContent)httpContent, BatchMediaItemResponse.class);
    }

    MediaItemSearchResponse listVideoItems(Optional<String> pageToken) throws IOException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PAGE_SIZE_KEY, String.valueOf(50));
        params.put(FILTERS_KEY, (String)ImmutableMap.of((Object)MEDIA_FILTER_KEY, (Object)ImmutableMap.of((Object)"mediaTypes", (Object)ImmutableList.of((Object)"VIDEO"))));
        if (pageToken.isPresent()) {
            params.put(TOKEN_KEY, pageToken.get());
        }
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, params);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/mediaItems:search", Optional.empty(), (HttpContent)content, MediaItemSearchResponse.class);
    }

    <T> T makePostRequest(String url, Optional<Map<String, String>> parameters, HttpContent httpContent, Class<T> clazz) throws IOException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        HttpRequest postRequest = requestFactory.buildPostRequest(new GenericUrl(url + "?" + this.generateParamsString(parameters)), httpContent);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType("application/octet-stream");
        headers.setAuthorization("Bearer " + this.credential.getAccessToken());
        headers.set("X-Goog-Upload-Protocol", (Object)"raw");
        postRequest.setHeaders(headers);
        HttpResponse response = postRequest.execute();
        int statusCode = response.getStatusCode();
        if (statusCode != 200) {
            throw new IOException("Bad status code: " + statusCode + " error: " + response.getStatusMessage());
        }
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        if (clazz.isAssignableFrom(String.class)) {
            return (T)result;
        }
        return (T)this.objectMapper.readValue(result, clazz);
    }

    private String generateParamsString(Optional<Map<String, String>> params) throws IOException {
        ArrayMap updatedParams = new ArrayMap();
        if (params.isPresent()) {
            updatedParams.putAll(params.get());
        }
        if (this.credential.getAccessToken() == null) {
            this.credential.refreshToken();
        }
        updatedParams.put(ACCESS_TOKEN_KEY, (String)Preconditions.checkNotNull((Object)this.credential.getAccessToken()));
        List orderedKeys = updatedParams.keySet().stream().collect(Collectors.toList());
        Collections.sort(orderedKeys);
        ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
        for (String key : orderedKeys) {
            String k = key.trim();
            String v = ((String)updatedParams.get(key)).trim();
            paramStrings.add((CallSite)((Object)(k + "=" + v)));
        }
        return String.join((CharSequence)"&", paramStrings);
    }

    private HashMap<String, Object> createJsonMap(Object object) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (HashMap)this.objectMapper.readValue(this.objectMapper.writeValueAsString(object), (TypeReference)typeRef);
    }

    public static PhotosLibraryClient buildPhotosLibraryClient(AppCredentials appCredentials, TokensAndUrlAuthData authData) throws IOException {
        PhotosLibrarySettings settings = PhotosLibrarySettings.newBuilder().setCredentialsProvider((CredentialsProvider)FixedCredentialsProvider.create((Credentials)UserCredentials.newBuilder().setClientId(appCredentials.getKey()).setClientSecret(appCredentials.getSecret()).setAccessToken(new AccessToken(authData.getAccessToken(), new Date())).setRefreshToken(authData.getRefreshToken()).build())).build();
        return PhotosLibraryClient.initialize((PhotosLibrarySettings)settings);
    }

    private static boolean isTokenException(String message) {
        return message.contains("invalid_grant") || message.contains("The upload could not be initialized. Unauthorized");
    }

    public static Pair<String, Long> uploadVideo(UUID jobId, VideoModel video, PhotosLibraryClient photosLibraryClient, TemporaryPerJobDataStore dataStore, ConnectionProvider connectionProvider) throws IOException, UploadErrorException, InvalidTokenException {
        File tmp = GoogleVideosInterface.createTempFile(jobId, dataStore, connectionProvider, (DownloadableFile)video);
        try {
            UploadMediaItemRequest uploadRequest = UploadMediaItemRequest.newBuilder().setFileName(video.getName()).setDataFile(new RandomAccessFile(tmp, "r")).build();
            UploadMediaItemResponse uploadResponse = photosLibraryClient.uploadMediaItem(uploadRequest);
            if (uploadResponse.getError().isPresent() || !uploadResponse.getUploadToken().isPresent()) {
                UploadMediaItemResponse.Error error = uploadResponse.getError().orElse(null);
                if (error != null) {
                    Throwable cause = error.getCause();
                    String message = cause.getMessage();
                    if (message.contains("The upload url is either finalized or rejected by the server")) {
                        throw new UploadErrorException("Upload was terminated because of error", cause);
                    }
                    if (GoogleVideosInterface.isTokenException(message)) {
                        throw new InvalidTokenException("Token has been expired or revoked", cause);
                    }
                }
                throw new IOException("An error was encountered while uploading the video.", error != null ? error.getCause() : null);
            }
            String uploadToken = (String)uploadResponse.getUploadToken().get();
            Pair pair = Pair.of((Object)uploadToken, (Object)tmp.length());
            return pair;
        }
        catch (ApiException ex) {
            Throwable cause = ex.getCause();
            String message = cause.getMessage();
            if (GoogleVideosInterface.isTokenException(message)) {
                throw new InvalidTokenException("Token has been expired or revoked", cause);
            }
            throw new IOException("An error was encountered while uploading the video.", cause);
        }
        finally {
            tmp.delete();
        }
    }

    private static File createTempFile(UUID jobId, TemporaryPerJobDataStore dataStore, ConnectionProvider connectionProvider, DownloadableFile video) throws IOException {
        String fileSuffix = "mp4";
        return GoogleVideosInterface.createTempFile(jobId, dataStore, connectionProvider, video, "mp4");
    }

    private static File createTempFile(UUID jobId, TemporaryPerJobDataStore dataStore, ConnectionProvider connectionProvider, DownloadableFile item, String fileSuffix) throws IOException {
        try (InputStream is = connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)item).getStream();){
            File file = dataStore.getTempFileFromInputStream(is, item.getName(), fileSuffix);
            return file;
        }
    }

    @VisibleForTesting
    public static long uploadBatchOfVideos(UUID jobId, List<VideoModel> batchedVideos, TemporaryPerJobDataStore dataStore, PhotosLibraryClient client, IdempotentImportExecutor executor, ConnectionProvider connectionProvider, Monitor monitor) throws Exception {
        ArrayListMultimap mediaItemsByAlbum = ArrayListMultimap.create();
        HashMap<String, VideoModel> uploadTokenToDataId = new HashMap<String, VideoModel>();
        HashMap<String, Long> uploadTokenToLength = new HashMap<String, Long>();
        try {
            for (VideoModel video : batchedVideos) {
                try {
                    Pair<String, Long> pair = GoogleVideosInterface.uploadVideo(jobId, video, client, dataStore, connectionProvider);
                    String uploadToken = (String)pair.getLeft();
                    String string = Strings.isNullOrEmpty((String)video.getAlbumId()) ? null : (String)((Object)executor.getCachedValue(video.getAlbumId()));
                    mediaItemsByAlbum.put((Object)string, (Object)GoogleVideosInterface.buildMediaItem(video, uploadToken));
                    uploadTokenToDataId.put(uploadToken, video);
                    uploadTokenToLength.put(uploadToken, (Long)pair.getRight());
                    if (!video.isInTempStore()) continue;
                    dataStore.removeData(jobId, video.getFetchableUrl());
                }
                catch (IOException e) {
                    if (e instanceof FileNotFoundException) {
                        monitor.info(() -> String.format("Video resource was missing for id: %s", video.getIdempotentId()), new Object[]{e});
                        continue;
                    }
                    executor.importAndSwallowIOExceptions((ImportableItem)video, videoModel -> ItemImportResult.error((Exception)e, null));
                }
            }
            if (mediaItemsByAlbum.isEmpty()) {
                return 0L;
            }
            List resultsList = mediaItemsByAlbum.keySet().stream().map(k -> k == null ? client.batchCreateMediaItems(mediaItemsByAlbum.get(null)) : client.batchCreateMediaItems(k, mediaItemsByAlbum.get(k))).map(BatchCreateMediaItemsResponse::getNewMediaItemResultsList).flatMap(Collection::stream).collect(Collectors.toList());
            long bytes = 0L;
            for (NewMediaItemResult newMediaItemResult : resultsList) {
                String uploadToken = newMediaItemResult.getUploadToken();
                Status status = newMediaItemResult.getStatus();
                VideoModel video = (VideoModel)uploadTokenToDataId.get(uploadToken);
                Preconditions.checkNotNull((Object)video);
                int code = status.getCode();
                Long length = (Long)uploadTokenToLength.get(uploadToken);
                if (code == 0) {
                    executor.importAndSwallowIOExceptions((ImportableItem)video, videoModel -> ItemImportResult.success((Serializable)((Object)result.getMediaItem().getId()), (Long)length));
                    if (length != null) {
                        bytes += length.longValue();
                    }
                } else {
                    executor.importAndSwallowIOExceptions((ImportableItem)video, videoModel -> ItemImportResult.error((Exception)new IOException(String.format("Video item could not be created. Code: %d Message: %s", code, result.getStatus().getMessage())), (Long)length));
                }
                uploadTokenToDataId.remove(uploadToken);
            }
            if (!uploadTokenToDataId.isEmpty()) {
                for (Map.Entry entry : uploadTokenToDataId.entrySet()) {
                    VideoModel video = (VideoModel)entry.getValue();
                    String uploadToken = (String)entry.getKey();
                    executor.importAndSwallowIOExceptions((ImportableItem)video, videoModel -> ItemImportResult.error((Exception)new IOException("Video item was missing from results list."), (Long)((Long)uploadTokenToLength.get(uploadToken))));
                }
            }
            return bytes;
        }
        catch (InvalidArgumentException e) {
            if (e.getMessage().contains("The remaining storage in the user's account is not enough")) {
                throw new DestinationMemoryFullException("Google destination storage full", (Throwable)e);
            }
            throw e;
        }
        catch (UnauthenticatedException e) {
            throw new InvalidTokenException("Token has been expired or revoked", (Throwable)e);
        }
    }

    @VisibleForTesting
    public static NewMediaItem buildMediaItem(VideoModel inputVideo, String uploadToken) {
        NewMediaItem newMediaItem;
        String videoDescription = inputVideo.getDescription();
        if (Strings.isNullOrEmpty((String)videoDescription)) {
            newMediaItem = NewMediaItemFactory.createNewMediaItem((String)uploadToken);
        } else {
            videoDescription = GooglePhotosImportUtils.cleanDescription(videoDescription);
            newMediaItem = NewMediaItemFactory.createNewMediaItem((String)uploadToken, (String)videoDescription);
        }
        return newMediaItem;
    }
}

