/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.videos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.google.photos.library.v1.PhotosLibraryClient;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GooglePhotosImportUtils;
import org.datatransferproject.datatransfer.google.videos.GoogleVideosInterface;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.videos.VideoAlbum;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleVideosImporter
implements Importer<TokensAndUrlAuthData, VideosContainerResource> {
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;
    private final AppCredentials appCredentials;
    private final TemporaryPerJobDataStore dataStore;
    private final Map<UUID, PhotosLibraryClient> clientsMap;

    public GoogleVideosImporter(AppCredentials appCredentials, TemporaryPerJobDataStore dataStore, Monitor monitor) {
        this(appCredentials, dataStore, monitor, new ConnectionProvider(dataStore), new HashMap<UUID, PhotosLibraryClient>());
    }

    @VisibleForTesting
    GoogleVideosImporter(AppCredentials appCredentials, TemporaryPerJobDataStore dataStore, Monitor monitor, ConnectionProvider connectionProvider, Map<UUID, PhotosLibraryClient> clientsMap) {
        this.connectionProvider = connectionProvider;
        this.monitor = monitor;
        this.appCredentials = appCredentials;
        this.dataStore = dataStore;
        this.clientsMap = clientsMap;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor executor, TokensAndUrlAuthData authData, VideosContainerResource data) throws Exception {
        PhotosLibraryClient client;
        if (data == null) {
            return ImportResult.OK;
        }
        if (this.clientsMap.containsKey(jobId)) {
            client = this.clientsMap.get(jobId);
        } else {
            client = GoogleVideosInterface.buildPhotosLibraryClient(this.appCredentials, authData);
            this.clientsMap.put(jobId, client);
        }
        for (VideoAlbum album : data.getAlbums()) {
            executor.importAndSwallowIOExceptions((ImportableItem)album, a -> {
                String title = GooglePhotosImportUtils.cleanAlbumTitle(a.getName());
                return ItemImportResult.success((Serializable)((Object)client.createAlbum(title).getId()));
            });
        }
        long bytes = 0L;
        Collection videos = data.getVideos();
        if (videos != null && videos.size() > 0) {
            Stream<VideoModel> stream = videos.stream().filter(video -> this.shouldImport((DownloadableItem)video, executor)).map(this::transformVideoName);
            UnmodifiableIterator batches = Iterators.partition(stream.iterator(), (int)49);
            while (batches.hasNext()) {
                long batchBytes = GoogleVideosInterface.uploadBatchOfVideos(jobId, (List)batches.next(), this.dataStore, client, executor, this.connectionProvider, this.monitor);
                bytes += batchBytes;
            }
        }
        ImportResult result = ImportResult.OK;
        return result.copyWithBytes(Long.valueOf(bytes));
    }

    private boolean shouldImport(DownloadableItem item, IdempotentImportExecutor executor) {
        if (item.getFetchableUrl() == null) {
            this.monitor.info(() -> "Content Url is empty. Make sure that you provide a valid content Url.", new Object[0]);
            return false;
        }
        return !executor.isKeyCached(item.getIdempotentId());
    }

    private VideoModel transformVideoName(VideoModel video) {
        String filename = Strings.isNullOrEmpty((String)video.getName()) ? "untitled" : video.getName();
        video.setName(filename);
        return video;
    }
}

