/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.photos;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.ByteArrayContent;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.InputStreamContent;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.http.json.JsonHttpContent;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.ArrayMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.CharStreams;
import com.google.common.util.concurrent.RateLimiter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.mediaModels.AlbumListResponse;
import org.datatransferproject.datatransfer.google.mediaModels.BatchMediaItemResponse;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleAlbum;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleMediaItem;
import org.datatransferproject.datatransfer.google.mediaModels.MediaItemSearchResponse;
import org.datatransferproject.datatransfer.google.mediaModels.NewMediaItemUpload;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.spi.transfer.types.UploadErrorException;

public class GooglePhotosInterface {
    public static final String ERROR_HASH_MISMATCH = "Hash mismatch";
    private static final String GOOG_ERROR_HASH_MISMATCH_LEGACY = "Checksum from header does not match received payload content.";
    private static final String GOOG_ERROR_HASH_MISMATCH_UNIFIED = "User-provided checksum does not match received payload content.";
    private static final String GOOGPHOTOS_ALBUMS_PERMISSION_ERROR = "The caller does not have permission";
    private static final String GOOGPHOTOS_PHOTO_PERMISSION_ERROR = "Google Photos is disabled for the user";
    private static final String BASE_URL = "https://photoslibrary.googleapis.com/v1/";
    private static final int ALBUM_PAGE_SIZE = 20;
    private static final int MEDIA_PAGE_SIZE = 50;
    private static final String PAGE_SIZE_KEY = "pageSize";
    private static final String TOKEN_KEY = "pageToken";
    private static final String ALBUM_ID_KEY = "albumId";
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String FILTERS_KEY = "filters";
    private static final String INCLUDE_ARCHIVED_KEY = "includeArchivedMedia";
    private static final Map<String, String> PHOTO_UPLOAD_PARAMS = ImmutableMap.of((Object)"Content-type", (Object)"application/octet-stream", (Object)"X-Goog-Upload-Protocol", (Object)"raw");
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private final HttpTransport httpTransport = new NetHttpTransport();
    private Credential credential;
    private final JsonFactory jsonFactory;
    private final Monitor monitor;
    private final GoogleCredentialFactory credentialFactory;
    private final RateLimiter writeRateLimiter;

    public GooglePhotosInterface(GoogleCredentialFactory credentialFactory, Credential credential, JsonFactory jsonFactory, Monitor monitor, double writesPerSecond) {
        this.credentialFactory = credentialFactory;
        this.credential = credential;
        this.jsonFactory = jsonFactory;
        this.monitor = monitor;
        this.writeRateLimiter = RateLimiter.create((double)writesPerSecond);
    }

    public AlbumListResponse listAlbums(Optional<String> pageToken) throws IOException, InvalidTokenException, PermissionDeniedException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PAGE_SIZE_KEY, String.valueOf(20));
        if (pageToken.isPresent()) {
            params.put(TOKEN_KEY, pageToken.get());
        }
        return this.makeGetRequest("https://photoslibrary.googleapis.com/v1/albums", Optional.of(params), AlbumListResponse.class);
    }

    public GoogleAlbum getAlbum(String albumId) throws IOException, InvalidTokenException, PermissionDeniedException {
        LinkedHashMap params = new LinkedHashMap();
        return this.makeGetRequest("https://photoslibrary.googleapis.com/v1/albums/" + albumId, Optional.of(params), GoogleAlbum.class);
    }

    public GoogleMediaItem getMediaItem(String mediaId) throws IOException, InvalidTokenException, PermissionDeniedException {
        LinkedHashMap params = new LinkedHashMap();
        return this.makeGetRequest("https://photoslibrary.googleapis.com/v1/mediaItems/" + mediaId, Optional.of(params), GoogleMediaItem.class);
    }

    public MediaItemSearchResponse listMediaItems(Optional<String> albumId, Optional<String> pageToken) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        params.put(PAGE_SIZE_KEY, String.valueOf(50));
        if (albumId.isPresent()) {
            params.put(ALBUM_ID_KEY, albumId.get());
        } else {
            params.put(FILTERS_KEY, (String)ImmutableMap.of((Object)INCLUDE_ARCHIVED_KEY, (Object)String.valueOf(true)));
        }
        if (pageToken.isPresent()) {
            params.put(TOKEN_KEY, pageToken.get());
        }
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, params);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/mediaItems:search", Optional.empty(), Optional.empty(), (HttpContent)content, MediaItemSearchResponse.class);
    }

    public GoogleAlbum createAlbum(GoogleAlbum googleAlbum) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        HashMap<String, Object> albumMap = this.createJsonMap(googleAlbum);
        ImmutableMap contentMap = ImmutableMap.of((Object)"album", albumMap);
        JsonHttpContent content = new JsonHttpContent(this.jsonFactory, (Object)contentMap);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/albums", Optional.empty(), Optional.empty(), (HttpContent)content, GoogleAlbum.class);
    }

    public String uploadMediaContent(InputStream inputStream, @Nullable String sha1) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        InputStreamContent content = new InputStreamContent(null, inputStream);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        content.writeTo((OutputStream)outputStream);
        byte[] contentBytes = outputStream.toByteArray();
        if (contentBytes.length == 0) {
            return "EMPTY_PHOTO";
        }
        ByteArrayContent httpContent = new ByteArrayContent(null, contentBytes);
        ImmutableMap.Builder headers = ImmutableMap.builder();
        if (sha1 != null && !sha1.isEmpty()) {
            Preconditions.checkState((sha1.length() == 40 ? 1 : 0) != 0, (Object)"Invalid SHA-1 string.");
            headers.put((Object)"X-Goog-Hash", (Object)("sha1=" + Base64.getEncoder().encodeToString(BaseEncoding.base16().decode((CharSequence)sha1.toUpperCase()))));
        }
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/uploads/", Optional.of(PHOTO_UPLOAD_PARAMS), Optional.of(headers.build()), (HttpContent)httpContent, String.class);
    }

    public BatchMediaItemResponse createPhotos(NewMediaItemUpload newMediaItemUpload) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        HashMap<String, Object> map = this.createJsonMap(newMediaItemUpload);
        JsonHttpContent httpContent = new JsonHttpContent(this.jsonFactory, map);
        return this.makePostRequest("https://photoslibrary.googleapis.com/v1/mediaItems:batchCreate", Optional.empty(), Optional.empty(), (HttpContent)httpContent, BatchMediaItemResponse.class);
    }

    private <T> T makeGetRequest(String url, Optional<Map<String, String>> parameters, Class<T> clazz) throws IOException, InvalidTokenException, PermissionDeniedException {
        HttpResponse response;
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        try {
            response = this.makeHttpRequest(() -> requestFactory.buildGetRequest(new GenericUrl(url + "?" + this.generateParamsString(parameters))));
        }
        catch (UploadErrorException e) {
            throw new IllegalStateException("GET request unexpectedly produced Upload exception", e);
        }
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        return (T)this.objectMapper.readValue(result, clazz);
    }

    public <T> T makePostRequest(String url, Optional<Map<String, String>> parameters, Optional<Map<String, String>> extraHeaders, HttpContent httpContent, Class<T> clazz) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        HttpRequestFactory requestFactory = this.httpTransport.createRequestFactory();
        HttpResponse response = this.makeHttpRequest(() -> {
            this.writeRateLimiter.acquire();
            HttpRequest postRequest = requestFactory.buildPostRequest(new GenericUrl(url + "?" + this.generateParamsString(parameters)), httpContent);
            extraHeaders.ifPresent(stringStringMap -> stringStringMap.forEach((key, value) -> postRequest.getHeaders().set(key, value)));
            postRequest.setReadTimeout(120000);
            return postRequest;
        });
        String result = CharStreams.toString((Readable)new InputStreamReader(response.getContent(), StandardCharsets.UTF_8));
        if (clazz.isAssignableFrom(String.class)) {
            return (T)result;
        }
        return (T)this.objectMapper.readValue(result, clazz);
    }

    private HttpResponse makeHttpRequest(SupplierWithIO<HttpRequest> httpRequest) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        HttpResponse response = null;
        HttpRequest firstReq = httpRequest.getWithIO();
        try {
            response = firstReq.execute();
        }
        catch (HttpResponseException firstReqException) {
            Optional<Object> maybeTokenRefreshedRetry = Optional.empty();
            try {
                maybeTokenRefreshedRetry = this.maybeRetryWithFreshToken(httpRequest, firstReqException);
            }
            catch (HttpResponseException tokenRefreshedRetryException) {
                this.rethrowForDtpStandards(tokenRefreshedRetryException.getStatusCode(), Optional.of(tokenRefreshedRetryException), Optional.empty());
            }
            if (maybeTokenRefreshedRetry.isPresent()) {
                response = (HttpResponse)maybeTokenRefreshedRetry.get();
            }
            this.rethrowForDtpStandards(firstReqException.getStatusCode(), Optional.of(firstReqException), Optional.empty());
        }
        Preconditions.checkNotNull((Object)response, (Object)"bug? response should be set, else DTP error already thrown, but neither happened?");
        if (response.getStatusCode() != 200) {
            this.rethrowForDtpStandards(response.getStatusCode(), Optional.empty(), Optional.ofNullable(response));
        }
        return response;
    }

    private Optional<HttpResponse> maybeRetryWithFreshToken(SupplierWithIO<HttpRequest> httpRequest, HttpResponseException e) throws IOException, InvalidTokenException {
        int statusCode = e.getStatusCode();
        if (statusCode != 401) {
            return Optional.empty();
        }
        this.monitor.info(() -> String.format("GooglePhotosInterface: Attempting to refresh authorization token due to HTTP response code=%s, %s\n", new Object[]{statusCode, e}), new Object[0]);
        this.credential = this.credentialFactory.refreshCredential(this.credential);
        this.monitor.info(() -> "GooglePhotosInterface: Refreshed authorization token successfully", new Object[0]);
        return Optional.of(httpRequest.getWithIO().execute());
    }

    private void rethrowForDtpStandards(int statusCode, Optional<HttpResponseException> maybeException, Optional<HttpResponse> maybeResponse) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        String emptyServerMessage = "[no server message: have neither response nor exception]";
        Optional<Object> serverMessage = maybeException.isPresent() ? Optional.of(maybeException.get().getContent()) : (maybeResponse.isPresent() ? Optional.of(maybeResponse.get().getStatusMessage()) : Optional.empty());
        if (statusCode == 403 && (serverMessage.orElse("").contains(GOOGPHOTOS_ALBUMS_PERMISSION_ERROR) || ((String)serverMessage.orElse("")).contains(GOOGPHOTOS_PHOTO_PERMISSION_ERROR))) {
            throw new PermissionDeniedException("User permission to google photos was denied", (Throwable)maybeException.orElse(null));
        }
        if (statusCode == 400 && (((String)serverMessage.orElse("")).contains(GOOG_ERROR_HASH_MISMATCH_LEGACY) || ((String)serverMessage.orElse("")).contains(GOOG_ERROR_HASH_MISMATCH_UNIFIED))) {
            IOException throwableForBadResponse = new IOException(String.format("non-error HTTP response statusCode=%s: %s", statusCode, serverMessage.orElse("[no server message: have neither response nor exception]")));
            Throwable cause = maybeException.map(e -> e).orElse(throwableForBadResponse);
            throw new UploadErrorException(ERROR_HASH_MISMATCH, cause);
        }
        throw new IOException(String.format("Bad HTTP response: status code=%s, Error='%s' Content: %s", statusCode, maybeException.map(e -> e.getStatusMessage()).orElse("[no HTTP error]"), serverMessage.orElse("[no server message: have neither response nor exception]")));
    }

    private String generateParamsString(Optional<Map<String, String>> params) {
        ArrayMap updatedParams = new ArrayMap();
        if (params.isPresent()) {
            updatedParams.putAll(params.get());
        }
        updatedParams.put(ACCESS_TOKEN_KEY, (String)Preconditions.checkNotNull((Object)this.credential.getAccessToken()));
        List orderedKeys = updatedParams.keySet().stream().collect(Collectors.toList());
        Collections.sort(orderedKeys);
        ArrayList<CallSite> paramStrings = new ArrayList<CallSite>();
        for (String key : orderedKeys) {
            String k = key.trim();
            String v = ((String)updatedParams.get(key)).trim();
            paramStrings.add((CallSite)((Object)(k + "=" + v)));
        }
        return String.join((CharSequence)"&", paramStrings);
    }

    private HashMap<String, Object> createJsonMap(Object object) throws IOException {
        TypeReference<HashMap<String, Object>> typeRef = new TypeReference<HashMap<String, Object>>(){};
        return (HashMap)this.objectMapper.readValue(this.objectMapper.writeValueAsString(object), (TypeReference)typeRef);
    }

    private static interface SupplierWithIO<T> {
        public T getWithIO() throws IOException;
    }
}

