/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.musicModels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.protobuf.Duration;
import com.google.protobuf.util.Durations;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Objects;
import org.datatransferproject.datatransfer.google.musicModels.GoogleArtist;
import org.datatransferproject.datatransfer.google.musicModels.GoogleRelease;

public class GoogleTrack {
    @JsonProperty(value="isrc")
    private String isrc;
    @JsonProperty(value="releaseReference")
    private GoogleRelease releaseReference;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="artistReferences")
    private GoogleArtist[] artistReferences;
    @JsonProperty(value="duration")
    private String duration;
    @JsonProperty(value="explicitType")
    private String explicitType;

    public String getIsrc() {
        return this.isrc;
    }

    public GoogleRelease getReleaseReference() {
        return this.releaseReference;
    }

    public String getTitle() {
        return this.title;
    }

    public GoogleArtist[] getArtistReferences() {
        return this.artistReferences;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getExplicitType() {
        return this.explicitType;
    }

    public long convertDurationToMillions() throws ParseException {
        if (this.duration == null || this.duration.isEmpty()) {
            return 0L;
        }
        return Durations.toMillis((Duration)Durations.parse((String)this.duration));
    }

    public void setIsrc(String isrc) {
        this.isrc = isrc;
    }

    public void setReleaseReference(GoogleRelease releaseReference) {
        this.releaseReference = releaseReference;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setArtistReferences(GoogleArtist[] artistReferences) {
        this.artistReferences = artistReferences;
    }

    public void setDuration(String duration) {
        this.duration = duration;
    }

    public void setExplicitType(String explicitType) {
        this.explicitType = explicitType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GoogleTrack)) {
            return false;
        }
        GoogleTrack that = (GoogleTrack)o;
        return Objects.equals(this.isrc, that.isrc) && Objects.equals(this.releaseReference, that.releaseReference) && Objects.equals(this.title, that.title) && Arrays.equals(this.artistReferences, that.artistReferences) && Objects.equals(this.duration, that.duration) && Objects.equals(this.explicitType, that.explicitType);
    }

    public int hashCode() {
        return Objects.hash(this.getIsrc(), this.getReleaseReference(), this.getTitle(), Arrays.hashCode(this.getArtistReferences()), this.getDuration(), this.getExplicitType());
    }
}

