/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.mediaModels;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Optional;
import org.apache.tika.Tika;
import org.datatransferproject.datatransfer.google.mediaModels.MediaMetadata;
import org.datatransferproject.types.common.models.FavoriteInfo;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.videos.VideoModel;

public class GoogleMediaItem
implements Serializable {
    public static final Tika TIKA = new Tika();
    private static final String DEFAULT_PHOTO_MIMETYPE = "image/jpg";
    private static final String DEFAULT_VIDEO_MIMETYPE = "video/mp4";
    private static final String DEFAULT_BINARY_MIMETYPE = "application/octet-stream";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="baseUrl")
    private String baseUrl;
    @JsonProperty(value="mimeType")
    private String mimeType;
    @JsonProperty(value="mediaMetadata")
    private MediaMetadata mediaMetadata;
    @JsonProperty(value="filename")
    private String filename;
    @JsonProperty(value="productUrl")
    private String productUrl;
    @JsonProperty(value="uploadedTime")
    private Date uploadedTime;
    @JsonProperty(value="favoriteInfo")
    private FavoriteInfo favoriteInfo;

    public boolean isPhoto() {
        return this.getMediaMetadata().getPhoto() != null;
    }

    public boolean isVideo() {
        return this.getMediaMetadata().getVideo() != null;
    }

    public String getFetchableUrl() {
        if (this.isPhoto()) {
            return this.getBaseUrl() + "=d";
        }
        if (this.isVideo()) {
            return this.getBaseUrl() + "=dv";
        }
        throw new IllegalArgumentException("unimplemented media type");
    }

    public static VideoModel convertToVideoModel(Optional<String> albumId, GoogleMediaItem mediaItem) throws ParseException {
        Preconditions.checkArgument((boolean)mediaItem.isVideo());
        return new VideoModel(mediaItem.getFilename(), mediaItem.getFetchableUrl(), mediaItem.getDescription(), GoogleMediaItem.getMimeType(mediaItem), mediaItem.getId(), (String)albumId.orElse(null), false, GoogleMediaItem.getCreationTime(mediaItem), new FavoriteInfo(GoogleMediaItem.getFavorite(mediaItem), GoogleMediaItem.getLastUpdateTime(mediaItem)));
    }

    public static PhotoModel convertToPhotoModel(Optional<String> albumId, GoogleMediaItem mediaItem) throws ParseException {
        Preconditions.checkArgument((boolean)mediaItem.isPhoto());
        return new PhotoModel(mediaItem.getFilename(), mediaItem.getFetchableUrl(), mediaItem.getDescription(), GoogleMediaItem.getMimeType(mediaItem), mediaItem.getId(), (String)albumId.orElse(null), false, null, GoogleMediaItem.getCreationTime(mediaItem), new FavoriteInfo(GoogleMediaItem.getFavorite(mediaItem), GoogleMediaItem.getLastUpdateTime(mediaItem)));
    }

    @VisibleForTesting
    public static Date parseIso8601DateTime(String zonedIso8601DateTime) throws ParseException {
        return Date.from(DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)zonedIso8601DateTime, Instant::from));
    }

    private static Date getCreationTime(GoogleMediaItem mediaItem) throws ParseException {
        String zonedIso8601DateTime = mediaItem.getMediaMetadata().getCreationTime();
        try {
            return GoogleMediaItem.parseIso8601DateTime(zonedIso8601DateTime);
        }
        catch (ParseException parseException) {
            throw new ParseException(String.format("Failed parsing creation time from \"%s\" for MediaItem %s", mediaItem.getMediaMetadata().getCreationTime(), mediaItem.getId()), parseException.getErrorOffset());
        }
    }

    private static String getMimeType(GoogleMediaItem mediaItem) {
        String guessedMimetype = GoogleMediaItem.guessMimeTypeFromFilename(mediaItem.getFilename());
        if (!Strings.isNullOrEmpty((String)guessedMimetype)) {
            return guessedMimetype;
        }
        if (!Strings.isNullOrEmpty((String)mediaItem.getMimeType())) {
            return mediaItem.getMimeType();
        }
        if (mediaItem.isPhoto()) {
            return DEFAULT_PHOTO_MIMETYPE;
        }
        return DEFAULT_VIDEO_MIMETYPE;
    }

    private static String guessMimeTypeFromFilename(String filename) {
        try {
            String mimeType = TIKA.detect(filename);
            if (mimeType.equals(DEFAULT_BINARY_MIMETYPE)) {
                return null;
            }
            return mimeType;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getProductUrl() {
        return this.productUrl;
    }

    public MediaMetadata getMediaMetadata() {
        return this.mediaMetadata;
    }

    public void setMediaMetadata(MediaMetadata mediaMetadata) {
        this.mediaMetadata = mediaMetadata;
    }

    public Date getUploadedTime() {
        return this.uploadedTime;
    }

    public void setUploadedTime(Date date) {
        this.uploadedTime = date;
    }

    public void setFavoriteInfo(FavoriteInfo favoriteInfo) {
        this.favoriteInfo = favoriteInfo;
    }

    public static boolean getFavorite(GoogleMediaItem mediaItem) {
        return mediaItem.favoriteInfo != null && mediaItem.favoriteInfo.getFavorited();
    }

    public static Date getLastUpdateTime(GoogleMediaItem mediaItem) throws ParseException {
        return mediaItem.favoriteInfo == null || mediaItem.favoriteInfo.getLastUpdateTime() == null ? GoogleMediaItem.getCreationTime(mediaItem) : mediaItem.favoriteInfo.getLastUpdateTime();
    }
}

