/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.media;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.FailedToListAlbumsException;
import org.datatransferproject.datatransfer.google.common.FailedToListMediaItemsException;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.common.GoogleErrorLogger;
import org.datatransferproject.datatransfer.google.mediaModels.AlbumListResponse;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleAlbum;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleMediaItem;
import org.datatransferproject.datatransfer.google.mediaModels.MediaItemSearchResponse;
import org.datatransferproject.datatransfer.google.photos.GooglePhotosInterface;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.spi.transfer.types.TempMediaData;
import org.datatransferproject.spi.transfer.types.UploadErrorException;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.media.MediaAlbum;
import org.datatransferproject.types.common.models.media.MediaContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;
import org.datatransferproject.types.transfer.errors.ErrorDetail;

public class GoogleMediaExporter
implements Exporter<TokensAndUrlAuthData, MediaContainerResource> {
    private static final double MAX_WRITES_PER_SECOND = 1.0;
    static final String ALBUM_TOKEN_PREFIX = "album:";
    static final String MEDIA_TOKEN_PREFIX = "media:";
    private final GoogleCredentialFactory credentialFactory;
    private final JobStore jobStore;
    private final JsonFactory jsonFactory;
    private final Monitor monitor;
    private volatile GooglePhotosInterface photosInterface;
    private IdempotentImportExecutor retryingExecutor;
    private Boolean enableRetrying;

    public GoogleMediaExporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor) {
        this(credentialFactory, jobStore, jsonFactory, monitor, null);
    }

    @VisibleForTesting
    GoogleMediaExporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor, @Nullable GooglePhotosInterface photosInterface) {
        this(credentialFactory, jobStore, jsonFactory, monitor, photosInterface, null, false);
    }

    @VisibleForTesting
    public GoogleMediaExporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor, @Nullable GooglePhotosInterface photosInterface, @Nullable IdempotentImportExecutor retryingExecutor, boolean enableRetrying) {
        this.credentialFactory = credentialFactory;
        this.jobStore = jobStore;
        this.jsonFactory = jsonFactory;
        this.photosInterface = photosInterface;
        this.monitor = monitor;
        this.retryingExecutor = retryingExecutor;
        this.enableRetrying = enableRetrying;
    }

    @VisibleForTesting
    static InputStream convertJsonToInputStream(Object jsonObject) throws JsonProcessingException {
        String tempString = new ObjectMapper().writeValueAsString(jsonObject);
        return new ByteArrayInputStream(tempString.getBytes(StandardCharsets.UTF_8));
    }

    private static String createCacheKey() {
        return "tempMediaData";
    }

    public ExportResult<MediaContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws UploadErrorException, FailedToListAlbumsException, InvalidTokenException, PermissionDeniedException, IOException, FailedToListMediaItemsException {
        boolean paginationDataPresent;
        if (!exportInformation.isPresent()) {
            this.populateContainedMediaList(jobId, authData);
            return this.exportAlbums(authData, Optional.empty(), jobId);
        }
        if (exportInformation.get().getContainerResource() instanceof PhotosContainerResource) {
            return this.exportPhotosContainer((PhotosContainerResource)exportInformation.get().getContainerResource(), authData, jobId);
        }
        if (exportInformation.get().getContainerResource() instanceof MediaContainerResource) {
            return this.exportMediaContainer((MediaContainerResource)exportInformation.get().getContainerResource(), authData, jobId);
        }
        StringPaginationToken paginationToken = (StringPaginationToken)exportInformation.get().getPaginationData();
        IdOnlyContainerResource idOnlyContainerResource = (IdOnlyContainerResource)exportInformation.get().getContainerResource();
        boolean containerResourcePresent = idOnlyContainerResource != null;
        boolean bl = paginationDataPresent = paginationToken != null;
        if (!containerResourcePresent && paginationDataPresent && paginationToken.getToken().startsWith(ALBUM_TOKEN_PREFIX)) {
            return this.exportAlbums(authData, Optional.of(paginationToken), jobId);
        }
        return this.exportMedia(authData, Optional.ofNullable(idOnlyContainerResource), Optional.ofNullable(paginationToken), jobId);
    }

    private ExportResult<MediaContainerResource> exportPhotosContainer(PhotosContainerResource container, TokensAndUrlAuthData authData, UUID jobId) throws IOException, InvalidTokenException, PermissionDeniedException {
        ImmutableList.Builder albumBuilder = ImmutableList.builder();
        ImmutableList.Builder photosBuilder = ImmutableList.builder();
        ArrayList<IdOnlyContainerResource> subResources = new ArrayList<IdOnlyContainerResource>();
        for (Object album : container.getAlbums()) {
            GoogleAlbum googleAlbum = this.getGoogleAlbum(album.getIdempotentId(), album.getId(), album.getName(), authData);
            if (googleAlbum == null) continue;
            albumBuilder.add((Object)new MediaAlbum(googleAlbum.getId(), googleAlbum.getTitle(), null));
            subResources.add(new IdOnlyContainerResource(googleAlbum.getId()));
        }
        ImmutableList.Builder errors = ImmutableList.builder();
        for (PhotoModel photo : container.getPhotos()) {
            GoogleMediaItem googleMediaItem = this.getGoogleMediaItem(photo.getIdempotentId(), photo.getDataId(), photo.getName(), authData);
            if (googleMediaItem == null) continue;
            try {
                photosBuilder.add((Object)GoogleMediaItem.convertToPhotoModel(Optional.empty(), googleMediaItem));
            }
            catch (ParseException e) {
                this.monitor.info(() -> "Parse exception occurred while converting photo, skipping this item. Failure message : %s ", new Object[]{e.getMessage()});
                errors.add((Object)GoogleErrorLogger.createErrorDetail(googleMediaItem.getId(), googleMediaItem.getFilename(), e, true));
            }
        }
        GoogleErrorLogger.logFailedItemErrors(this.jobStore, jobId, (ImmutableList<ErrorDetail>)errors.build());
        MediaContainerResource mediaContainerResource = new MediaContainerResource((Collection)albumBuilder.build(), (Collection)photosBuilder.build(), null);
        ContinuationData continuationData = new ContinuationData(null);
        subResources.forEach(resource -> continuationData.addContainerResource((ContainerResource)resource));
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)mediaContainerResource, continuationData);
    }

    private ExportResult<MediaContainerResource> exportMediaContainer(MediaContainerResource container, TokensAndUrlAuthData authData, UUID jobId) throws IOException, InvalidTokenException, PermissionDeniedException {
        ImmutableList.Builder albumBuilder = ImmutableList.builder();
        ImmutableList.Builder photosBuilder = ImmutableList.builder();
        ImmutableList.Builder videosBuilder = ImmutableList.builder();
        ArrayList<IdOnlyContainerResource> subResources = new ArrayList<IdOnlyContainerResource>();
        for (Object album : container.getAlbums()) {
            GoogleAlbum googleAlbum = this.getGoogleAlbum(album.getIdempotentId(), album.getId(), album.getName(), authData);
            if (googleAlbum == null) continue;
            albumBuilder.add((Object)new MediaAlbum(googleAlbum.getId(), googleAlbum.getTitle(), null));
            subResources.add(new IdOnlyContainerResource(googleAlbum.getId()));
        }
        ImmutableList.Builder errors = ImmutableList.builder();
        for (PhotoModel photo : container.getPhotos()) {
            GoogleMediaItem photoMediaItem = this.getGoogleMediaItem(photo.getIdempotentId(), photo.getDataId(), photo.getName(), authData);
            if (photoMediaItem == null) continue;
            try {
                photosBuilder.add((Object)GoogleMediaItem.convertToPhotoModel(Optional.empty(), photoMediaItem));
            }
            catch (ParseException e) {
                this.monitor.info(() -> "Parse exception occurred while converting photo, skipping this item. Failure message : %s ", new Object[]{e.getMessage()});
                errors.add((Object)GoogleErrorLogger.createErrorDetail(photoMediaItem.getId(), photoMediaItem.getFilename(), e, true));
            }
        }
        for (VideoModel video : container.getVideos()) {
            GoogleMediaItem videoMediaItem = this.getGoogleMediaItem(video.getIdempotentId(), video.getDataId(), video.getName(), authData);
            if (videoMediaItem == null) continue;
            try {
                videosBuilder.add((Object)GoogleMediaItem.convertToVideoModel(Optional.empty(), videoMediaItem));
            }
            catch (ParseException e) {
                this.monitor.info(() -> "Parse exception occurred while converting video, skipping this item. Failure message : %s ", new Object[]{e.getMessage()});
                errors.add((Object)GoogleErrorLogger.createErrorDetail(videoMediaItem.getId(), videoMediaItem.getFilename(), e, true));
            }
        }
        GoogleErrorLogger.logFailedItemErrors(this.jobStore, jobId, (ImmutableList<ErrorDetail>)errors.build());
        MediaContainerResource mediaContainerResource = new MediaContainerResource((Collection)albumBuilder.build(), (Collection)photosBuilder.build(), (Collection)videosBuilder.build());
        ContinuationData continuationData = new ContinuationData(null);
        subResources.forEach(resource -> continuationData.addContainerResource((ContainerResource)resource));
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)mediaContainerResource, continuationData);
    }

    @VisibleForTesting
    ExportResult<MediaContainerResource> exportAlbums(TokensAndUrlAuthData authData, Optional<PaginationData> paginationData, UUID jobId) throws FailedToListAlbumsException {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = ((StringPaginationToken)paginationData.get()).getToken();
            Preconditions.checkArgument((boolean)token.startsWith(ALBUM_TOKEN_PREFIX), (Object)("Invalid pagination token " + token));
            paginationToken = Optional.of(token.substring(ALBUM_TOKEN_PREFIX.length()));
        }
        AlbumListResponse albumListResponse = this.listAlbums(jobId, authData, paginationToken);
        String token = albumListResponse.getNextPageToken();
        ArrayList<MediaAlbum> albums = new ArrayList<MediaAlbum>();
        GoogleAlbum[] googleAlbums = albumListResponse.getAlbums();
        StringPaginationToken nextPageData = Strings.isNullOrEmpty((String)token) ? new StringPaginationToken(MEDIA_TOKEN_PREFIX) : new StringPaginationToken(ALBUM_TOKEN_PREFIX + token);
        ContinuationData continuationData = new ContinuationData((PaginationData)nextPageData);
        if (googleAlbums != null && googleAlbums.length > 0) {
            for (GoogleAlbum googleAlbum : googleAlbums) {
                MediaAlbum album = new MediaAlbum(googleAlbum.getId(), googleAlbum.getTitle(), null);
                albums.add(album);
                this.monitor.debug(() -> String.format("%s: Google Photos exporting album: %s", jobId, album.getId()), new Object[0]);
                continuationData.addContainerResource((ContainerResource)new IdOnlyContainerResource(googleAlbum.getId()));
            }
        }
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        MediaContainerResource containerResource = new MediaContainerResource(albums, null, null);
        return new ExportResult(resultType, (DataModel)containerResource, continuationData);
    }

    @VisibleForTesting
    ExportResult<MediaContainerResource> exportMedia(TokensAndUrlAuthData authData, Optional<IdOnlyContainerResource> albumData, Optional<PaginationData> paginationData, UUID jobId) throws IOException, FailedToListMediaItemsException {
        Optional<String> albumId = Optional.empty();
        if (albumData.isPresent()) {
            albumId = Optional.of(albumData.get().getId());
        }
        Optional<String> paginationToken = this.getPhotosPaginationToken(paginationData);
        MediaItemSearchResponse mediaItemSearchResponse = this.listMediaItems(jobId, authData, albumId, paginationToken);
        StringPaginationToken nextPageData = null;
        if (!Strings.isNullOrEmpty((String)mediaItemSearchResponse.getNextPageToken())) {
            nextPageData = new StringPaginationToken(MEDIA_TOKEN_PREFIX + mediaItemSearchResponse.getNextPageToken());
        }
        ContinuationData continuationData = new ContinuationData(nextPageData);
        MediaContainerResource containerResource = null;
        GoogleMediaItem[] mediaItems = mediaItemSearchResponse.getMediaItems();
        if (mediaItems != null && mediaItems.length > 0) {
            containerResource = this.convertMediaListToResource(albumId, mediaItems, jobId);
        }
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (nextPageData == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)containerResource, continuationData);
    }

    void populateContainedMediaList(UUID jobId, TokensAndUrlAuthData authData) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException, FailedToListAlbumsException, FailedToListMediaItemsException {
        TempMediaData tempMediaData = new TempMediaData(jobId);
        String albumToken = null;
        do {
            AlbumListResponse albumListResponse = this.listAlbums(jobId, authData, Optional.ofNullable(albumToken));
            albumToken = albumListResponse.getNextPageToken();
            if (albumListResponse.getAlbums() == null) continue;
            for (GoogleAlbum album : albumListResponse.getAlbums()) {
                MediaItemSearchResponse containedMediaSearchResponse;
                String albumId = album.getId();
                String photoToken = null;
                do {
                    if ((containedMediaSearchResponse = this.listMediaItems(jobId, authData, Optional.of(albumId), Optional.ofNullable(photoToken))).getMediaItems() == null) continue;
                    for (GoogleMediaItem mediaItem : containedMediaSearchResponse.getMediaItems()) {
                        tempMediaData.addContainedPhotoId(mediaItem.getId());
                    }
                } while ((photoToken = containedMediaSearchResponse.getNextPageToken()) != null);
            }
            albumToken = albumListResponse.getNextPageToken();
        } while (albumToken != null);
        InputStream stream = GoogleMediaExporter.convertJsonToInputStream(tempMediaData);
        this.jobStore.create(jobId, GoogleMediaExporter.createCacheKey(), stream);
    }

    private Optional<String> getPhotosPaginationToken(Optional<PaginationData> paginationData) {
        Optional<String> paginationToken = Optional.empty();
        if (paginationData.isPresent()) {
            String token = ((StringPaginationToken)paginationData.get()).getToken();
            Preconditions.checkArgument((boolean)token.startsWith(MEDIA_TOKEN_PREFIX), (Object)("Invalid pagination token " + token));
            if (token.length() > MEDIA_TOKEN_PREFIX.length()) {
                paginationToken = Optional.of(token.substring(MEDIA_TOKEN_PREFIX.length()));
            }
        }
        return paginationToken;
    }

    private MediaContainerResource convertMediaListToResource(Optional<String> albumId, GoogleMediaItem[] mediaItems, UUID jobId) throws IOException {
        ArrayList<PhotoModel> photos = new ArrayList<PhotoModel>(mediaItems.length);
        ArrayList<VideoModel> videos = new ArrayList<VideoModel>(mediaItems.length);
        TempMediaData tempMediaData = null;
        InputStream stream = this.jobStore.getStream(jobId, GoogleMediaExporter.createCacheKey()).getStream();
        if (stream != null) {
            tempMediaData = (TempMediaData)new ObjectMapper().readValue(stream, TempMediaData.class);
            stream.close();
        }
        ImmutableList.Builder errors = ImmutableList.builder();
        for (GoogleMediaItem mediaItem : mediaItems) {
            boolean shouldUpload = albumId.isPresent();
            if (tempMediaData != null) {
                boolean bl = shouldUpload = shouldUpload || !tempMediaData.isContainedPhotoId(mediaItem.getId());
            }
            if (mediaItem.isPhoto()) {
                if (!shouldUpload) continue;
                try {
                    PhotoModel photoModel = GoogleMediaItem.convertToPhotoModel(albumId, mediaItem);
                    photos.add(photoModel);
                    this.monitor.debug(() -> String.format("%s: Google exporting photo: %s", jobId, photoModel.getDataId()), new Object[0]);
                }
                catch (ParseException e) {
                    this.monitor.info(() -> "Parse exception occurred while converting photo, skipping this item. Failure message : %s ", new Object[]{e.getMessage()});
                    errors.add((Object)GoogleErrorLogger.createErrorDetail(mediaItem.getId(), mediaItem.getFilename(), e, true));
                }
                continue;
            }
            if (!mediaItem.isVideo() || !shouldUpload) continue;
            try {
                VideoModel videoModel = GoogleMediaItem.convertToVideoModel(albumId, mediaItem);
                videos.add(videoModel);
                this.monitor.debug(() -> String.format("%s: Google exporting video: %s", jobId, videoModel.getDataId()), new Object[0]);
            }
            catch (ParseException e) {
                this.monitor.info(() -> "Parse exception occurred while converting video, skipping this item. Failure message : %s ", new Object[]{e.getMessage()});
                errors.add((Object)GoogleErrorLogger.createErrorDetail(mediaItem.getId(), mediaItem.getFilename(), e, true));
            }
        }
        GoogleErrorLogger.logFailedItemErrors(this.jobStore, jobId, (ImmutableList<ErrorDetail>)errors.build());
        return new MediaContainerResource(null, photos, videos);
    }

    @Nullable
    @VisibleForTesting
    GoogleAlbum getGoogleAlbum(String albumIdempotentId, String albumId, String albumName, TokensAndUrlAuthData authData) throws IOException, InvalidTokenException, PermissionDeniedException {
        if (this.retryingExecutor == null || !this.enableRetrying.booleanValue()) {
            return this.getOrCreatePhotosInterface(authData).getAlbum(albumId);
        }
        try {
            GoogleAlbum googleAlbum = (GoogleAlbum)this.retryingExecutor.executeAndSwallowIOExceptions(albumIdempotentId, albumName, () -> this.getOrCreatePhotosInterface(authData).getAlbum(albumId));
            return googleAlbum;
        }
        catch (Exception e) {
            this.monitor.info(() -> String.format("Retry exception encountered while fetching an album: %s", e), new Object[0]);
            return null;
        }
    }

    @Nullable
    @VisibleForTesting
    GoogleMediaItem getGoogleMediaItem(String photoIdempotentId, String photoDataId, String photoName, TokensAndUrlAuthData authData) throws IOException, InvalidTokenException, PermissionDeniedException {
        if (this.retryingExecutor == null || !this.enableRetrying.booleanValue()) {
            return this.getOrCreatePhotosInterface(authData).getMediaItem(photoDataId);
        }
        try {
            GoogleMediaItem googleMediaItem = (GoogleMediaItem)this.retryingExecutor.executeAndSwallowIOExceptions(photoIdempotentId, photoName, () -> this.getOrCreatePhotosInterface(authData).getMediaItem(photoDataId));
            return googleMediaItem;
        }
        catch (Exception e) {
            this.monitor.info(() -> String.format("Retry exception encountered while fetching a photo: %s", e), new Object[0]);
            return null;
        }
    }

    private AlbumListResponse listAlbums(UUID jobId, TokensAndUrlAuthData authData, Optional<String> albumToken) throws FailedToListAlbumsException {
        if (this.retryingExecutor == null || !this.enableRetrying.booleanValue()) {
            try {
                return this.getOrCreatePhotosInterface(authData).listAlbums(albumToken);
            }
            catch (IOException | InvalidTokenException | PermissionDeniedException e) {
                throw new FailedToListAlbumsException(e.getMessage(), (Exception)e);
            }
        }
        try {
            return (AlbumListResponse)this.retryingExecutor.executeOrThrowException(String.format("%s: listAlbums(page=%s)", jobId, albumToken), String.format("listAlbums(page=%s)", albumToken), () -> this.getOrCreatePhotosInterface(authData).listAlbums(albumToken));
        }
        catch (Exception e) {
            throw new FailedToListAlbumsException(e.getMessage(), e);
        }
    }

    private MediaItemSearchResponse listMediaItems(UUID jobId, TokensAndUrlAuthData authData, Optional<String> albumId, Optional<String> pageToken) throws FailedToListMediaItemsException {
        if (this.retryingExecutor == null || !this.enableRetrying.booleanValue()) {
            try {
                return this.getOrCreatePhotosInterface(authData).listMediaItems(albumId, pageToken);
            }
            catch (IOException | InvalidTokenException | PermissionDeniedException | UploadErrorException e) {
                throw new FailedToListMediaItemsException(e.getMessage(), (Exception)e);
            }
        }
        try {
            return (MediaItemSearchResponse)this.retryingExecutor.executeOrThrowException(String.format("%s: listMediaItems(albumId=%s, page=%s)", jobId, albumId, pageToken), String.format("listMediaItems(albumId=%s, page=%s)", albumId, pageToken), () -> this.getOrCreatePhotosInterface(authData).listMediaItems(albumId, pageToken));
        }
        catch (Exception e) {
            throw new FailedToListMediaItemsException(e.getMessage(), e);
        }
    }

    private synchronized GooglePhotosInterface getOrCreatePhotosInterface(TokensAndUrlAuthData authData) {
        return this.photosInterface == null ? this.makePhotosInterface(authData) : this.photosInterface;
    }

    private synchronized GooglePhotosInterface makePhotosInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new GooglePhotosInterface(this.credentialFactory, credential, this.jsonFactory, this.monitor, 1.0);
    }
}

