/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.mail;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.gmail.Gmail;
import com.google.api.services.gmail.model.ListMessagesResponse;
import com.google.api.services.gmail.model.Message;
import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.StringPaginationToken;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.mail.MailContainerResource;
import org.datatransferproject.types.common.models.mail.MailMessageModel;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GoogleMailExporter
implements Exporter<TokensAndUrlAuthData, MailContainerResource> {
    @VisibleForTesting
    static final long PAGE_SIZE = 50L;
    @VisibleForTesting
    static final String USER = "me";
    private final GoogleCredentialFactory credentialFactory;
    private volatile Gmail gmail;

    public GoogleMailExporter(GoogleCredentialFactory credentialFactory) {
        this.credentialFactory = credentialFactory;
        this.gmail = null;
    }

    @VisibleForTesting
    GoogleMailExporter(GoogleCredentialFactory credentialFactory, Gmail gmail) {
        this.credentialFactory = credentialFactory;
        this.gmail = gmail;
    }

    public ExportResult<MailContainerResource> export(UUID id, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) {
        Gmail gmail = this.getOrCreateGmail(authData);
        Gmail.Users.Messages.List request = null;
        try {
            request = gmail.users().messages().list(USER).setMaxResults(Long.valueOf(50L));
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
        if (exportInformation.isPresent() && exportInformation.get().getPaginationData() != null) {
            request.setPageToken(((StringPaginationToken)exportInformation.get().getPaginationData()).getToken());
        }
        ListMessagesResponse response = null;
        try {
            response = (ListMessagesResponse)request.execute();
        }
        catch (IOException e) {
            return new ExportResult((Throwable)e);
        }
        ArrayList<MailMessageModel> results = new ArrayList<MailMessageModel>(response.getMessages().size());
        for (Message listMessage : response.getMessages()) {
            Message getResponse = null;
            try {
                getResponse = (Message)gmail.users().messages().get(USER, listMessage.getId()).setFormat("raw").execute();
            }
            catch (IOException e) {
                return new ExportResult((Throwable)e);
            }
            results.add(new MailMessageModel(getResponse.getRaw(), getResponse.getLabelIds()));
        }
        StringPaginationToken newPage = null;
        ExportResult.ResultType resultType = ExportResult.ResultType.END;
        if (response.getNextPageToken() != null) {
            newPage = new StringPaginationToken(response.getNextPageToken());
            resultType = ExportResult.ResultType.CONTINUE;
        }
        MailContainerResource mailContainerResource = new MailContainerResource(null, results);
        return new ExportResult(resultType, (DataModel)mailContainerResource, new ContinuationData((PaginationData)newPage));
    }

    private Gmail getOrCreateGmail(TokensAndUrlAuthData authData) {
        return this.gmail == null ? this.makeGmailService(authData) : this.gmail;
    }

    private synchronized Gmail makeGmailService(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new Gmail.Builder(this.credentialFactory.getHttpTransport(), this.credentialFactory.getJsonFactory(), (HttpRequestInitializer)credential).setApplicationName("Portability").build();
    }
}

