/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.google.photos;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.json.JsonFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.google.common.GoogleCredentialFactory;
import org.datatransferproject.datatransfer.google.common.GooglePhotosImportUtils;
import org.datatransferproject.datatransfer.google.common.gphotos.GPhotosUpload;
import org.datatransferproject.datatransfer.google.mediaModels.BatchMediaItemResponse;
import org.datatransferproject.datatransfer.google.mediaModels.GoogleAlbum;
import org.datatransferproject.datatransfer.google.mediaModels.NewMediaItem;
import org.datatransferproject.datatransfer.google.mediaModels.NewMediaItemResult;
import org.datatransferproject.datatransfer.google.mediaModels.NewMediaItemUpload;
import org.datatransferproject.datatransfer.google.mediaModels.Status;
import org.datatransferproject.datatransfer.google.photos.GooglePhotosInterface;
import org.datatransferproject.datatransfer.google.photos.PhotoResult;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.JobStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.cloud.types.PortabilityJob;
import org.datatransferproject.spi.transfer.i18n.BaseMultilingualDictionary;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.spi.transfer.types.DestinationMemoryFullException;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.spi.transfer.types.PermissionDeniedException;
import org.datatransferproject.spi.transfer.types.UploadErrorException;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class GooglePhotosImporter
implements Importer<TokensAndUrlAuthData, PhotosContainerResource> {
    private final GoogleCredentialFactory credentialFactory;
    private final JobStore jobStore;
    private final JsonFactory jsonFactory;
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;
    private final double writesPerSecond;
    private final Map<UUID, GooglePhotosInterface> photosInterfacesMap;
    private final GooglePhotosInterface photosInterface;
    private final HashMap<UUID, BaseMultilingualDictionary> multilingualStrings = new HashMap();
    private IdempotentImportExecutor retryingIdempotentExecutor;
    private Boolean enableRetrying;

    public GooglePhotosImporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor, double writesPerSecond, IdempotentImportExecutor retryingIdempotentExecutor, boolean enableRetrying) {
        this(credentialFactory, jobStore, jsonFactory, new HashMap<UUID, GooglePhotosInterface>(), null, new ConnectionProvider((TemporaryPerJobDataStore)jobStore), monitor, writesPerSecond, retryingIdempotentExecutor, enableRetrying);
    }

    public GooglePhotosImporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Monitor monitor, double writesPerSecond) {
        this(credentialFactory, jobStore, jsonFactory, new HashMap<UUID, GooglePhotosInterface>(), null, new ConnectionProvider((TemporaryPerJobDataStore)jobStore), monitor, writesPerSecond);
    }

    @VisibleForTesting
    GooglePhotosImporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Map<UUID, GooglePhotosInterface> photosInterfacesMap, GooglePhotosInterface photosInterface, ConnectionProvider connectionProvider, Monitor monitor, double writesPerSecond) {
        this(credentialFactory, jobStore, jsonFactory, photosInterfacesMap, photosInterface, connectionProvider, monitor, writesPerSecond, null, false);
    }

    GooglePhotosImporter(GoogleCredentialFactory credentialFactory, JobStore jobStore, JsonFactory jsonFactory, Map<UUID, GooglePhotosInterface> photosInterfacesMap, GooglePhotosInterface photosInterface, ConnectionProvider connectionProvider, Monitor monitor, double writesPerSecond, IdempotentImportExecutor retryingIdempotentExecutor, boolean enableRetrying) {
        this.credentialFactory = credentialFactory;
        this.jobStore = jobStore;
        this.jsonFactory = jsonFactory;
        this.photosInterfacesMap = photosInterfacesMap;
        this.photosInterface = photosInterface;
        this.connectionProvider = connectionProvider;
        this.monitor = monitor;
        this.writesPerSecond = writesPerSecond;
        this.retryingIdempotentExecutor = retryingIdempotentExecutor;
        this.enableRetrying = enableRetrying;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentImportExecutor, TokensAndUrlAuthData authData, PhotosContainerResource data) throws Exception {
        if (data == null) {
            return ImportResult.OK;
        }
        IdempotentImportExecutor executor = this.retryingIdempotentExecutor != null && this.enableRetrying != false ? this.retryingIdempotentExecutor : idempotentImportExecutor;
        GPhotosUpload gPhotosUpload = new GPhotosUpload(jobId, executor, authData);
        for (PhotoAlbum album : data.getAlbums()) {
            executor.executeAndSwallowIOExceptions(album.getId(), album.getName(), () -> this.importSingleAlbum(jobId, authData, album));
        }
        long bytes = this.importPhotos(data.getPhotos(), gPhotosUpload);
        ImportResult result = ImportResult.OK;
        return result.copyWithBytes(Long.valueOf(bytes));
    }

    @VisibleForTesting
    String importSingleAlbum(UUID jobId, TokensAndUrlAuthData authData, PhotoAlbum inputAlbum) throws IOException, InvalidTokenException, PermissionDeniedException, UploadErrorException {
        GoogleAlbum googleAlbum = new GoogleAlbum();
        googleAlbum.setTitle(GooglePhotosImportUtils.cleanAlbumTitle(inputAlbum.getName()));
        GoogleAlbum responseAlbum = this.getOrCreatePhotosInterface(jobId, authData).createAlbum(googleAlbum);
        return responseAlbum.getId();
    }

    @VisibleForTesting
    public long importPhotos(Collection<PhotoModel> photos, GPhotosUpload gPhotosUpload) throws Exception {
        return gPhotosUpload.uploadItemsViaBatching(photos, this::importPhotoBatch);
    }

    private long importPhotoBatch(UUID jobId, TokensAndUrlAuthData authData, List<PhotoModel> photos, IdempotentImportExecutor executor, String albumId) throws Exception {
        ArrayList<NewMediaItem> mediaItems = new ArrayList<NewMediaItem>();
        HashMap<String, PhotoModel> uploadTokenToDataId = new HashMap<String, PhotoModel>();
        HashMap<String, Long> uploadTokenToLength = new HashMap<String, Long>();
        for (PhotoModel photo : photos) {
            Long size = null;
            try {
                TemporaryPerJobDataStore.InputStreamWrapper streamWrapper = this.connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)photo);
                try (InputStream s = streamWrapper.getStream();){
                    String uploadToken = this.getOrCreatePhotosInterface(jobId, authData).uploadMediaContent(s, photo.getSha1());
                    String string = GooglePhotosImportUtils.cleanDescription(photo.getDescription());
                    mediaItems.add(new NewMediaItem(string, uploadToken, photo.getTitle()));
                    uploadTokenToDataId.put(uploadToken, photo);
                    size = streamWrapper.getBytes();
                    uploadTokenToLength.put(uploadToken, size);
                }
                catch (UploadErrorException e) {
                    if (e.getMessage().contains("Hash mismatch")) {
                        this.monitor.severe(() -> String.format("%s: SHA-1 (%s) mismatch during upload", jobId, photo.getSha1()), new Object[0]);
                    }
                    Long finalSize = size;
                    executor.importAndSwallowIOExceptions((ImportableItem)photo, p -> ItemImportResult.error((Exception)((Object)e), (Long)finalSize));
                }
                try {
                    if (!photo.isInTempStore()) continue;
                    this.jobStore.removeData(jobId, photo.getFetchableUrl());
                }
                catch (Exception e) {
                    this.monitor.info(() -> String.format("%s: Exception swallowed in removeData call for localPath %s", jobId, photo.getFetchableUrl()), new Object[]{e});
                }
            }
            catch (IOException exception) {
                Long finalSize = size;
                executor.importAndSwallowIOExceptions((ImportableItem)photo, p -> ItemImportResult.error((Exception)exception, (Long)finalSize));
            }
        }
        if (mediaItems.isEmpty()) {
            return 0L;
        }
        long totalBytes = 0L;
        NewMediaItemUpload uploadItem = new NewMediaItemUpload(albumId, mediaItems);
        try {
            BatchMediaItemResponse photoCreationResponse = this.getOrCreatePhotosInterface(jobId, authData).createPhotos(uploadItem);
            Preconditions.checkNotNull((Object)photoCreationResponse);
            NewMediaItemResult[] mediaItemResults = photoCreationResponse.getResults();
            Preconditions.checkNotNull((Object)mediaItemResults);
            for (NewMediaItemResult mediaItem : mediaItemResults) {
                PhotoModel photo = (PhotoModel)uploadTokenToDataId.get(mediaItem.getUploadToken());
                totalBytes += this.processMediaResult(mediaItem, (ImportableItem)photo, executor, (Long)uploadTokenToLength.get(mediaItem.getUploadToken()));
                uploadTokenToDataId.remove(mediaItem.getUploadToken());
            }
            if (!uploadTokenToDataId.isEmpty()) {
                for (Map.Entry entry : uploadTokenToDataId.entrySet()) {
                    PhotoModel photo = (PhotoModel)entry.getValue();
                    executor.importAndSwallowIOExceptions((ImportableItem)photo, p -> ItemImportResult.error((Exception)new IOException("Photo was missing from results list."), (Long)((Long)uploadTokenToLength.get(entry.getKey()))));
                }
            }
        }
        catch (IOException e) {
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"The remaining storage in the user's account is not enough")) {
                throw new DestinationMemoryFullException("Google destination storage full", (Throwable)e);
            }
            if (StringUtils.contains((CharSequence)e.getMessage(), (CharSequence)"The provided ID does not match any albums")) {
                this.logMissingAlbumDetails(jobId, authData, albumId, e);
            }
            throw e;
        }
        return totalBytes;
    }

    private void logMissingAlbumDetails(UUID jobId, TokensAndUrlAuthData authData, String albumId, IOException e) {
        this.monitor.info(() -> String.format("Can't find album during createPhotos call, album is likely deleted", new Object[0]), new Object[]{e});
        try {
            GoogleAlbum album = this.getOrCreatePhotosInterface(jobId, authData).getAlbum(albumId);
            this.monitor.debug(() -> String.format("Can't find album during createPhotos call, album info: isWriteable %b, mediaItemsCount %d", album.getIsWriteable(), album.getMediaItemsCount()), new Object[]{e});
        }
        catch (Exception ex) {
            this.monitor.info(() -> String.format("Can't find album during getAlbum call", new Object[0]), new Object[]{ex});
        }
    }

    private long processMediaResult(NewMediaItemResult mediaItem, ImportableItem item, IdempotentImportExecutor executor, long bytes) throws Exception {
        Status status = mediaItem.getStatus();
        if (status.getCode() == 0) {
            PhotoResult photoResult = new PhotoResult(mediaItem.getMediaItem().getId(), bytes);
            executor.importAndSwallowIOExceptions(item, itemToImport -> ItemImportResult.success((Serializable)photoResult, (Long)bytes));
            return bytes;
        }
        executor.importAndSwallowIOExceptions(item, itemToImport -> ItemImportResult.error((Exception)new IOException(String.format("Media item could not be created. Code: %d Message: %s", status.getCode(), status.getMessage())), (Long)bytes));
        return 0L;
    }

    private synchronized GooglePhotosInterface getOrCreatePhotosInterface(UUID jobId, TokensAndUrlAuthData authData) {
        if (this.photosInterface != null) {
            return this.photosInterface;
        }
        if (this.photosInterfacesMap.containsKey(jobId)) {
            return this.photosInterfacesMap.get(jobId);
        }
        GooglePhotosInterface newInterface = this.makePhotosInterface(authData);
        this.photosInterfacesMap.put(jobId, newInterface);
        return newInterface;
    }

    private synchronized GooglePhotosInterface makePhotosInterface(TokensAndUrlAuthData authData) {
        Credential credential = this.credentialFactory.createCredential(authData);
        return new GooglePhotosInterface(this.credentialFactory, credential, this.jsonFactory, this.monitor, this.writesPerSecond);
    }

    private synchronized BaseMultilingualDictionary getOrCreateStringDictionary(UUID jobId) {
        if (!this.multilingualStrings.containsKey(jobId)) {
            PortabilityJob job = this.jobStore.findJob(jobId);
            String locale = job != null ? job.userLocale() : null;
            this.multilingualStrings.put(jobId, new BaseMultilingualDictionary(locale));
        }
        return this.multilingualStrings.get(jobId);
    }
}

