/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic.auth;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.generic.auth.RefreshTokenResponse;
import org.datatransferproject.spi.transfer.types.InvalidTokenException;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class OAuthTokenManager {
    AppCredentials appCredentials;
    TokensAndUrlAuthData authData;
    OkHttpClient client;
    Monitor monitor;
    ObjectMapper om = new ObjectMapper(new JsonFactory());
    static final MediaType JSON = MediaType.parse((String)"application/json");
    static final MediaType FORM_DATA = MediaType.parse((String)"application/x-www-form-urlencoded");

    public OAuthTokenManager(TokensAndUrlAuthData initialAuthData, AppCredentials appCredentials, OkHttpClient client, Monitor monitor) {
        this.appCredentials = appCredentials;
        this.authData = initialAuthData;
        this.client = client;
        this.monitor = monitor;
        this.om.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        this.om.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    private TokensAndUrlAuthData refreshToken() throws IOException {
        this.monitor.info(() -> "Refreshing OAuth token", new Object[0]);
        Request request = new Request.Builder().url(this.authData.getTokenServerEncodedUrl()).addHeader("Accept", JSON.toString()).post((RequestBody)new FormBody.Builder().add("grant_type", "refresh_token").add("client_id", this.appCredentials.getKey()).add("client_secret", this.appCredentials.getSecret()).add("refresh_token", this.authData.getRefreshToken()).build()).build();
        try (Response response = this.client.newCall(request).execute();){
            RefreshTokenResponse responsePayload;
            if (response.code() >= 400) {
                throw new IOException(String.format("Error while refreshing token (%d): %s", response.code(), new String(response.body().bytes(), StandardCharsets.UTF_8)));
            }
            byte[] body = response.body().bytes();
            try {
                responsePayload = (RefreshTokenResponse)this.om.readValue(body, RefreshTokenResponse.class);
            }
            catch (JsonParseException | JsonMappingException e) {
                throw new IOException(String.format("Unexpected response while refreshing token: %s", new String(body, StandardCharsets.UTF_8)), e);
            }
            TokensAndUrlAuthData tokensAndUrlAuthData = new TokensAndUrlAuthData(responsePayload.getAccessToken(), responsePayload.getRefreshToken().orElse(this.authData.getRefreshToken()), this.authData.getTokenServerEncodedUrl());
            return tokensAndUrlAuthData;
        }
    }

    public <T, Ex extends Exception> T withAuthData(FunctionRequiringAuthData<T, Ex> f) throws Ex, InvalidTokenException, IOException {
        try {
            return f.execute(this.authData);
        }
        catch (InvalidTokenException e) {
            if (this.authData.getRefreshToken() == null || this.authData.getRefreshToken().isEmpty()) {
                this.monitor.severe(() -> "Refresh token not present with auth data", new Object[0]);
                throw e;
            }
            this.authData = this.refreshToken();
            try {
                return f.execute(this.authData);
            }
            catch (InvalidTokenException innerException) {
                throw new InvalidTokenException("Token still expired after refresh", (Throwable)innerException);
            }
        }
    }

    @FunctionalInterface
    public static interface FunctionRequiringAuthData<T, Ex extends Exception> {
        public T execute(TokensAndUrlAuthData var1) throws Ex, InvalidTokenException;
    }
}

