/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.ArrayDeque;
import java.util.ArrayList;
import org.datatransferproject.datatransfer.generic.CachedDownloadableItem;
import org.datatransferproject.datatransfer.generic.FileExportData;
import org.datatransferproject.datatransfer.generic.FolderExportData;
import org.datatransferproject.datatransfer.generic.GenericPayload;
import org.datatransferproject.datatransfer.generic.ImportableData;
import org.datatransferproject.datatransfer.generic.ImportableFileData;
import org.datatransferproject.types.common.models.blob.BlobbyStorageContainerResource;
import org.datatransferproject.types.common.models.blob.DigitalDocumentWrapper;

public class BlobbySerializer {
    static final String SCHEMA_SOURCE = "https://github.com/dtinit/data-transfer-project/blob/master/extensions/data-transfer/portability-data-transfer-generic/src/main/java/org/datatransferproject/datatransfer/generic/BlobbySerializer.java";

    public static Iterable<ImportableData<ExportData>> serialize(BlobbyStorageContainerResource root) {
        ArrayList<ImportableData<ExportData>> results = new ArrayList<ImportableData<ExportData>>();
        ArrayDeque<BlobbyContainerPath> horizon = new ArrayDeque<BlobbyContainerPath>();
        BlobbyContainerPath containerAndPath = new BlobbyContainerPath(root, "");
        do {
            BlobbyStorageContainerResource container = containerAndPath.getContainer();
            String parentPath = containerAndPath.getPath();
            String path = String.format("%s/%s", parentPath, container.getName());
            results.add(new ImportableData<FolderExportData>(new GenericPayload<FolderExportData>(new FolderExportData(path), SCHEMA_SOURCE), container.getId(), path));
            for (BlobbyStorageContainerResource child : container.getFolders()) {
                horizon.add(new BlobbyContainerPath(child, path));
            }
            for (DigitalDocumentWrapper file : container.getFiles()) {
                results.add(new ImportableFileData<FileExportData>(new CachedDownloadableItem(file.getCachedContentId(), file.getDtpDigitalDocument().getName()), file.getDtpDigitalDocument().getEncodingFormat(), new GenericPayload<FileExportData>(FileExportData.fromDtpDigitalDocument(path, file.getDtpDigitalDocument()), SCHEMA_SOURCE), file.getCachedContentId(), file.getDtpDigitalDocument().getName()));
            }
        } while ((containerAndPath = (BlobbyContainerPath)horizon.poll()) != null);
        return results;
    }

    static class BlobbyContainerPath {
        private BlobbyStorageContainerResource container;
        private String path;

        public BlobbyContainerPath(BlobbyStorageContainerResource container, String path) {
            this.container = container;
            this.path = path;
        }

        public BlobbyStorageContainerResource getContainer() {
            return this.container;
        }

        public String getPath() {
            return this.path;
        }
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=FolderExportData.class), @JsonSubTypes.Type(value=FileExportData.class)})
    public static interface ExportData {
    }
}

