/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.datatransferproject.datatransfer.generic.AlbumExportData;
import org.datatransferproject.datatransfer.generic.GenericPayload;
import org.datatransferproject.datatransfer.generic.ImportableData;
import org.datatransferproject.datatransfer.generic.ImportableFileData;
import org.datatransferproject.datatransfer.generic.PhotoExportData;
import org.datatransferproject.datatransfer.generic.VideoExportData;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.models.media.MediaContainerResource;

public class MediaSerializer {
    static final String SCHEMA_SOURCE = "https://github.com/dtinit/data-transfer-project/blob/master/extensions/data-transfer/portability-data-transfer-generic/src/main/java/org/datatransferproject/datatransfer/generic/MediaSerializer.java";

    public static Iterable<ImportableData<ExportData>> serialize(MediaContainerResource container) {
        return Stream.concat(container.getAlbums().stream().map(album -> new ImportableData<AlbumExportData>(new GenericPayload<AlbumExportData>(AlbumExportData.fromModel(album), SCHEMA_SOURCE), album.getIdempotentId(), album.getName())), Stream.concat(container.getVideos().stream().map(video -> new ImportableFileData<VideoExportData>((DownloadableItem)video, video.getMimeType(), new GenericPayload<VideoExportData>(VideoExportData.fromModel(video), SCHEMA_SOURCE), video.getIdempotentId(), video.getName())), container.getPhotos().stream().map(photo -> new ImportableFileData<PhotoExportData>((DownloadableItem)photo, photo.getMimeType(), new GenericPayload<PhotoExportData>(PhotoExportData.fromModel(photo), SCHEMA_SOURCE), photo.getIdempotentId(), photo.getName())))).collect(Collectors.toList());
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=AlbumExportData.class), @JsonSubTypes.Type(value=VideoExportData.class), @JsonSubTypes.Type(value=PhotoExportData.class)})
    public static interface ExportData {
    }
}

