/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.datatransferproject.datatransfer.generic.BlobbySerializer;
import org.datatransferproject.types.common.models.blob.DtpDigitalDocument;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME)
@JsonTypeName(value="File")
class FileExportData
implements BlobbySerializer.ExportData {
    @JsonProperty
    private final String folder;
    @JsonProperty
    private final String name;
    @JsonProperty
    private final Optional<ZonedDateTime> dateModified;

    private FileExportData(String folder, String name, Optional<ZonedDateTime> dateModified) {
        this.folder = folder;
        this.name = name;
        this.dateModified = dateModified;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getName() {
        return this.name;
    }

    public Optional<ZonedDateTime> getDateModified() {
        return this.dateModified;
    }

    public static FileExportData fromDtpDigitalDocument(String path, DtpDigitalDocument model) {
        return new FileExportData(path, model.getName(), Optional.ofNullable(model.getDateModified()).filter(string -> !string.isEmpty()).map(dateString -> ZonedDateTime.parse(model.getDateModified())));
    }
}

