/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.generic;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.datatransferproject.datatransfer.generic.CalendarEventExportData;
import org.datatransferproject.datatransfer.generic.CalendarExportData;
import org.datatransferproject.datatransfer.generic.GenericPayload;
import org.datatransferproject.datatransfer.generic.ImportableData;
import org.datatransferproject.types.common.models.calendar.CalendarContainerResource;

public class CalendarSerializer {
    static final String SCHEMA_SOURCE_CALENDAR = "https://github.com/dtinit/data-transfer-project/blob/master/portability-types-common/src/main/java/org/datatransferproject/types/common/models/calendar/CalendarModel.java";
    static final String SCHEMA_SOURCE_EVENT = "https://github.com/dtinit/data-transfer-project/blob/master/portability-types-common/src/main/java/org/datatransferproject/types/common/models/calendar/CalendarEventModel.java";

    public static Iterable<ImportableData<ExportData>> serialize(CalendarContainerResource container) {
        return Stream.concat(container.getCalendars().stream().map(calendar -> new ImportableData<CalendarExportData>(new GenericPayload<CalendarExportData>(CalendarExportData.fromModel(calendar), SCHEMA_SOURCE_CALENDAR), calendar.getId(), calendar.getName())), container.getEvents().stream().map(event -> new ImportableData<CalendarEventExportData>(new GenericPayload<CalendarEventExportData>(CalendarEventExportData.fromModel(event), SCHEMA_SOURCE_EVENT), String.valueOf(event.hashCode()), event.getTitle()))).collect(Collectors.toList());
    }

    @JsonSubTypes(value={@JsonSubTypes.Type(value=CalendarExportData.class, name="Calendar"), @JsonSubTypes.Type(value=CalendarEventExportData.class, name="CalendarEvent")})
    public static interface ExportData {
    }
}

