/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.flickr;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.flickr.media.FlickrMediaImporter;
import org.datatransferproject.datatransfer.flickr.photos.FlickrPhotosExporter;
import org.datatransferproject.datatransfer.flickr.photos.FlickrPhotosImporter;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutorExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class FlickrTransferExtension
implements TransferExtension {
    private static final String SERVICE_ID = "flickr";
    private static final String FLICKR_KEY = "FLICKR_KEY";
    private static final String FLICKR_SECRET = "FLICKR_SECRET";
    private final Set<DataVertical> supportedServices = ImmutableSet.of((Object)DataVertical.PHOTOS, (Object)DataVertical.MEDIA);
    private Exporter exporter;
    private TemporaryPerJobDataStore jobStore;
    private boolean initialized = false;
    private AppCredentials appCredentials;
    private ImmutableMap<DataVertical, Importer> importerMap;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)this.supportedServices.contains(transferDataType));
        return this.exporter;
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized);
        Preconditions.checkArgument((boolean)this.supportedServices.contains(transferDataType));
        return (Importer)this.importerMap.get((Object)transferDataType);
    }

    public void initialize(ExtensionContext context) {
        if (this.initialized) {
            return;
        }
        this.jobStore = (TemporaryPerJobDataStore)context.getService(TemporaryPerJobDataStore.class);
        Monitor monitor = context.getMonitor();
        try {
            this.appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials(FLICKR_KEY, FLICKR_SECRET);
        }
        catch (Exception e) {
            monitor.info(() -> String.format("Unable to retrieve Flickr AppCredentials. Did you set %s and %s?", FLICKR_KEY, FLICKR_SECRET), new Object[]{e});
            this.initialized = false;
            return;
        }
        TransferServiceConfig serviceConfig = (TransferServiceConfig)context.getService(TransferServiceConfig.class);
        IdempotentImportExecutor idempotentImportExecutor = ((IdempotentImportExecutorExtension)context.getService(IdempotentImportExecutorExtension.class)).getRetryingIdempotentImportExecutor(context);
        boolean enableRetrying = (Boolean)context.getSetting("enableRetrying", (Object)false);
        ImmutableMap.Builder importerBuilder = ImmutableMap.builder();
        importerBuilder.put((Object)DataVertical.PHOTOS, (Object)new FlickrPhotosImporter(this.appCredentials, this.jobStore, monitor, serviceConfig, idempotentImportExecutor, enableRetrying));
        importerBuilder.put((Object)DataVertical.MEDIA, (Object)new FlickrMediaImporter(this.appCredentials, this.jobStore, monitor, serviceConfig));
        this.importerMap = importerBuilder.build();
        this.exporter = new FlickrPhotosExporter(this.appCredentials, serviceConfig);
        this.initialized = true;
    }
}

