/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.flickr.photos;

import com.flickr4java.flickr.Flickr;
import com.flickr4java.flickr.FlickrException;
import com.flickr4java.flickr.REST;
import com.flickr4java.flickr.RequestContext;
import com.flickr4java.flickr.Transport;
import com.flickr4java.flickr.auth.Auth;
import com.flickr4java.flickr.photos.Photo;
import com.flickr4java.flickr.photos.PhotoList;
import com.flickr4java.flickr.photos.PhotosInterface;
import com.flickr4java.flickr.photosets.Photoset;
import com.flickr4java.flickr.photosets.Photosets;
import com.flickr4java.flickr.photosets.PhotosetsInterface;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.RateLimiter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.datatransferproject.datatransfer.flickr.photos.FlickrUtils;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.types.ContinuationData;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.IntPaginationToken;
import org.datatransferproject.types.common.PaginationData;
import org.datatransferproject.types.common.models.ContainerResource;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.IdOnlyContainerResource;
import org.datatransferproject.types.common.models.photos.PhotoAlbum;
import org.datatransferproject.types.common.models.photos.PhotoModel;
import org.datatransferproject.types.common.models.photos.PhotosContainerResource;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.AuthData;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class FlickrPhotosExporter
implements Exporter<AuthData, PhotosContainerResource> {
    private static final int PHOTO_PER_PAGE = 50;
    private static final List<String> EXTRAS = ImmutableList.of((Object)"url_o", (Object)"o_dims", (Object)"original_format");
    private static final int PHOTO_SETS_PER_PAGE = 500;
    private static final String PHOTOSET_EXTRAS = "";
    private final PhotosetsInterface photosetsInterface;
    private final PhotosInterface photosInterface;
    private final Flickr flickr;
    private final RateLimiter perUserRateLimiter;

    public FlickrPhotosExporter(AppCredentials appCredentials, TransferServiceConfig serviceConfig) {
        this.flickr = new Flickr(appCredentials.getKey(), appCredentials.getSecret(), (Transport)new REST());
        this.photosetsInterface = this.flickr.getPhotosetsInterface();
        this.photosInterface = this.flickr.getPhotosInterface();
        this.perUserRateLimiter = serviceConfig.getPerUserRateLimiter();
    }

    @VisibleForTesting
    FlickrPhotosExporter(Flickr flickr, TransferServiceConfig serviceConfig) {
        this.flickr = flickr;
        this.photosInterface = flickr.getPhotosInterface();
        this.photosetsInterface = flickr.getPhotosetsInterface();
        this.perUserRateLimiter = serviceConfig.getPerUserRateLimiter();
    }

    @VisibleForTesting
    static PhotoModel toCommonPhoto(Photo p, String albumId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)p.getOriginalSize().getSource()) ? 1 : 0) != 0, (Object)("Photo [" + p.getId() + "] has a null authUrl"));
        return new PhotoModel(p.getTitle(), p.getOriginalSize().getSource(), p.getDescription(), FlickrPhotosExporter.toMimeType(p.getOriginalFormat()), p.getId(), albumId, false);
    }

    @VisibleForTesting
    static String toMimeType(String flickrFormat) {
        switch (flickrFormat) {
            case "jpg": 
            case "jpeg": {
                return "image/jpeg";
            }
            case "png": {
                return "image/png";
            }
            case "gif": {
                return "image/gif";
            }
        }
        throw new IllegalArgumentException("Don't know how to map: " + flickrFormat);
    }

    public ExportResult<PhotosContainerResource> export(UUID jobId, AuthData authData, Optional<ExportInformation> exportInformation) {
        IdOnlyContainerResource resource;
        Auth auth;
        try {
            auth = FlickrUtils.getAuth(authData, this.flickr);
        }
        catch (FlickrException e) {
            return new ExportResult((Throwable)e);
        }
        RequestContext.getRequestContext().setAuth(auth);
        if (exportInformation.isPresent() && exportInformation.get().getContainerResource() instanceof PhotosContainerResource) {
            return this.exportPhotosContainer((PhotosContainerResource)exportInformation.get().getContainerResource());
        }
        PaginationData paginationData = exportInformation.isPresent() ? exportInformation.get().getPaginationData() : null;
        IdOnlyContainerResource idOnlyContainerResource = resource = exportInformation.isPresent() ? (IdOnlyContainerResource)exportInformation.get().getContainerResource() : null;
        if (resource != null) {
            return this.getPhotos(resource, paginationData);
        }
        return this.getAlbums(paginationData, auth);
    }

    private ExportResult<PhotosContainerResource> exportPhotosContainer(PhotosContainerResource container) {
        ImmutableList.Builder albumBuilder = ImmutableList.builder();
        ImmutableList.Builder photosBuilder = ImmutableList.builder();
        ArrayList<IdOnlyContainerResource> subResources = new ArrayList<IdOnlyContainerResource>();
        try {
            for (PhotoAlbum album : container.getAlbums()) {
                Photoset photoset = this.photosetsInterface.getInfo(album.getId());
                albumBuilder.add((Object)new PhotoAlbum(photoset.getId(), photoset.getTitle(), photoset.getDescription()));
                subResources.add(new IdOnlyContainerResource(photoset.getId()));
            }
            for (PhotoModel photo : container.getPhotos()) {
                Photo p = this.photosInterface.getInfo(photo.getDataId(), null);
                photosBuilder.add((Object)FlickrPhotosExporter.toCommonPhoto(p, null));
            }
        }
        catch (FlickrException e) {
            return new ExportResult((Throwable)e);
        }
        PhotosContainerResource photosContainerResource = new PhotosContainerResource((Collection)albumBuilder.build(), (Collection)photosBuilder.build());
        ContinuationData continuationData = new ContinuationData(null);
        subResources.forEach(resource -> continuationData.addContainerResource((ContainerResource)resource));
        return new ExportResult(ExportResult.ResultType.CONTINUE, (DataModel)photosContainerResource, continuationData);
    }

    private ExportResult<PhotosContainerResource> getPhotos(IdOnlyContainerResource resource, PaginationData paginationData) {
        PhotoList photoSetList;
        String photoSetId = resource.getId();
        int page = paginationData == null ? 1 : ((IntPaginationToken)paginationData).getStart();
        try {
            if (Strings.isNullOrEmpty((String)photoSetId)) {
                RequestContext.getRequestContext().setExtras(EXTRAS);
                this.perUserRateLimiter.acquire();
                photoSetList = this.photosInterface.getNotInSet(50, page);
                RequestContext.getRequestContext().setExtras((List)ImmutableList.of());
            } else {
                this.perUserRateLimiter.acquire();
                photoSetList = this.photosetsInterface.getPhotos(photoSetId, (Set)ImmutableSet.copyOf(EXTRAS), 0, 50, page);
            }
        }
        catch (FlickrException e) {
            return new ExportResult((Throwable)e);
        }
        boolean hasMore = photoSetList.getPage() != photoSetList.getPages() && !photoSetList.isEmpty();
        Collection photos = photoSetList.stream().map(p -> FlickrPhotosExporter.toCommonPhoto(p, photoSetId)).collect(Collectors.toList());
        IntPaginationToken newPage = null;
        if (hasMore) {
            newPage = new IntPaginationToken(page + 1);
        }
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (newPage == null) {
            resultType = ExportResult.ResultType.END;
        }
        PhotosContainerResource photosContainerResource = new PhotosContainerResource(null, photos);
        return new ExportResult(resultType, (DataModel)photosContainerResource, new ContinuationData((PaginationData)newPage));
    }

    private ExportResult<PhotosContainerResource> getAlbums(PaginationData paginationData, Auth auth) {
        boolean hasMore;
        Photosets photoSetList;
        ImmutableList.Builder albumBuilder = ImmutableList.builder();
        ArrayList<IdOnlyContainerResource> subResources = new ArrayList<IdOnlyContainerResource>();
        int page = paginationData == null ? 1 : ((IntPaginationToken)paginationData).getStart();
        try {
            this.perUserRateLimiter.acquire();
            photoSetList = this.photosetsInterface.getList(auth.getUser().getId(), 500, page, PHOTOSET_EXTRAS);
        }
        catch (FlickrException e) {
            return new ExportResult((Throwable)e);
        }
        for (Photoset photoSet : photoSetList.getPhotosets()) {
            albumBuilder.add((Object)new PhotoAlbum(photoSet.getId(), photoSet.getTitle(), photoSet.getDescription()));
            subResources.add(new IdOnlyContainerResource(photoSet.getId()));
        }
        IntPaginationToken newPage = null;
        boolean bl = hasMore = photoSetList.getPage() != photoSetList.getPages() && !photoSetList.getPhotosets().isEmpty();
        if (hasMore) {
            newPage = new IntPaginationToken(page + 1);
        } else {
            subResources.add(new IdOnlyContainerResource(PHOTOSET_EXTRAS));
        }
        PhotosContainerResource photosContainerResource = new PhotosContainerResource((Collection)albumBuilder.build(), null);
        ContinuationData continuationData = new ContinuationData((PaginationData)newPage);
        subResources.forEach(resource -> continuationData.addContainerResource((ContainerResource)resource));
        ExportResult.ResultType resultType = ExportResult.ResultType.CONTINUE;
        if (newPage == null) {
            resultType = ExportResult.ResultType.END;
        }
        return new ExportResult(resultType, (DataModel)photosContainerResource, continuationData);
    }
}

