/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.videos;

import com.restfb.Connection;
import com.restfb.DefaultFacebookClient;
import com.restfb.Parameter;
import com.restfb.Version;
import com.restfb.exception.FacebookOAuthException;
import com.restfb.types.Video;
import java.util.ArrayList;
import java.util.Optional;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.transfer.facebook.utils.FacebookTransferUtils;
import org.datatransferproject.transfer.facebook.videos.FacebookVideosInterface;
import org.datatransferproject.types.transfer.auth.AppCredentials;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;

public class RestFbFacebookVideos
implements FacebookVideosInterface {
    private DefaultFacebookClient client;

    RestFbFacebookVideos(TokensAndUrlAuthData authData, AppCredentials appCredentials) {
        this.client = new DefaultFacebookClient(authData.getAccessToken(), appCredentials.getSecret(), Version.VERSION_3_0);
    }

    @Override
    public Connection<Video> getVideos(Optional<String> paginationToken) throws CopyExceptionWithFailureReason {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        parameters.add(Parameter.with((String)"fields", (Object)"description,source"));
        paginationToken.ifPresent(token -> parameters.add(Parameter.with((String)"after", (Object)token)));
        try {
            return this.client.fetchConnection("me/videos/uploaded", Video.class, parameters.toArray(new Parameter[0]));
        }
        catch (FacebookOAuthException e) {
            throw FacebookTransferUtils.handleFacebookOAuthException(e);
        }
    }
}

