/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.facebook.utils;

import com.restfb.exception.FacebookOAuthException;
import org.datatransferproject.spi.transfer.types.CopyExceptionWithFailureReason;
import org.datatransferproject.spi.transfer.types.SessionInvalidatedException;
import org.datatransferproject.spi.transfer.types.UnconfirmedUserException;
import org.datatransferproject.spi.transfer.types.UserCheckpointedException;

public class FacebookTransferUtils {
    public static FacebookOAuthException handleFacebookOAuthException(FacebookOAuthException e) throws CopyExceptionWithFailureReason {
        String message = e.getMessage();
        if (message != null && message.contains("the user is not a confirmed user")) {
            throw new UnconfirmedUserException("The user account is not confirmed or deactivated", (Throwable)e);
        }
        if (message != null && message.contains("code 190, subcode 459")) {
            throw new UserCheckpointedException("The user has been checkpointed", (Throwable)e);
        }
        if (message != null && message.contains("code 190, subcode 460")) {
            throw new SessionInvalidatedException("The user session has been invalidated", (Throwable)e);
        }
        if (message != null && message.contains("code 190, subcode 463")) {
            throw new SessionInvalidatedException("The user session has expired", (Throwable)e);
        }
        return e;
    }
}

