/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.deezer.playlists;

import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.deezer.DeezerApi;
import org.datatransferproject.transfer.deezer.model.Error;
import org.datatransferproject.transfer.deezer.model.InsertResponse;
import org.datatransferproject.transfer.deezer.model.Track;
import org.datatransferproject.types.common.models.playlists.MusicPlaylist;
import org.datatransferproject.types.common.models.playlists.MusicRecording;
import org.datatransferproject.types.common.models.playlists.PlaylistContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class DeezerPlaylistImporter
implements Importer<TokensAndUrlAuthData, PlaylistContainerResource> {
    private final Monitor monitor;
    private final HttpTransport httpTransport;
    private final TransferServiceConfig transferServiceConfig;

    public DeezerPlaylistImporter(Monitor monitor, HttpTransport httpTransport, TransferServiceConfig transferServiceConfig) {
        this.monitor = monitor;
        this.httpTransport = httpTransport;
        this.transferServiceConfig = transferServiceConfig;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokensAndUrlAuthData authData, PlaylistContainerResource data) throws Exception {
        DeezerApi api = new DeezerApi(authData.getAccessToken(), this.httpTransport, this.transferServiceConfig);
        for (MusicPlaylist playlist : data.getLists()) {
            this.createPlaylist(idempotentExecutor, api, playlist);
        }
        return ImportResult.OK;
    }

    private void createPlaylist(IdempotentImportExecutor idempotentExecutor, DeezerApi api, MusicPlaylist playlist) throws Exception {
        Long newPlaylistId = (Long)idempotentExecutor.executeAndSwallowIOExceptions(playlist.getIdentifier(), playlist.getHeadline(), () -> this.createPlaylist(api, playlist));
        if (null == newPlaylistId) {
            this.monitor.severe(() -> String.format("Couldn't create playlist: %s", playlist), new Object[0]);
            return;
        }
        ArrayList<Long> ids = new ArrayList<Long>();
        for (MusicRecording track : playlist.getTrack()) {
            Long newSongId = (Long)idempotentExecutor.executeAndSwallowIOExceptions(newPlaylistId + "-" + track.hashCode(), "Track: " + track + " in " + playlist.getHeadline(), () -> this.lookupTrack(api, track));
            ids.add(newSongId);
        }
        idempotentExecutor.executeAndSwallowIOExceptions(newPlaylistId + "-tracks", "Playlist: " + playlist.getHeadline(), () -> {
            Error insertResponse = api.insertTracksInPlaylist(newPlaylistId, ids);
            if (insertResponse != null) {
                throw new IOException("problem inserting tracks into playlist: " + playlist + " error: " + insertResponse);
            }
            return null;
        });
    }

    private Long createPlaylist(DeezerApi api, MusicPlaylist playlist) {
        try {
            InsertResponse createResponse = api.createPlaylist("Imported - " + playlist.getHeadline());
            if (createResponse.getError() != null) {
                throw new IOException("problem creating playlist: " + playlist + " error: " + createResponse.getError());
            }
            if (createResponse.getError() != null) {
                throw new IOException("Problem creating playlist: " + playlist + ": " + createResponse.getError());
            }
            return createResponse.getId();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private Long lookupTrack(DeezerApi api, MusicRecording track) throws IOException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)track.getIsrcCode()) ? 1 : 0) != 0, (Object)"IRCS code is required");
        Track foundTrack = api.lookupTrackByIsrc(track.getIsrcCode());
        if (foundTrack == null) {
            throw new IllegalArgumentException("Couldn't find matching Deezer track for: " + track);
        }
        return foundTrack.getId();
    }
}

