/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.deezer.playlists;

import com.google.api.client.http.HttpTransport;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.provider.ExportResult;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.transfer.deezer.DeezerApi;
import org.datatransferproject.transfer.deezer.model.PlaylistDetails;
import org.datatransferproject.transfer.deezer.model.PlaylistSummary;
import org.datatransferproject.transfer.deezer.model.Track;
import org.datatransferproject.types.common.ExportInformation;
import org.datatransferproject.types.common.models.DataModel;
import org.datatransferproject.types.common.models.playlists.MusicAlbum;
import org.datatransferproject.types.common.models.playlists.MusicGroup;
import org.datatransferproject.types.common.models.playlists.MusicPlaylist;
import org.datatransferproject.types.common.models.playlists.MusicRecording;
import org.datatransferproject.types.common.models.playlists.PlaylistContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class DeezerPlaylistExporter
implements Exporter<TokensAndUrlAuthData, PlaylistContainerResource> {
    private final Monitor monitor;
    private final HttpTransport httpTransport;
    private final TransferServiceConfig transferServiceConfig;

    public DeezerPlaylistExporter(Monitor monitor, HttpTransport httpTransport, TransferServiceConfig transferServiceConfig) {
        this.monitor = monitor;
        this.httpTransport = httpTransport;
        this.transferServiceConfig = transferServiceConfig;
    }

    public ExportResult<PlaylistContainerResource> export(UUID jobId, TokensAndUrlAuthData authData, Optional<ExportInformation> exportInformation) throws Exception {
        DeezerApi api = new DeezerApi(authData.getAccessToken(), this.httpTransport, this.transferServiceConfig);
        return new ExportResult(ExportResult.ResultType.END, (DataModel)this.enumeratePlaylists(api));
    }

    private PlaylistContainerResource enumeratePlaylists(DeezerApi api) throws IOException {
        ArrayList<MusicPlaylist> results = new ArrayList<MusicPlaylist>();
        for (PlaylistSummary playlistSummary : api.getPlaylists()) {
            results.add(new MusicPlaylist(playlistSummary.getLink(), playlistSummary.getTitle(), this.fetchPlaylist(api, playlistSummary.getId())));
        }
        return new PlaylistContainerResource(results);
    }

    private ImmutableList<MusicRecording> fetchPlaylist(DeezerApi api, long playlistId) throws IOException {
        ImmutableList.Builder results = new ImmutableList.Builder();
        this.monitor.debug(() -> String.format("Fetching playlist's %s tracks", playlistId), new Object[0]);
        PlaylistDetails playlistDetails = api.getPlaylistDetails(playlistId);
        for (Track track : playlistDetails.getTrackCollection().getTracks()) {
            results.add((Object)this.convertTrack(api, track.getId()));
        }
        return results.build();
    }

    private MusicRecording convertTrack(DeezerApi api, long trackId) throws IOException {
        Track track = api.getTrack(trackId);
        return new MusicRecording(track.getLink(), track.getTitle(), track.getIsrc(), new MusicAlbum(track.getAlbum().getLink(), track.getAlbum().getTitle()), new MusicGroup(track.getAlbum().getTitle()));
    }
}

