/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.transfer.deezer;

import com.google.api.client.http.HttpTransport;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.spi.transfer.extension.TransferExtension;
import org.datatransferproject.spi.transfer.provider.Exporter;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.transfer.deezer.playlists.DeezerPlaylistExporter;
import org.datatransferproject.transfer.deezer.playlists.DeezerPlaylistImporter;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.common.models.playlists.PlaylistContainerResource;
import org.datatransferproject.types.transfer.auth.TokensAndUrlAuthData;
import org.datatransferproject.types.transfer.serviceconfig.TransferServiceConfig;

public class DeezerTransferExtension
implements TransferExtension {
    private static final ImmutableList<DataVertical> SUPPORTED_DATA_TYPES = ImmutableList.of((Object)DataVertical.PLAYLISTS);
    private Exporter<TokensAndUrlAuthData, PlaylistContainerResource> exporter;
    private Importer<TokensAndUrlAuthData, PlaylistContainerResource> importer;
    private boolean initialized = false;

    public String getServiceId() {
        return "Deezer";
    }

    public Exporter<?, ?> getExporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"DeezerTransferExtension not initialized. Unable to get Exporter");
        Preconditions.checkArgument((boolean)SUPPORTED_DATA_TYPES.contains((Object)transferDataType));
        return this.exporter;
    }

    public Importer<?, ?> getImporter(DataVertical transferDataType) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"DeezerTransferExtension not initialized. Unable to get Importer");
        Preconditions.checkArgument((boolean)SUPPORTED_DATA_TYPES.contains((Object)transferDataType));
        return this.importer;
    }

    public void initialize(ExtensionContext context) {
        if (this.initialized) {
            Monitor monitor = context.getMonitor();
            monitor.severe(() -> "DeezerTransferExtension already initialized", new Object[0]);
            return;
        }
        Monitor monitor = context.getMonitor();
        HttpTransport httpTransport = (HttpTransport)context.getService(HttpTransport.class);
        TransferServiceConfig transferServiceConfig = (TransferServiceConfig)context.getService(TransferServiceConfig.class);
        this.exporter = new DeezerPlaylistExporter(monitor, httpTransport, transferServiceConfig);
        this.importer = new DeezerPlaylistImporter(monitor, httpTransport, transferServiceConfig);
        this.initialized = true;
    }
}

