/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.videos;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.atomic.LongAdder;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClient;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeDataTransferClientFactory;
import org.datatransferproject.spi.cloud.connection.ConnectionProvider;
import org.datatransferproject.spi.cloud.storage.TemporaryPerJobDataStore;
import org.datatransferproject.spi.transfer.idempotentexecutor.IdempotentImportExecutor;
import org.datatransferproject.spi.transfer.idempotentexecutor.ItemImportResult;
import org.datatransferproject.spi.transfer.provider.ImportResult;
import org.datatransferproject.spi.transfer.provider.Importer;
import org.datatransferproject.types.common.DownloadableItem;
import org.datatransferproject.types.common.ImportableItem;
import org.datatransferproject.types.common.models.videos.VideoModel;
import org.datatransferproject.types.common.models.videos.VideosContainerResource;
import org.datatransferproject.types.transfer.auth.TokenSecretAuthData;

public class BackblazeVideosImporter
implements Importer<TokenSecretAuthData, VideosContainerResource> {
    private static final String VIDEO_TRANSFER_MAIN_FOLDER = "Video Transfer";
    private final TemporaryPerJobDataStore jobStore;
    private final ConnectionProvider connectionProvider;
    private final Monitor monitor;
    private final BackblazeDataTransferClientFactory b2ClientFactory;

    public BackblazeVideosImporter(Monitor monitor, TemporaryPerJobDataStore jobStore, ConnectionProvider connectionProvider, BackblazeDataTransferClientFactory b2ClientFactory) {
        this.monitor = monitor;
        this.jobStore = jobStore;
        this.connectionProvider = connectionProvider;
        this.b2ClientFactory = b2ClientFactory;
    }

    public ImportResult importItem(UUID jobId, IdempotentImportExecutor idempotentExecutor, TokenSecretAuthData authData, VideosContainerResource data) throws Exception {
        if (data == null) {
            return ImportResult.OK;
        }
        BackblazeDataTransferClient b2Client = this.b2ClientFactory.getOrCreateB2Client(jobId, authData);
        LongAdder totalImportedFilesSizes = new LongAdder();
        if (data.getVideos() != null && data.getVideos().size() > 0) {
            for (VideoModel video : data.getVideos()) {
                idempotentExecutor.importAndSwallowIOExceptions((ImportableItem)video, v -> {
                    ItemImportResult<String> fileImportResult = this.importSingleVideo(jobId, b2Client, (VideoModel)v);
                    if (fileImportResult.hasBytes()) {
                        totalImportedFilesSizes.add(fileImportResult.getBytes());
                    }
                    return fileImportResult;
                });
            }
        }
        return ImportResult.OK.copyWithBytes(Long.valueOf(totalImportedFilesSizes.longValue()));
    }

    private ItemImportResult<String> importSingleVideo(UUID jobId, BackblazeDataTransferClient b2Client, VideoModel video) throws IOException {
        ItemImportResult itemImportResult;
        block8: {
            InputStream videoFileStream = this.connectionProvider.getInputStreamForItem(jobId, (DownloadableItem)video).getStream();
            try {
                File file = this.jobStore.getTempFileFromInputStream(videoFileStream, video.getDataId(), ".mp4");
                String res = b2Client.uploadFile(String.format("%s/%s.mp4", VIDEO_TRANSFER_MAIN_FOLDER, video.getDataId()), file);
                itemImportResult = ItemImportResult.success((Serializable)((Object)res), (Long)file.length());
                if (videoFileStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (videoFileStream != null) {
                        try {
                            videoFileStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException e) {
                    this.monitor.info(() -> String.format("Video resource was missing for id: %s", video.getDataId()), new Object[]{e});
                    return ItemImportResult.error((Exception)e, null);
                }
            }
            videoFileStream.close();
        }
        return itemImportResult;
    }
}

