/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.datatransfer.backblaze.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Base64;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.util.EntityUtils;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.datatransfer.backblaze.common.BackblazeS3ClientFactory;
import org.datatransferproject.datatransfer.backblaze.exception.BackblazeCredentialsException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CompleteMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.CompletedMultipartUpload;
import software.amazon.awssdk.services.s3.model.CompletedPart;
import software.amazon.awssdk.services.s3.model.CreateBucketConfiguration;
import software.amazon.awssdk.services.s3.model.CreateBucketRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadRequest;
import software.amazon.awssdk.services.s3.model.CreateMultipartUploadResponse;
import software.amazon.awssdk.services.s3.model.ListBucketsResponse;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectResponse;
import software.amazon.awssdk.services.s3.model.S3Exception;
import software.amazon.awssdk.services.s3.model.UploadPartRequest;
import software.amazon.awssdk.services.s3.model.UploadPartResponse;

public class BackblazeDataTransferClient {
    private static final String DATA_TRANSFER_BUCKET_PREFIX_FORMAT_STRING = "%s-data-transfer";
    private static final int MAX_BUCKET_CREATION_ATTEMPTS = 10;
    private final long sizeThresholdForMultipartUpload;
    private final long partSizeForMultiPartUpload;
    private final BackblazeS3ClientFactory backblazeS3ClientFactory;
    private final Monitor monitor;
    private S3Client s3Client;
    private String bucketName;

    public BackblazeDataTransferClient(Monitor monitor, BackblazeS3ClientFactory backblazeS3ClientFactory, long sizeThresholdForMultipartUpload, long partSizeForMultiPartUpload) {
        this.monitor = monitor;
        this.backblazeS3ClientFactory = backblazeS3ClientFactory;
        if (partSizeForMultiPartUpload <= 0L) {
            throw new IllegalArgumentException("Part size for multipart upload must be positive.");
        }
        this.sizeThresholdForMultipartUpload = sizeThresholdForMultipartUpload;
        this.partSizeForMultiPartUpload = partSizeForMultiPartUpload;
    }

    public void init(String keyId, String applicationKey, String exportService, CloseableHttpClient httpClient) throws BackblazeCredentialsException, IOException {
        String userRegion;
        S3Exception s3Exception;
        ListBucketsResponse listBucketsResponse;
        block3: {
            listBucketsResponse = null;
            s3Exception = null;
            userRegion = this.getAccountRegion(httpClient, keyId, applicationKey);
            this.s3Client = this.backblazeS3ClientFactory.createS3Client(keyId, applicationKey, userRegion);
            try {
                listBucketsResponse = this.s3Client.listBuckets();
            }
            catch (S3Exception e) {
                s3Exception = e;
                if (this.s3Client == null) break block3;
                this.s3Client.close();
            }
        }
        if (listBucketsResponse == null) {
            throw new BackblazeCredentialsException("User's credentials or permissions are not valid for any regions available", s3Exception);
        }
        this.bucketName = this.getOrCreateBucket(this.s3Client, listBucketsResponse, userRegion, exportService);
    }

    public String uploadFile(String fileKey, File file) throws IOException {
        if (this.s3Client == null || this.bucketName == null) {
            throw new IllegalStateException("BackblazeDataTransferClient has not been initialised");
        }
        try {
            long contentLength = file.length();
            this.monitor.debug(() -> String.format("Uploading '%s' with file size %d bytes", fileKey, contentLength), new Object[0]);
            if (contentLength >= this.sizeThresholdForMultipartUpload) {
                this.monitor.debug(() -> String.format("File size is larger than %d bytes, so using multipart upload", this.sizeThresholdForMultipartUpload), new Object[0]);
                return this.uploadFileUsingMultipartUpload(fileKey, file, contentLength);
            }
            PutObjectRequest putObjectRequest = (PutObjectRequest)PutObjectRequest.builder().bucket(this.bucketName).key(fileKey).build();
            PutObjectResponse putObjectResponse = this.s3Client.putObject(putObjectRequest, RequestBody.fromFile((File)file));
            return putObjectResponse.versionId();
        }
        catch (AwsServiceException | SdkClientException e) {
            throw new IOException(String.format("Error while uploading file, fileKey: %s", fileKey), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getAccountRegion(CloseableHttpClient httpClient, String keyId, String applicationKey) throws BackblazeCredentialsException {
        String auth = keyId + ":" + applicationKey;
        byte[] encodedAuth = Base64.getEncoder().encode(auth.getBytes());
        String authHeaderValue = "Basic " + new String(encodedAuth);
        HttpGet request = new HttpGet("https://api.backblazeb2.com/b2api/v2/b2_authorize_account");
        request.addHeader("Authorization", authHeaderValue);
        try {
            CloseableHttpResponse response;
            try (CloseableHttpResponse closeableHttpResponse = response = httpClient.execute((HttpUriRequest)request);){
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode == 200) {
                    String responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
                    JSONParser parser = new JSONParser();
                    JSONObject jsonResponse = (JSONObject)parser.parse(responseBody);
                    String s3ApiUrl = (String)jsonResponse.get((Object)"s3ApiUrl");
                    String region = s3ApiUrl.split("s3.")[1].split("\\.")[0];
                    this.monitor.info(() -> "Region extracted from s3ApiUrl: " + region, new Object[0]);
                    String string = region;
                    return string;
                }
                if (statusCode < 400) throw new IOException("Server returned status code: " + statusCode);
                if (statusCode >= 500) throw new IOException("Server returned status code: " + statusCode);
                throw new BackblazeCredentialsException("Failed to retrieve account's region. Status code: " + statusCode, null);
            }
        }
        catch (IOException | ParseException e) {
            throw new BackblazeCredentialsException("Failed to retrieve account's region", e);
        }
    }

    private String uploadFileUsingMultipartUpload(String fileKey, File file, long contentLength) throws IOException, AwsServiceException, SdkClientException {
        ArrayList<CompletedPart> completedParts = new ArrayList<CompletedPart>();
        CreateMultipartUploadRequest createMultipartUploadRequest = (CreateMultipartUploadRequest)CreateMultipartUploadRequest.builder().bucket(this.bucketName).key(fileKey).build();
        CreateMultipartUploadResponse createMultipartUploadResponse = this.s3Client.createMultipartUpload(createMultipartUploadRequest);
        long filePosition = 0L;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            int i = 1;
            while (filePosition < contentLength) {
                long partSize = Math.min(this.partSizeForMultiPartUpload, contentLength - filePosition);
                UploadPartRequest uploadRequest = (UploadPartRequest)UploadPartRequest.builder().bucket(this.bucketName).key(fileKey).uploadId(createMultipartUploadResponse.uploadId()).partNumber(Integer.valueOf(i)).build();
                RequestBody requestBody = RequestBody.fromInputStream((InputStream)fileInputStream, (long)partSize);
                UploadPartResponse uploadPartResponse = this.s3Client.uploadPart(uploadRequest, requestBody);
                completedParts.add((CompletedPart)CompletedPart.builder().partNumber(Integer.valueOf(i)).eTag(uploadPartResponse.eTag()).build());
                filePosition += partSize;
                ++i;
            }
        }
        CompleteMultipartUploadRequest completeMultipartUploadRequest = (CompleteMultipartUploadRequest)CompleteMultipartUploadRequest.builder().bucket(this.bucketName).key(fileKey).uploadId(createMultipartUploadResponse.uploadId()).multipartUpload((CompletedMultipartUpload)CompletedMultipartUpload.builder().parts(completedParts).build()).build();
        CompleteMultipartUploadResponse completeMultipartUploadResponse = this.s3Client.completeMultipartUpload(completeMultipartUploadRequest);
        return completeMultipartUploadResponse.versionId();
    }

    private String getOrCreateBucket(S3Client s3Client, ListBucketsResponse listBucketsResponse, String region, String exportService) throws IOException {
        String fullPrefix = String.format(DATA_TRANSFER_BUCKET_PREFIX_FORMAT_STRING, exportService.toLowerCase());
        try {
            for (Bucket bucket : listBucketsResponse.buckets()) {
                if (!bucket.name().startsWith(fullPrefix)) continue;
                return bucket.name();
            }
            for (int i = 0; i < 10; ++i) {
                String bucketName = String.format("%s-%s", fullPrefix, RandomStringUtils.randomNumeric((int)8).toLowerCase());
                try {
                    CreateBucketConfiguration createBucketConfiguration = (CreateBucketConfiguration)CreateBucketConfiguration.builder().locationConstraint(region).build();
                    CreateBucketRequest createBucketRequest = (CreateBucketRequest)CreateBucketRequest.builder().bucket(bucketName).createBucketConfiguration(createBucketConfiguration).build();
                    s3Client.createBucket(createBucketRequest);
                    return bucketName;
                }
                catch (Exception e) {
                    this.monitor.info(() -> "Bucket name already exists", new Object[0]);
                    continue;
                }
            }
            throw new IOException(String.format("Failed to create a uniquely named bucket after %d attempts", 10));
        }
        catch (AwsServiceException | SdkClientException e) {
            throw new IOException("Error while creating bucket", e);
        }
    }
}

