/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.auth.rememberthemilk;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.auth.rememberthemilk.RememberTheMilkAuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthDataGenerator;
import org.datatransferproject.spi.api.auth.AuthServiceProviderRegistry;
import org.datatransferproject.spi.api.auth.extension.AuthServiceExtension;
import org.datatransferproject.spi.cloud.storage.AppCredentialStore;
import org.datatransferproject.types.common.models.DataVertical;
import org.datatransferproject.types.transfer.auth.AppCredentials;

public class RememberTheMilkAuthServiceExtension
implements AuthServiceExtension {
    private static final String RTM_KEY = "RTM_KEY";
    private static final String RTM_SECRET = "RTM_SECRET";
    private static final String SERVICE_ID = "REMEMBER_THE_MILK";
    private final List<DataVertical> supportedServices = ImmutableList.of((Object)DataVertical.TASKS);
    private RememberTheMilkAuthDataGenerator importAuthDataGenerator;
    private RememberTheMilkAuthDataGenerator exportAuthDataGenerator;
    private boolean initialized = false;

    public String getServiceId() {
        return SERVICE_ID;
    }

    public AuthDataGenerator getAuthDataGenerator(DataVertical transferDataType, AuthServiceProviderRegistry.AuthMode mode) {
        Preconditions.checkArgument((boolean)this.initialized, (Object)"RememberTheMilkAuthServiceExtension is not initialized! Unable to retrieve AuthDataGenerator");
        Preconditions.checkArgument((boolean)this.supportedServices.contains(transferDataType), (Object)("Transfer type [" + transferDataType + "] is not supported in RememberTheMilk"));
        return mode == AuthServiceProviderRegistry.AuthMode.IMPORT ? this.importAuthDataGenerator : this.exportAuthDataGenerator;
    }

    public List<DataVertical> getImportTypes() {
        return this.supportedServices;
    }

    public List<DataVertical> getExportTypes() {
        return this.supportedServices;
    }

    public void initialize(ExtensionContext context) {
        AppCredentials appCredentials;
        if (this.initialized) {
            return;
        }
        try {
            appCredentials = ((AppCredentialStore)context.getService(AppCredentialStore.class)).getAppCredentials(RTM_KEY, RTM_SECRET);
        }
        catch (IOException e) {
            Monitor monitor = context.getMonitor();
            monitor.info(() -> String.format("Unable to retrieve RememberTheMilk AppCredentials. Did you set %s and %s?", RTM_KEY, RTM_SECRET), new Object[]{e});
            return;
        }
        Monitor monitor = context.getMonitor();
        this.importAuthDataGenerator = new RememberTheMilkAuthDataGenerator(appCredentials, AuthServiceProviderRegistry.AuthMode.IMPORT, monitor);
        this.exportAuthDataGenerator = new RememberTheMilkAuthDataGenerator(appCredentials, AuthServiceProviderRegistry.AuthMode.EXPORT, monitor);
        this.initialized = true;
    }
}

