/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.monitor;

import com.google.common.base.Strings;
import com.google.common.base.Throwables;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import java.util.function.Supplier;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.launcher.monitor.events.EventCode;

public class ConsoleMonitor
implements Monitor {
    private final Level minLevel;
    private final boolean useAnsiColor = ConsoleMonitor.shouldUseColor();
    private static final String ANSI_RESET = "\u001b[0m";
    private static final String ANSI_BLACK = "\u001b[30m";
    private static final String ANSI_RED = "\u001b[31m";
    private static final String ANSI_BLUE = "\u001b[34m";

    public ConsoleMonitor(Level minLevel) {
        this.minLevel = minLevel;
    }

    @Override
    public void severe(Supplier<String> supplier, Object ... data) {
        this.output("SEVERE", supplier, ANSI_RED, data);
    }

    @Override
    public void info(Supplier<String> supplier, Object ... data) {
        if (Level.INFO.value < this.minLevel.value) {
            return;
        }
        this.output("INFO", supplier, ANSI_BLUE, data);
    }

    @Override
    public void debug(Supplier<String> supplier, Object ... data) {
        if (Level.DEBUG.value < this.minLevel.value) {
            return;
        }
        this.output("DEBUG", supplier, ANSI_BLACK, data);
    }

    private void output(String level, Supplier<String> supplier, String color, Object ... data) {
        StringBuilder builder = new StringBuilder();
        if (this.useAnsiColor) {
            builder.append(color);
        }
        builder.append(level);
        builder.append(" ");
        builder.append(ZonedDateTime.now(ZoneId.systemDefault()).format(DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        builder.append(" ");
        builder.append(supplier.get());
        if (this.useAnsiColor) {
            builder.append(ANSI_RESET);
        }
        if (data != null) {
            for (Object datum : data) {
                if (datum instanceof Throwable) {
                    builder.append(Throwables.getStackTraceAsString((Throwable)((Throwable)datum)));
                    continue;
                }
                if (datum instanceof UUID) {
                    builder.append("JobId: ");
                    builder.append(((UUID)datum).toString());
                    continue;
                }
                if (datum instanceof EventCode) {
                    builder.append("EventCode: ");
                    builder.append(((EventCode)datum).toString());
                    continue;
                }
                if (datum == null) continue;
                builder.append(datum);
            }
        }
        System.err.println(builder.toString());
    }

    private static final boolean shouldUseColor() {
        try {
            String osName = System.getProperty("os.name");
            return ConsoleMonitor.getEnv("FORCE_COLOR") && !ConsoleMonitor.getEnv("NO_COLOR") && !osName.contains("Windows");
        }
        catch (Exception e) {
            return false;
        }
    }

    private static final boolean getEnv(String envVarName) {
        try {
            String rawEnvValue = System.getenv(envVarName);
            if (Strings.isNullOrEmpty((String)rawEnvValue)) {
                return false;
            }
            return rawEnvValue.equals("1") || rawEnvValue.equals("true");
        }
        catch (Exception e) {
            return false;
        }
    }

    public static enum Level {
        SEVERE(2),
        INFO(1),
        DEBUG(0);

        int value;

        private Level(int value) {
            this.value = value;
        }
    }
}

