/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.launcher.metrics;

import com.google.common.base.Preconditions;
import java.time.Duration;
import org.datatransferproject.api.launcher.DtpInternalMetricRecorder;
import org.datatransferproject.api.launcher.MetricRecorder;
import org.datatransferproject.types.common.models.DataVertical;

public class ServiceAwareMetricRecorder
implements MetricRecorder {
    private final String service;
    private final DtpInternalMetricRecorder metricRecorder;

    public ServiceAwareMetricRecorder(String service, DtpInternalMetricRecorder metricRecorder) {
        this.service = service;
        this.metricRecorder = (DtpInternalMetricRecorder)Preconditions.checkNotNull((Object)metricRecorder, (Object)"metricRecorder can't be null");
    }

    @Override
    public void recordMetric(DataVertical dataType, String tag) {
        this.metricRecorder.recordGenericMetric(dataType, this.service, tag);
    }

    @Override
    public void recordMetric(DataVertical dataType, String tag, boolean bool) {
        this.metricRecorder.recordGenericMetric(dataType, this.service, tag, bool);
    }

    @Override
    public void recordMetric(DataVertical dataType, String tag, Duration duration) {
        this.metricRecorder.recordGenericMetric(dataType, this.service, tag, duration);
    }

    @Override
    public void recordMetric(DataVertical dataType, String tag, int value) {
        this.metricRecorder.recordGenericMetric(dataType, this.service, tag, value);
    }
}

