/*
 * Decompiled with CFR 0.152.
 */
package org.datatransferproject.api.launcher;

import java.util.HashMap;
import java.util.Map;
import org.datatransferproject.api.launcher.Constants;
import org.datatransferproject.api.launcher.ExtensionContext;
import org.datatransferproject.api.launcher.Monitor;
import org.datatransferproject.api.launcher.TypeManager;

public class DelegatingExtensionContext
implements ExtensionContext {
    private final Map<Class<?>, Object> overriddenRegisteredClasses = new HashMap();
    private final ExtensionContext baseExtensionContext;

    public DelegatingExtensionContext(ExtensionContext baseExtensionContext) {
        this.baseExtensionContext = baseExtensionContext;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.baseExtensionContext.getTypeManager();
    }

    @Override
    public Monitor getMonitor() {
        return this.baseExtensionContext.getMonitor();
    }

    @Override
    public <T> void registerService(Class<T> type, T service) {
        this.baseExtensionContext.registerService(type, service);
    }

    @Override
    public <T> T getService(Class<T> type) {
        if (this.overriddenRegisteredClasses.containsKey(type)) {
            return type.cast(this.overriddenRegisteredClasses.get(type));
        }
        return this.baseExtensionContext.getService(type);
    }

    @Override
    public <T> T getSetting(String setting, T defaultValue) {
        return this.baseExtensionContext.getSetting(setting, defaultValue);
    }

    @Override
    public String cloud() {
        return this.baseExtensionContext.cloud();
    }

    @Override
    public Constants.Environment environment() {
        return this.baseExtensionContext.environment();
    }

    public <T> void registerOverrideService(Class<T> type, T service) {
        if (this.overriddenRegisteredClasses.containsKey(type)) {
            this.getMonitor().info(() -> String.format("Re-overriding type %s from %s to %s", type, this.overriddenRegisteredClasses.get(type), service), new Object[0]);
        }
        this.overriddenRegisteredClasses.put(type, service);
    }
}

