/*
 * Decompiled with CFR 0.152.
 */
package visad.test;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import ucar.netcdf.NetcdfFile;
import visad.ContourControl;
import visad.DataReferenceImpl;
import visad.Display;
import visad.DisplayImpl;
import visad.FieldImpl;
import visad.GraphicsModeControl;
import visad.RealType;
import visad.ScalarMap;
import visad.VisADException;
import visad.data.netcdf.QuantityDB;
import visad.data.netcdf.QuantityDBManager;
import visad.data.netcdf.in.NetcdfAdapter;
import visad.java3d.DisplayImplJ3D;
import visad.util.CmdlineConsumer;
import visad.util.CmdlineParser;
import visad.util.Util;

public class TriangleStripBuilderTest
implements CmdlineConsumer {
    private static Logger log = Logger.getLogger(TriangleStripBuilderTest.class.getName());
    private int verbosity = 0;
    private String filename;
    private CmdlineParser parser = new CmdlineParser(this);

    public static void main(String[] args) throws Exception {
        TriangleStripBuilderTest test = new TriangleStripBuilderTest();
        test.parser.processArgs(args);
        NetcdfFile netcdf = new NetcdfFile(test.filename, true);
        QuantityDB db = QuantityDBManager.instance();
        NetcdfAdapter adapter = new NetcdfAdapter(netcdf, db);
        FieldImpl data = (FieldImpl)adapter.getData();
        log.info("loaded " + data.getType().toString());
        final DisplayImplJ3D display = new DisplayImplJ3D("display");
        ScalarMap xmap = new ScalarMap(RealType.Longitude, Display.XAxis);
        display.addMap(xmap);
        ScalarMap ymap = new ScalarMap(RealType.Latitude, Display.YAxis);
        display.addMap(ymap);
        ScalarMap rgbaMap = new ScalarMap(RealType.Altitude, Display.RGBA);
        display.addMap(rgbaMap);
        ScalarMap map1contour = new ScalarMap(RealType.Altitude, Display.IsoContour);
        display.addMap(map1contour);
        ContourControl ctrl = (ContourControl)map1contour.getControl();
        ctrl.setDashedStyle(0);
        ctrl.setContourFill(true);
        GraphicsModeControl mode = ((DisplayImpl)display).getGraphicsModeControl();
        mode.setProjectionPolicy(0);
        mode.setScaleEnable(true);
        final DataReferenceImpl ref = new DataReferenceImpl("r");
        ref.setData(data);
        JFrame jframe = new JFrame();
        jframe.setDefaultCloseOperation(3);
        jframe.setLayout(new BorderLayout());
        jframe.add((Component)((JPanel)display.getComponent()), "Center");
        JPanel panel = new JPanel();
        JButton start = new JButton("Start");
        start.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    display.addReference(ref, null);
                }
                catch (RemoteException e) {
                    e.printStackTrace();
                }
                catch (VisADException e) {
                    e.printStackTrace();
                }
            }
        });
        panel.add(start);
        jframe.add((Component)panel, "South");
        jframe.pack();
        jframe.setVisible(true);
    }

    public int checkKeyword(String mainName, int thisArg, String[] args) {
        this.filename = args[thisArg];
        if (!new File(this.filename).exists()) {
            return -1;
        }
        return 1;
    }

    public int checkOption(String mainName, char ch, String arg) {
        switch (ch) {
            case 'v': {
                ++this.verbosity;
                return 1;
            }
        }
        return 0;
    }

    public boolean finalizeArgs(String mainName) {
        Util.configureLogging(this.verbosity);
        return true;
    }

    public void initializeArgs() {
    }

    public String keywordUsage() {
        return "";
    }

    public String optionUsage() {
        return "[-v ...] <nc file>";
    }
}

