/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.WmoCodeTable;
import ucar.nc2.time.CalendarPeriod;
import ucar.unidata.util.StringUtil2;

public class Grib2Utils {
    public static String clean(String s) {
        StringBuilder sb = new StringBuilder(s);
        StringUtil2.replace(sb, "/. ", "-p_");
        StringUtil2.remove(sb, "(),;");
        char c = sb.charAt(0);
        if (Character.isLetter(c)) {
            if (Character.isLowerCase(c)) {
                sb.setCharAt(0, Character.toUpperCase(c));
            }
        } else {
            sb.insert(0, 'N');
        }
        return sb.toString().trim();
    }

    public static String getVariableName(Grib2Record gr) {
        String s = WmoCodeTable.getParameterName(gr.getDiscipline(), gr.getPDS().getParameterCategory(), gr.getPDS().getParameterNumber());
        if (s == null) {
            s = "U" + gr.getDiscipline() + "-" + gr.getPDS().getParameterCategory() + "-" + gr.getPDS().getParameterNumber();
        }
        return s;
    }

    public static CalendarPeriod getCalendarPeriod(int timeUnit) {
        switch (timeUnit) {
            case 0: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Minute);
            }
            case 1: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Hour);
            }
            case 2: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Day);
            }
            case 3: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Month);
            }
            case 4: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Year);
            }
            case 5: {
                return CalendarPeriod.of(10, CalendarPeriod.Field.Year);
            }
            case 6: {
                return CalendarPeriod.of(30, CalendarPeriod.Field.Year);
            }
            case 7: {
                return CalendarPeriod.of(100, CalendarPeriod.Field.Year);
            }
            case 10: {
                return CalendarPeriod.of(3, CalendarPeriod.Field.Hour);
            }
            case 11: {
                return CalendarPeriod.of(6, CalendarPeriod.Field.Hour);
            }
            case 12: {
                return CalendarPeriod.of(12, CalendarPeriod.Field.Hour);
            }
            case 13: {
                return CalendarPeriod.of(1, CalendarPeriod.Field.Second);
            }
        }
        return null;
    }

    public static boolean isLayer(Grib2Pds pds) {
        return pds.getLevelType2() != 255 && pds.getLevelType2() != 0;
    }

    public static boolean isLatLon(int gridTemplate, int center) {
        return gridTemplate < 4 || gridTemplate >= 40 && gridTemplate < 44;
    }

    public static boolean isLatLon2D(int gridTemplate, int center) {
        return center == 7 && gridTemplate == 204;
    }

    public static LatLonCoordType getLatLon2DcoordType(String desc) {
        Object type = desc.contains("u-component") ? LatLonCoordType.U : (desc.contains("v-component") ? LatLonCoordType.V : (desc.contains("Latitude of") || desc.contains("Longitude of") ? null : LatLonCoordType.P));
        return type;
    }

    public static String cleanupHeader(byte[] raw) {
        String result = StringUtil2.cleanup(raw);
        int pos = result.indexOf("data");
        if (pos > 0) {
            result = result.substring(pos);
        }
        return result;
    }

    public static enum LatLonCoordType {
        U,
        V,
        P;

    }
}

