/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.jdom2.Element;
import org.slf4j.Logger;
import thredds.client.catalog.Catalog;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateVert;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.grib.EnsCoord;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.GribStatType;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.VertCoord;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.grib2.Grib2Utils;
import ucar.nc2.iosp.AbstractIOServiceProvider;
import ucar.nc2.time.Calendar;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.Misc;
import ucar.unidata.geoloc.projection.RotatedPole;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public abstract class GribIosp
extends AbstractIOServiceProvider {
    public static final String VARIABLE_ID_ATTNAME = "Grib_Variable_Id";
    public static final String GRIB_VALID_TIME = "GRIB forecast or observation time";
    public static boolean debugRead = false;
    public static int debugIndexOnlyCount = 0;
    static boolean debugIndexOnlyShow = false;
    static boolean debugIndexOnly = false;
    public static boolean debugGbxIndexOnly = false;
    private static final boolean debug = false;
    private static final boolean debugTime = false;
    private static final boolean debugName = false;
    protected FeatureCollectionConfig config = new FeatureCollectionConfig();
    protected final boolean isGrib1;
    protected final Logger logger;
    protected GribCollectionImmutable gribCollection;
    protected GribCollectionImmutable.GroupGC gHcs;
    protected GribCollectionImmutable.Type gtype;
    protected boolean isPartitioned;
    protected boolean owned;
    protected GribTables gribTable;

    public static void setDebugFlags(DebugFlags debugFlag) {
        debugRead = debugFlag.isSet("Grib/showRead");
        debugIndexOnly = debugFlag.isSet("Grib/indexOnly");
        debugIndexOnlyShow = debugFlag.isSet("Grib/indexOnlyShow");
        debugGbxIndexOnly = debugFlag.isSet("Grib/debugGbxIndexOnly");
    }

    public void setParamTable(Element paramTable) {
        this.config.gribConfig.paramTable = paramTable;
    }

    public void setLookupTablePath(String lookupTablePath) {
        this.config.gribConfig.lookupTablePath = lookupTablePath;
    }

    public void setParamTablePath(String paramTablePath) {
        this.config.gribConfig.paramTablePath = paramTablePath;
    }

    @Override
    public Object sendIospMessage(Object special) {
        if (special instanceof String) {
            int pos;
            String s = (String)special;
            if (s.startsWith("gribParameterTableLookup")) {
                int pos2 = s.indexOf("=");
                if (pos2 > 0) {
                    this.config.gribConfig.lookupTablePath = s.substring(pos2 + 1).trim();
                }
            } else if (s.startsWith("gribParameterTable") && (pos = s.indexOf("=")) > 0) {
                this.config.gribConfig.paramTablePath = s.substring(pos + 1).trim();
            }
            return null;
        }
        if (special instanceof Element) {
            Element root = (Element)special;
            this.config.gribConfig.configFromXml(root, Catalog.ncmlNS);
            return null;
        }
        return super.sendIospMessage(special);
    }

    public GribIosp(boolean isGrib1, Logger logger) {
        this.isGrib1 = isGrib1;
        this.logger = logger;
    }

    protected abstract GribTables createCustomizer() throws IOException;

    protected abstract String makeVariableName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableLongName(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableNameFromRecord(GribCollectionImmutable.VariableIndex var1);

    protected abstract String makeVariableUnits(GribCollectionImmutable.VariableIndex var1);

    protected abstract String getVerticalCoordDesc(int var1);

    protected abstract GribTables.Parameter getParameter(GribCollectionImmutable.VariableIndex var1);

    protected abstract void addVariableAttributes(Variable var1, GribCollectionImmutable.VariableIndex var2);

    protected abstract void show(RandomAccessFile var1, long var2) throws IOException;

    protected abstract float[] readData(RandomAccessFile var1, DataRecord var2) throws IOException;

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        if (this.gHcs != null) {
            this.gribCollection = this.gHcs.getGribCollection();
            if (this.gribCollection instanceof PartitionCollectionImmutable) {
                this.isPartitioned = true;
            }
            this.gribTable = this.createCustomizer();
            this.addGroup(ncfile, ncfile.getRootGroup(), this.gHcs, this.gtype, false);
        } else if (this.gribCollection == null) {
            this.gribCollection = GribCdmIndex.openGribCollectionFromRaf(raf, this.config, CollectionUpdateType.testIndexOnly, this.logger);
            if (this.gribCollection == null) {
                throw new IllegalStateException("Not a GRIB data file or index file " + raf.getLocation());
            }
            this.isPartitioned = this.gribCollection instanceof PartitionCollectionImmutable;
            this.gribTable = this.createCustomizer();
            boolean useDatasetGroup = this.gribCollection.getDatasets().size() > 1;
            for (GribCollectionImmutable.Dataset ds : this.gribCollection.getDatasets()) {
                Group topGroup;
                if (useDatasetGroup) {
                    topGroup = new Group(ncfile, null, ds.getType().toString());
                    ncfile.addGroup(null, topGroup);
                } else {
                    topGroup = ncfile.getRootGroup();
                }
                Iterable<GribCollectionImmutable.GroupGC> groups = ds.getGroups();
                boolean useGroups = ds.getGroupsSize() > 1;
                for (GribCollectionImmutable.GroupGC g : groups) {
                    this.addGroup(ncfile, topGroup, g, ds.getType(), useGroups);
                }
            }
        }
        for (Attribute att : this.gribCollection.getGlobalAttributes()) {
            ncfile.addAttribute(null, att);
        }
    }

    private void addGroup(NetcdfFile ncfile, Group parent, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype, boolean useGroups) {
        Group g;
        if (useGroups) {
            g = new Group(ncfile, parent, group.getId());
            g.addAttribute(new Attribute("long_name", group.getDescription()));
            try {
                ncfile.addGroup(parent, g);
            }
            catch (Exception e) {
                this.logger.warn("Duplicate Group - skipping");
                return;
            }
        } else {
            g = parent;
        }
        this.makeGroup(ncfile, g, group, gctype);
    }

    private void makeGroup(NetcdfFile ncfile, Group g, GribCollectionImmutable.GroupGC group, GribCollectionImmutable.Type gctype) {
        Object cv;
        String horizDims;
        Variable hcsV;
        boolean isLatLon;
        GdsHorizCoordSys hcs = group.getGdsHorizCoordSys();
        String grid_mapping = hcs.getName() + "_Projection";
        boolean isRotatedLatLon = !this.isGrib1 && hcs.proj instanceof RotatedPole;
        boolean isLatLon2D = !this.isGrib1 && Grib2Utils.isLatLon2D(hcs.template, this.gribCollection.getCenter());
        boolean bl = isLatLon = this.isGrib1 ? hcs.isLatLon() : Grib2Utils.isLatLon(hcs.template, this.gribCollection.getCenter());
        if (isRotatedLatLon) {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "rlat rlon";
            ncfile.addDimension(g, new Dimension("rlat", hcs.ny));
            ncfile.addDimension(g, new Dimension("rlon", hcs.nx));
            Variable rlat = ncfile.addVariable(g, new Variable(ncfile, g, null, "rlat", DataType.FLOAT, "rlat"));
            rlat.addAttribute(new Attribute("standard_name", "grid_latitude"));
            rlat.addAttribute(new Attribute("units", "degrees"));
            rlat.setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
            Variable rlon = ncfile.addVariable(g, new Variable(ncfile, g, null, "rlon", DataType.FLOAT, "rlon"));
            rlon.addAttribute(new Attribute("standard_name", "grid_longitude"));
            rlon.addAttribute(new Attribute("units", "degrees"));
            rlon.setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
        } else if (isLatLon2D) {
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
        } else if (isLatLon) {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "lat lon";
            ncfile.addDimension(g, new Dimension("lon", hcs.nx));
            ncfile.addDimension(g, new Dimension("lat", hcs.ny));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lat", DataType.FLOAT, "lat"));
            ((Variable)cv).addAttribute(new Attribute("units", "degrees_north"));
            if (hcs.getGaussianLats() != null) {
                ((Variable)cv).setCachedData(hcs.getGaussianLats());
            } else {
                ((Variable)cv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
            }
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "lon", DataType.FLOAT, "lon"));
            ((Variable)cv).addAttribute(new Attribute("units", "degrees_east"));
            ((Variable)cv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
        } else {
            hcsV = ncfile.addVariable(g, new Variable(ncfile, g, null, grid_mapping, DataType.INT, ""));
            hcsV.setCachedData(Array.factory(DataType.INT, new int[0], (Object)new int[]{0}));
            for (Parameter p : hcs.proj.getProjectionParameters()) {
                hcsV.addAttribute(new Attribute(p));
            }
            horizDims = "y x";
            ncfile.addDimension(g, new Dimension("x", hcs.nx));
            ncfile.addDimension(g, new Dimension("y", hcs.ny));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "x", DataType.FLOAT, "x"));
            ((Variable)cv).addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            ((Variable)cv).addAttribute(new Attribute("units", "km"));
            ((Variable)cv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.nx, hcs.startx, hcs.dx));
            cv = ncfile.addVariable(g, new Variable(ncfile, g, null, "y", DataType.FLOAT, "y"));
            ((Variable)cv).addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            ((Variable)cv).addAttribute(new Attribute("units", "km"));
            ((Variable)cv).setCachedData(Array.makeArray(DataType.FLOAT, hcs.ny, hcs.starty, hcs.dy));
        }
        boolean is1Dtime = gctype == GribCollectionImmutable.Type.MRSTC || gctype == GribCollectionImmutable.Type.TP;
        for (Coordinate coord : group.coords) {
            Coordinate.Type ctype = coord.getType();
            switch (ctype) {
                case runtime: {
                    if (is1Dtime) break;
                    this.makeRuntimeCoordinate(ncfile, g, (CoordinateRuntime)coord);
                    break;
                }
                case timeIntv: {
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTimeIntv)coord);
                    break;
                }
                case time: {
                    this.makeTimeCoordinate1D(ncfile, g, (CoordinateTime)coord);
                    break;
                }
                case vert: {
                    this.makeVerticalCoordinate(ncfile, g, (CoordinateVert)coord);
                    break;
                }
                case ens: {
                    this.makeEnsembleCoordinate(ncfile, g, (CoordinateEns)coord);
                    break;
                }
                case time2D: {
                    this.makeTimeCoordinate2D(ncfile, g, (CoordinateTime2D)coord, gctype);
                }
            }
        }
        for (GribCollectionImmutable.VariableIndex vindex : group.variList) {
            Formatter dimNames = new Formatter();
            Formatter coordinateAtt = new Formatter();
            Coordinate run = vindex.getCoordinate(Coordinate.Type.runtime);
            CoordinateTimeAbstract time = vindex.getCoordinateTime();
            boolean isRunScaler = run != null && run.getSize() == 1;
            switch (gctype) {
                case GC: 
                case SRC: {
                    assert (isRunScaler);
                    dimNames.format("%s ", time.getName());
                    coordinateAtt.format("%s %s ", run.getName(), time.getName());
                    break;
                }
                case MRSTC: 
                case TP: {
                    dimNames.format("%s ", time.getName());
                    coordinateAtt.format("ref%s %s ", time.getName(), time.getName());
                    break;
                }
                case MRC: 
                case TwoD: {
                    assert (run != null) : "GRIB MRC or TWOD does not have run coordinate";
                    if (isRunScaler) {
                        dimNames.format("%s ", time.getName());
                    } else {
                        dimNames.format("%s %s ", run.getName(), time.getName());
                    }
                    coordinateAtt.format("%s %s ", run.getName(), time.getName());
                    break;
                }
                case Best: 
                case BestComplete: {
                    dimNames.format("%s ", time.getName());
                    coordinateAtt.format("ref%s %s ", time.getName(), time.getName());
                    break;
                }
                default: {
                    throw new IllegalStateException("Uknown GribCollection TYpe = " + (Object)((Object)gctype));
                }
            }
            for (Coordinate coord : vindex.getCoordinates()) {
                if (coord instanceof CoordinateTimeAbstract || coord instanceof CoordinateRuntime) continue;
                String name = coord.getName().toLowerCase();
                dimNames.format("%s ", name);
                coordinateAtt.format("%s ", name);
            }
            dimNames.format("%s", horizDims);
            coordinateAtt.format("%s ", horizDims);
            String vname = this.makeVariableName(vindex);
            Variable v = new Variable(ncfile, g, null, vname, DataType.FLOAT, dimNames.toString());
            ncfile.addVariable(g, v);
            String desc = this.makeVariableLongName(vindex);
            v.addAttribute(new Attribute("long_name", desc));
            v.addAttribute(new Attribute("units", this.makeVariableUnits(vindex)));
            GribTables.Parameter gp = this.getParameter(vindex);
            if (gp != null) {
                if (gp.getDescription() != null) {
                    v.addAttribute(new Attribute("description", gp.getDescription()));
                }
                if (gp.getAbbrev() != null) {
                    v.addAttribute(new Attribute("abbreviation", gp.getAbbrev()));
                }
                v.addAttribute(new Attribute("missing_value", gp.getMissing()));
                if (gp.getFill() != null) {
                    v.addAttribute(new Attribute("_FillValue", gp.getFill()));
                }
            } else {
                v.addAttribute(new Attribute("missing_value", Float.valueOf(Float.NaN)));
            }
            if (isLatLon2D) {
                String s = this.searchCoord(Grib2Utils.getLatLon2DcoordType(desc), group.variList);
                if (s == null) {
                    v.setDimensions(horizDims);
                    String units = desc.contains("Latitude of") ? "degrees_north" : "degrees_east";
                    v.addAttribute(new Attribute("units", units));
                } else {
                    coordinateAtt.format("%s ", s);
                }
            } else {
                v.addAttribute(new Attribute("grid_mapping", grid_mapping));
            }
            v.addAttribute(new Attribute("coordinates", coordinateAtt.toString()));
            if (vindex.getIntvType() >= 0) {
                GribStatType statType = this.gribTable.getStatType(vindex.getIntvType());
                if (statType != null) {
                    v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", statType.toString()));
                    CF.CellMethods cm = GribStatType.getCFCellMethod(statType);
                    Coordinate timeCoord = vindex.getCoordinate(Coordinate.Type.timeIntv);
                    if (cm != null && timeCoord != null) {
                        v.addAttribute(new Attribute("cell_methods", timeCoord.getName() + ": " + cm.toString()));
                    }
                } else {
                    v.addAttribute(new Attribute("Grib_Statistical_Interval_Type", vindex.getIntvType()));
                }
            }
            this.addVariableAttributes(v, vindex);
            v.setSPobject(vindex);
        }
    }

    private void makeRuntimeCoordinate(NetcdfFile ncfile, Group g, CoordinateRuntime rtc) {
        String dims;
        int n = rtc.getSize();
        boolean isScalar = n == 1;
        String tcName = rtc.getName();
        String string = dims = isScalar ? null : rtc.getName();
        if (!isScalar) {
            ncfile.addDimension(g, new Dimension(tcName, n));
        }
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        v.addAttribute(new Attribute("units", rtc.getUnit()));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.setSPobject(new Time2Dinfo(Time2DinfoType.reftime, null, rtc));
    }

    private void makeTimeCoordinate2D(NetcdfFile ncfile, Group g, CoordinateTime2D time2D, GribCollectionImmutable.Type gctype) {
        CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        String tcName = time2D.getName();
        boolean is1Dtime = gctype == GribCollectionImmutable.Type.MRSTC || gctype == GribCollectionImmutable.Type.TP;
        boolean hasOneRun = nruns == 1;
        String dims = hasOneRun || is1Dtime ? tcName : runtime.getName() + " " + tcName;
        int dimLength = is1Dtime ? nruns : ntimes;
        ncfile.addDimension(g, new Dimension(tcName, dimLength));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = runtime.getUnit();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        if (!time2D.isTimeInterval()) {
            v.setSPobject(new Time2Dinfo(Time2DinfoType.off, time2D, null));
        } else {
            v.setSPobject(new Time2Dinfo(Time2DinfoType.intv, time2D, null));
            String bounds_name = tcName + "_bounds";
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
            v.addAttribute(new Attribute("bounds", bounds_name));
            bounds.addAttribute(new Attribute("units", units));
            bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
            bounds.setSPobject(new Time2Dinfo(Time2DinfoType.bounds, time2D, null));
        }
        if (is1Dtime) {
            String refName = "ref" + tcName;
            Variable vref = ncfile.addVariable(g, new Variable(ncfile, g, null, refName, DataType.DOUBLE, tcName));
            vref.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
            vref.addAttribute(new Attribute("long_name", "GRIB reference time"));
            vref.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
            vref.addAttribute(new Attribute("units", units));
            vref.setSPobject(new Time2Dinfo(Time2DinfoType.is1Dtime, time2D, null));
        }
    }

    private Array makeLazyCoordinateData(Variable v2, Time2Dinfo info) {
        if (info.time2D != null) {
            return this.makeLazyTime2Darray(v2, info);
        }
        return this.makeLazyTime1Darray(v2, info);
    }

    private Array makeLazyTime1Darray(Variable v2, Time2Dinfo info) {
        int length = info.time1D.getSize();
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case reftime: {
                CoordinateRuntime rtc = (CoordinateRuntime)info.time1D;
                int count = 0;
                for (double val : rtc.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case timeAuxRef: {
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)info.time1D;
                int count = 0;
                List<Double> masterOffsets = this.gribCollection.getMasterRuntime().getOffsetsInTimeUnits();
                for (int masterIdx : time.getTime2runtime()) {
                    data[count++] = masterOffsets.get(masterIdx - 1);
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
        }
        return null;
    }

    private Array makeLazyTime2Darray(Variable v2, Time2Dinfo info) {
        CoordinateTime2D time2D = info.time2D;
        int nruns = time2D.getNruns();
        int ntimes = time2D.getNtimes();
        int length = nruns * ntimes;
        if (info.which == Time2DinfoType.bounds) {
            length *= 2;
        }
        double[] data = new double[length];
        for (int i = 0; i < length; ++i) {
            data[i] = Double.NaN;
        }
        switch (info.which) {
            case off: {
                int runIdx;
                for (runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTime coordTime = (CoordinateTime)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (int val : coordTime.getOffsetSorted()) {
                        data[runIdx * ntimes + timeIdx] = val + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case intv: {
                int runIdx;
                for (runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes + timeIdx] = tinv.getBounds2() + time2D.getOffset(runIdx);
                        ++timeIdx;
                    }
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case is1Dtime: {
                CoordinateRuntime runtime = time2D.getRuntimeCoordinate();
                int count = 0;
                for (double val : runtime.getOffsetsInTimeUnits()) {
                    data[count++] = val;
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
            case bounds: {
                for (int runIdx = 0; runIdx < nruns; ++runIdx) {
                    CoordinateTimeIntv timeIntv = (CoordinateTimeIntv)time2D.getTimeCoordinate(runIdx);
                    int timeIdx = 0;
                    for (TimeCoord.Tinv tinv : timeIntv.getTimeIntervals()) {
                        data[runIdx * ntimes * 2 + timeIdx] = tinv.getBounds1() + time2D.getOffset(runIdx);
                        data[runIdx * ntimes * 2 + timeIdx + 1] = tinv.getBounds2() + time2D.getOffset(runIdx);
                        timeIdx += 2;
                    }
                }
                return Array.factory(DataType.DOUBLE, v2.getShape(), (Object)data);
            }
        }
        throw new IllegalStateException();
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTime coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getUnit() + " since " + coordTime.getRefDate();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (int val : coordTime.getOffsetSorted()) {
            data[count++] = val;
        }
        v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data));
        this.makeTimeAuxReference(ncfile, g, tcName, units, coordTime);
    }

    private void makeTimeAuxReference(NetcdfFile ncfile, Group g, String timeName, String units, CoordinateTimeAbstract time) {
        if (time.getTime2runtime() == null) {
            return;
        }
        String tcName = "ref" + timeName;
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, timeName));
        v.addAttribute(new Attribute("standard_name", "forecast_reference_time"));
        v.addAttribute(new Attribute("long_name", "GRIB reference time"));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        v.addAttribute(new Attribute("units", units));
        v.setSPobject(new Time2Dinfo(Time2DinfoType.timeAuxRef, null, time));
    }

    private void makeTimeCoordinate1D(NetcdfFile ncfile, Group g, CoordinateTimeIntv coordTime) {
        int ntimes = coordTime.getSize();
        String tcName = coordTime.getName();
        String dims = coordTime.getName();
        ncfile.addDimension(g, new Dimension(tcName, ntimes));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, tcName, DataType.DOUBLE, dims));
        String units = coordTime.getUnit() + " since " + coordTime.getRefDate();
        v.addAttribute(new Attribute("units", units));
        v.addAttribute(new Attribute("standard_name", "time"));
        v.addAttribute(new Attribute("long_name", GRIB_VALID_TIME));
        v.addAttribute(new Attribute("calendar", Calendar.proleptic_gregorian.toString()));
        double[] data = new double[ntimes];
        int count = 0;
        for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds2();
        }
        v.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes}, (Object)data));
        String bounds_name = tcName + "_bounds";
        Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, bounds_name, DataType.DOUBLE, dims + " 2"));
        v.addAttribute(new Attribute("bounds", bounds_name));
        bounds.addAttribute(new Attribute("units", units));
        bounds.addAttribute(new Attribute("long_name", "bounds for " + tcName));
        data = new double[ntimes * 2];
        count = 0;
        for (TimeCoord.Tinv tinv : coordTime.getTimeIntervals()) {
            data[count++] = tinv.getBounds1();
            data[count++] = tinv.getBounds2();
        }
        bounds.setCachedData(Array.factory(DataType.DOUBLE, new int[]{ntimes, 2}, (Object)data));
        this.makeTimeAuxReference(ncfile, g, tcName, units, coordTime);
    }

    private void makeVerticalCoordinate(NetcdfFile ncfile, Group g, CoordinateVert vc) {
        int n = vc.getSize();
        String vcName = vc.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(vcName, n));
        Variable v = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName, DataType.FLOAT, vcName));
        if (vc.getUnit() != null) {
            v.addAttribute(new Attribute("units", vc.getUnit()));
            String desc = this.getVerticalCoordDesc(vc.getCode());
            if (desc != null) {
                v.addAttribute(new Attribute("long_name", desc));
            }
            v.addAttribute(new Attribute("positive", vc.isPositiveUp() ? "up" : "down"));
        }
        v.addAttribute(new Attribute("Grib_level_type", vc.getCode()));
        VertCoord.VertUnit vu = vc.getVertUnit();
        if (vu != null && vu.getDatum() != null) {
            v.addAttribute(new Attribute("datum", vu.getDatum()));
        }
        if (vc.isLayer()) {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getLevelSorted()) {
                data[count++] = (float)(val.getValue1() + val.getValue2()) / 2.0f;
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
            Variable bounds = ncfile.addVariable(g, new Variable(ncfile, g, null, vcName + "_bounds", DataType.FLOAT, vcName + " 2"));
            v.addAttribute(new Attribute("bounds", vcName + "_bounds"));
            String vcUnit = vc.getUnit();
            if (vcUnit != null) {
                bounds.addAttribute(new Attribute("units", vcUnit));
            }
            bounds.addAttribute(new Attribute("long_name", "bounds for " + vcName));
            data = new float[2 * n];
            count = 0;
            for (VertCoord.Level level : vc.getLevelSorted()) {
                data[count++] = (float)level.getValue1();
                data[count++] = (float)level.getValue2();
            }
            bounds.setCachedData(Array.factory(DataType.FLOAT, new int[]{n, 2}, (Object)data));
        } else {
            float[] data = new float[n];
            int count = 0;
            for (VertCoord.Level val : vc.getLevelSorted()) {
                data[count++] = (float)val.getValue1();
            }
            v.setCachedData(Array.factory(DataType.FLOAT, new int[]{n}, (Object)data));
        }
    }

    private void makeEnsembleCoordinate(NetcdfFile ncfile, Group g, CoordinateEns ec) {
        int n = ec.getSize();
        String ecName = ec.getName().toLowerCase();
        ncfile.addDimension(g, new Dimension(ecName, n));
        Variable v = new Variable(ncfile, g, null, ecName, DataType.INT, ecName);
        ncfile.addVariable(g, v);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Ensemble.toString()));
        int[] data = new int[n];
        int count = 0;
        for (EnsCoord.Coord ecc : ec.getEnsSorted()) {
            data[count++] = ecc.getEnsMember();
        }
        v.setCachedData(Array.factory(DataType.INT, new int[]{n}, (Object)data));
    }

    private String searchCoord(Grib2Utils.LatLonCoordType type, List<GribCollectionImmutable.VariableIndex> list) {
        if (type == null) {
            return null;
        }
        switch (type) {
            case U: {
                GribCollectionImmutable.VariableIndex lat = this.searchCoord(list, 198);
                GribCollectionImmutable.VariableIndex lon = this.searchCoord(list, 199);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case V: {
                GribCollectionImmutable.VariableIndex lat = this.searchCoord(list, 200);
                GribCollectionImmutable.VariableIndex lon = this.searchCoord(list, 201);
                return lat != null && lon != null ? this.makeVariableName(lat) + " " + this.makeVariableName(lon) : null;
            }
            case P: {
                GribCollectionImmutable.VariableIndex lat = this.searchCoord(list, 202);
                GribCollectionImmutable.VariableIndex lon = this.searchCoord(list, 203);
                return lat != null && lon != null ? this.makeVariableName(lat) + "  " + this.makeVariableName(lon) : null;
            }
        }
        return null;
    }

    private GribCollectionImmutable.VariableIndex searchCoord(List<GribCollectionImmutable.VariableIndex> list, int p) {
        for (GribCollectionImmutable.VariableIndex vindex : list) {
            if (vindex.getDiscipline() != 0 || vindex.getCategory() != 2 || vindex.getParameter() != p) continue;
            return vindex;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        if (!this.owned && this.gribCollection != null) {
            this.gribCollection.close();
        }
        this.gribCollection = null;
        super.close();
    }

    @Override
    public String getDetailInfo() {
        Formatter f = new Formatter();
        f.format("%s", super.getDetailInfo());
        if (this.gribCollection != null) {
            this.gribCollection.showIndex(f);
        }
        return f.toString();
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        if (v2.getSPobject() instanceof Time2Dinfo) {
            Time2Dinfo info = (Time2Dinfo)v2.getSPobject();
            Array data = this.makeLazyCoordinateData(v2, info);
            assert (data != null);
            Section sectionFilled = Section.fill(section, v2.getShape());
            return data.sectionNoReduce(sectionFilled.getRanges());
        }
        try {
            Array result = this.isPartitioned ? this.readDataFromPartition(v2, section, null) : this.readDataFromCollection(v2, section, null);
            long took = System.currentTimeMillis() - start;
            return result;
        }
        catch (IOException ioe) {
            this.logger.error("Failed to readData ", ioe);
            throw ioe;
        }
    }

    @Override
    public long streamToByteChannel(Variable v2, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        long start = System.currentTimeMillis();
        this.readDataFromCollection(v2, section, channel);
        long took = System.currentTimeMillis() - start;
        return 0L;
    }

    private Array readDataFromCollection(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        GribCollectionImmutable.VariableIndex vindex = (GribCollectionImmutable.VariableIndex)v.getSPobject();
        vindex.readRecords();
        int sectionLen = section.getRank();
        Range yRange = section.getRange(sectionLen - 2);
        Range xRange = section.getRange(sectionLen - 1);
        Section sectionWanted = section.subSection(0, sectionLen - 2);
        Section.Iterator iterWanted = sectionWanted.getIterator(v.getShape());
        int[] indexWanted = new int[sectionLen - 2];
        DataReader dataReader = new DataReader(vindex);
        int count = 0;
        while (iterWanted.hasNext()) {
            int sourceIndex = iterWanted.next(indexWanted);
            dataReader.addRecord(sourceIndex, count++);
        }
        DataReceiverIF dataReceiver = channel == null ? new DataReceiver(section, yRange, xRange) : new ChannelReceiver(channel, yRange, xRange);
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private Array readDataFromPartition(Variable v, Section section, WritableByteChannel channel) throws IOException, InvalidRangeException {
        int[] indexWanted;
        PartitionCollectionImmutable.VariableIndexPartitioned vindexP = (PartitionCollectionImmutable.VariableIndexPartitioned)v.getSPobject();
        int sectionLen = section.getRank();
        Range yRange = section.getRange(sectionLen - 2);
        Range xRange = section.getRange(sectionLen - 1);
        Section sectionWanted = section.subSection(0, sectionLen - 2);
        Section.Iterator iterWanted = sectionWanted.getIterator(v.getShape());
        int[] useIndex = indexWanted = new int[sectionLen - 2];
        DataReaderPartitioned dataReader = new DataReaderPartitioned();
        int resultPos = 0;
        while (iterWanted.hasNext()) {
            PartitionCollectionImmutable.DataRecord record;
            iterWanted.next(indexWanted);
            if (vindexP.getType() == GribCollectionImmutable.Type.TP) {
                int[] indexReallyWanted = new int[indexWanted.length + 1];
                indexReallyWanted[0] = indexWanted[0];
                indexReallyWanted[1] = 0;
                System.arraycopy(indexWanted, 1, indexReallyWanted, 2, indexWanted.length - 1);
                useIndex = indexReallyWanted;
            }
            if ((record = vindexP.getDataRecord(useIndex)) == null) {
                if (debugRead) {
                    System.out.printf("readDataFromPartition missing data%n", new Object[0]);
                }
                ++resultPos;
                continue;
            }
            record.resultIndex = resultPos++;
            dataReader.addRecord(record);
        }
        DataReceiverIF dataReceiver = channel == null ? new DataReceiver(section, yRange, xRange) : new ChannelReceiver(channel, yRange, xRange);
        dataReader.read(dataReceiver);
        return dataReceiver.getArray();
    }

    public abstract Object getLastRecordRead();

    public abstract void clearLastRecordRead();

    public abstract Object getGribCustomizer();

    private class DataReaderPartitioned {
        List<PartitionCollectionImmutable.DataRecord> records = new ArrayList<PartitionCollectionImmutable.DataRecord>();

        private DataReaderPartitioned() {
        }

        void addRecord(PartitionCollectionImmutable.DataRecord dr) {
            if (dr != null) {
                this.records.add(dr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(DataReceiverIF dataReceiver) throws IOException {
            Collections.sort(this.records);
            PartitionCollectionImmutable.DataRecord lastRecord = null;
            try (RandomAccessFile rafData = null;){
                for (PartitionCollectionImmutable.DataRecord dr : this.records) {
                    if (debugIndexOnly || debugGbxIndexOnly) {
                        ++debugIndexOnlyCount;
                        if (debugIndexOnlyShow) {
                            dr.show();
                        }
                        dataReceiver.setDataToZero();
                        continue;
                    }
                    if (rafData == null || !dr.usesSameFile(lastRecord)) {
                        if (rafData != null) {
                            rafData.close();
                        }
                        rafData = dr.usePartition.getRaf(dr.partno, dr.fileno);
                    }
                    lastRecord = dr;
                    if (dr.dataPos == -1L) continue;
                    if (debugRead) {
                        GribIosp.this.show(rafData, dr.dataPos);
                    }
                    float[] data = GribIosp.this.readData(rafData, dr);
                    GdsHorizCoordSys hcs = dr.hcs;
                    dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                }
            }
        }
    }

    private static class ChannelReceiver
    implements DataReceiverIF {
        private WritableByteChannel channel;
        private DataOutputStream outStream;
        private Range yRange;
        private Range xRange;

        ChannelReceiver(WritableByteChannel channel, Range yRange, Range xRange) {
            this.channel = channel;
            this.outStream = new DataOutputStream(Channels.newOutputStream(channel));
            this.yRange = yRange;
            this.xRange = xRange;
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.outStream.writeFloat(data[dataIdx]);
                }
            }
        }

        @Override
        public void setDataToZero() {
        }

        @Override
        public Array getArray() {
            return null;
        }
    }

    private static class DataReceiver
    implements DataReceiverIF {
        private Array dataArray;
        private Range yRange;
        private Range xRange;
        private int horizSize;

        DataReceiver(Section section, Range yRange, Range xRange) {
            int len = (int)section.computeSize();
            float[] data = new float[len];
            for (int i = 0; i < len; ++i) {
                data[i] = Float.NaN;
            }
            this.dataArray = Array.factory(DataType.FLOAT, section.getShape(), (Object)data);
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            for (int y = this.yRange.first(); y <= this.yRange.last(); y += this.yRange.stride()) {
                for (int x = this.xRange.first(); x <= this.xRange.last(); x += this.xRange.stride()) {
                    int dataIdx = y * nx + x;
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        @Override
        public void setDataToZero() {
            float[] data = (float[])this.dataArray.get1DJavaArray(this.dataArray.getElementType());
            for (int i = 0; i < data.length; ++i) {
                data[i] = 0.0f;
            }
        }

        @Override
        public Array getArray() {
            return this.dataArray;
        }
    }

    private static interface DataReceiverIF {
        public void addData(float[] var1, int var2, int var3) throws IOException;

        public void setDataToZero();

        public Array getArray();
    }

    protected class DataReader {
        GribCollectionImmutable.VariableIndex vindex;
        List<DataRecord> records = new ArrayList<DataRecord>();

        private DataReader(GribCollectionImmutable.VariableIndex vindex) {
            this.vindex = vindex;
        }

        void addRecord(int sourceIndex, int resultIndex) {
            GribCollectionImmutable.Record record = this.vindex.getRecordAt(sourceIndex);
            if (debugRead) {
                System.out.printf("GribIosp debugRead sourceIndex=%d resultIndex=%d record is null=%s%n", sourceIndex, resultIndex, record == null);
            }
            if (record != null) {
                this.records.add(new DataRecord(resultIndex, record.fileno, record.pos, record.bmsPos, record.scanMode, this.vindex.group.getGdsHorizCoordSys()));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void read(DataReceiverIF dataReceiver) throws IOException {
            Collections.sort(this.records);
            int currFile = -1;
            try (RandomAccessFile rafData = null;){
                for (DataRecord dr : this.records) {
                    if (debugIndexOnly || debugGbxIndexOnly) {
                        ++debugIndexOnlyCount;
                        dataReceiver.setDataToZero();
                        continue;
                    }
                    if (dr.fileno != currFile) {
                        if (rafData != null) {
                            rafData.close();
                        }
                        rafData = GribIosp.this.gribCollection.getDataRaf(dr.fileno);
                        currFile = dr.fileno;
                    }
                    if (dr.dataPos == -1L) continue;
                    if (debugRead && rafData != null) {
                        GribIosp.this.show(rafData, dr.dataPos);
                    }
                    float[] data = GribIosp.this.readData(rafData, dr);
                    GdsHorizCoordSys hcs = this.vindex.group.getGdsHorizCoordSys();
                    dataReceiver.addData(data, dr.resultIndex, hcs.nx);
                }
            }
        }
    }

    static class DataRecord
    implements Comparable<DataRecord> {
        int resultIndex;
        int fileno;
        long dataPos;
        long bmsPos;
        int scanMode;
        GdsHorizCoordSys hcs;

        DataRecord(int resultIndex, int fileno, long dataPos, long bmsPos, int scanMode, GdsHorizCoordSys hcs) {
            this.resultIndex = resultIndex;
            this.fileno = fileno;
            this.dataPos = dataPos;
            this.bmsPos = bmsPos;
            this.scanMode = scanMode;
            this.hcs = hcs;
        }

        @Override
        public int compareTo(DataRecord o) {
            int r = Misc.compare(this.fileno, o.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare(this.dataPos, o.dataPos);
        }

        public void show(GribCollectionImmutable gribCollection) throws IOException {
            String dataFilename = gribCollection.getFilename(this.fileno);
            System.out.printf(" fileno=%d filename=%s datapos=%d%n", this.fileno, dataFilename, this.dataPos);
        }
    }

    private static class Time2Dinfo {
        Time2DinfoType which;
        CoordinateTime2D time2D;
        Coordinate time1D;

        private Time2Dinfo(Time2DinfoType which, CoordinateTime2D time2D, Coordinate time1D) {
            this.which = which;
            this.time2D = time2D;
            this.time1D = time1D;
        }
    }

    private static enum Time2DinfoType {
        off,
        intv,
        bounds,
        is1Dtime,
        reftime,
        timeAuxRef;

    }
}

