/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.writer.DataFactory;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.FileWriter2;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordSysBuilderIF;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.SequenceDS;
import ucar.nc2.dataset.StructureDS;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.ncml.Aggregation;
import ucar.nc2.ncml.NcMLGWriter;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CancelTaskImpl;
import ucar.nc2.util.EscapeStrings;
import ucar.nc2.util.Misc;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileFactory;
import ucar.unidata.util.StringUtil2;
import ucar.unidata.util.Urlencoded;

public class NetcdfDataset
extends NetcdfFile {
    static final String DAP4_PATH = "dap4.cdm";
    private static Set<Enhance> EnhanceAll = Collections.unmodifiableSet(EnumSet.of(Enhance.ScaleMissing, Enhance.CoordSystems, Enhance.ConvertEnums));
    private static Set<Enhance> EnhanceNone = Collections.unmodifiableSet(EnumSet.noneOf(Enhance.class));
    private static Set<Enhance> defaultEnhanceMode = EnhanceAll;
    private static Logger log = LoggerFactory.getLogger(NetcdfDataset.class);
    protected static boolean useNaNs = true;
    protected static boolean fillValueIsMissing = true;
    protected static boolean invalidDataIsMissing = true;
    protected static boolean missingDataIsMissing = true;
    private static FileCache fileCache = null;
    private static FileFactory defaultNetcdfFileFactory = null;
    private NetcdfFile orgFile = null;
    private List<CoordinateSystem> coordSys = new ArrayList<CoordinateSystem>();
    private List<CoordinateAxis> coordAxes = new ArrayList<CoordinateAxis>();
    private List<CoordinateTransform> coordTransforms = new ArrayList<CoordinateTransform>();
    private String convUsed;
    private EnumSet<Enhance> enhanceMode = EnumSet.noneOf(Enhance.class);
    private Aggregation agg = null;

    public static Set<Enhance> getEnhanceAll() {
        return EnhanceAll;
    }

    public static Set<Enhance> getEnhanceNone() {
        return EnhanceNone;
    }

    public static Set<Enhance> getEnhanceDefault() {
        return defaultEnhanceMode;
    }

    public static Set<Enhance> getDefaultEnhanceMode() {
        return defaultEnhanceMode;
    }

    public static void setDefaultEnhanceMode(Set<Enhance> mode) {
        defaultEnhanceMode = Collections.unmodifiableSet(mode);
    }

    public static Set<Enhance> parseEnhanceMode(String enhanceMode) {
        if (enhanceMode == null) {
            return null;
        }
        Set<Enhance> mode = null;
        if (enhanceMode.equalsIgnoreCase("true") || enhanceMode.equalsIgnoreCase("All")) {
            mode = NetcdfDataset.getEnhanceAll();
        } else if (enhanceMode.equalsIgnoreCase("AllDefer")) {
            mode = EnumSet.of(Enhance.ScaleMissingDefer, Enhance.CoordSystems, Enhance.ConvertEnums);
        } else if (enhanceMode.equalsIgnoreCase("ScaleMissing")) {
            mode = EnumSet.of(Enhance.ScaleMissing);
        } else if (enhanceMode.equalsIgnoreCase("ScaleMissingDefer")) {
            mode = EnumSet.of(Enhance.ScaleMissingDefer);
        } else if (enhanceMode.equalsIgnoreCase("CoordSystems")) {
            mode = EnumSet.of(Enhance.CoordSystems);
        } else if (enhanceMode.equalsIgnoreCase("ConvertEnums")) {
            mode = EnumSet.of(Enhance.ConvertEnums);
        }
        return mode;
    }

    public static void setUseNaNs(boolean b) {
        useNaNs = b;
    }

    public static boolean getUseNaNs() {
        return useNaNs;
    }

    public static void setFillValueIsMissing(boolean b) {
        fillValueIsMissing = b;
    }

    public static boolean getFillValueIsMissing() {
        return fillValueIsMissing;
    }

    public static void setInvalidDataIsMissing(boolean b) {
        invalidDataIsMissing = b;
    }

    public static boolean getInvalidDataIsMissing() {
        return invalidDataIsMissing;
    }

    public static void setMissingDataIsMissing(boolean b) {
        missingDataIsMissing = b;
    }

    public static boolean getMissingDataIsMissing() {
        return missingDataIsMissing;
    }

    public static void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        fileCache = new FileCache("NetcdfFileCache ", minElementsInMemory, maxElementsInMemory, -1, period);
        defaultNetcdfFileFactory = new MyNetcdfFileFactory();
    }

    public static void initNetcdfFileCache(int minElementsInMemory, int maxElementsInMemory, int hardLimit, int period) {
        fileCache = new FileCache("NetcdfFileCache ", minElementsInMemory, maxElementsInMemory, hardLimit, period);
        defaultNetcdfFileFactory = new MyNetcdfFileFactory();
    }

    public static void disableNetcdfFileCache() {
        if (null != fileCache) {
            fileCache.disable();
        }
        fileCache = null;
    }

    public static void shutdown() {
        if (fileCache != null) {
            fileCache.clearCache(true);
        }
        FileCache.shutdown();
    }

    public static FileCacheIF getNetcdfFileCache() {
        return fileCache;
    }

    public static NetcdfDataset wrap(NetcdfFile ncfile, Set<Enhance> mode) throws IOException {
        NetcdfDataset ncd;
        if (ncfile instanceof NetcdfDataset && !(ncd = (NetcdfDataset)ncfile).enhanceNeeded(mode)) {
            return (NetcdfDataset)ncfile;
        }
        return new NetcdfDataset(ncfile, mode);
    }

    public static NetcdfDataset openDataset(String location) throws IOException {
        return NetcdfDataset.openDataset(location, true, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openDataset(location, enhance, -1, cancelTask, null);
    }

    public static NetcdfDataset openDataset(String location, boolean enhance, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openDataset(location, enhance ? defaultEnhanceMode : null, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfDataset openDataset(String location, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        NetcdfDataset ds;
        NetcdfFile ncfile = NetcdfDataset.openOrAcquireFile(null, null, null, location, buffer_size, cancelTask, spiObject);
        if (ncfile instanceof NetcdfDataset) {
            ds = (NetcdfDataset)ncfile;
            NetcdfDataset.enhance(ds, enhanceMode, cancelTask);
        } else {
            ds = new NetcdfDataset(ncfile, enhanceMode);
        }
        return ds;
    }

    private static CoordSysBuilderIF enhance(NetcdfDataset ds, Set<Enhance> mode, CancelTask cancelTask) throws IOException {
        if (mode == null) {
            return null;
        }
        CoordSysBuilderIF builder = null;
        if (mode.contains((Object)Enhance.CoordSystems) && !ds.enhanceMode.contains((Object)Enhance.CoordSystems)) {
            builder = CoordSysBuilder.factory(ds, cancelTask);
            builder.augmentDataset(ds, cancelTask);
            ds.convUsed = builder.getConventionUsed();
        }
        if (mode.contains((Object)Enhance.ConvertEnums) && !ds.enhanceMode.contains((Object)Enhance.ConvertEnums) || mode.contains((Object)Enhance.ScaleMissing) && !ds.enhanceMode.contains((Object)Enhance.ScaleMissing) || mode.contains((Object)Enhance.ScaleMissingDefer) && !ds.enhanceMode.contains((Object)Enhance.ScaleMissingDefer)) {
            for (Variable v : ds.getVariables()) {
                VariableEnhanced ve = (VariableEnhanced)((Object)v);
                ve.enhance(mode);
                if (cancelTask == null || !cancelTask.isCancel()) continue;
                return null;
            }
        }
        if (builder != null) {
            builder.buildCoordinateSystems(ds);
        }
        ds.finish();
        ds.enhanceMode.addAll(mode);
        return builder;
    }

    public static NetcdfDataset acquireDataset(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, defaultEnhanceMode, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(String location, boolean enhance, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireDataset(null, location, enhance ? defaultEnhanceMode : null, -1, cancelTask, null);
    }

    public static NetcdfDataset acquireDataset(FileFactory fac, String location, Set<Enhance> enhanceMode, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
        if (fileCache == null) {
            if (fac == null) {
                return NetcdfDataset.openDataset(location, enhanceMode, buffer_size, cancelTask, iospMessage);
            }
            return (NetcdfDataset)fac.open(location, buffer_size, cancelTask, iospMessage);
        }
        if (fac != null) {
            return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(fileCache, fac, null, location, buffer_size, cancelTask, iospMessage);
        }
        fac = new MyNetcdfDatasetFactory(location, enhanceMode);
        return (NetcdfDataset)NetcdfDataset.openOrAcquireFile(fileCache, fac, fac.hashCode(), location, buffer_size, cancelTask, iospMessage);
    }

    public static NetcdfFile openFile(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.openOrAcquireFile(null, null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile openFile(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        return NetcdfDataset.openOrAcquireFile(null, null, null, location, buffer_size, cancelTask, spiObject);
    }

    public static NetcdfFile acquireFile(String location, CancelTask cancelTask) throws IOException {
        return NetcdfDataset.acquireFile(null, null, location, -1, cancelTask, null);
    }

    public static NetcdfFile acquireFile(FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (fileCache == null && factory != null) {
            return (NetcdfFile)factory.open(location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfDataset.openOrAcquireFile(fileCache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openOrAcquireFile(FileCache cache, FileFactory factory, Object hashKey, String orgLocation, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (orgLocation == null) {
            throw new IOException("NetcdfDataset.openFile: location is null");
        }
        String location = StringUtil2.replace(orgLocation.trim(), '\\', "/");
        List<String> allprotocols = Misc.getProtocols(location);
        String trueurl = location;
        String leadprotocol = allprotocols.size() == 0 ? "file" : allprotocols.get(0);
        String fragment = null;
        int pos = trueurl.lastIndexOf(35);
        if (pos >= 0) {
            fragment = trueurl.substring(pos + 1, trueurl.length());
            trueurl = trueurl.substring(0, pos);
        }
        if ((pos = location.lastIndexOf(63)) >= 0) {
            trueurl = trueurl.substring(0, pos);
        }
        ServiceType svctype = null;
        if (fragment != null) {
            svctype = NetcdfDataset.searchFragment(fragment);
        }
        if (svctype == null) {
            svctype = NetcdfDataset.decodeLeadProtocol(leadprotocol);
        }
        if (svctype == null) {
            if (leadprotocol.equals("file")) {
                svctype = NetcdfDataset.decodePathExtension(trueurl);
            } else {
                svctype = NetcdfDataset.disambiguateHttp(trueurl);
                if ((svctype == null || svctype == ServiceType.HTTPServer) && NetcdfDataset.checkIfRemoteNcml(trueurl)) {
                    svctype = ServiceType.NCML;
                }
            }
        }
        if (svctype == ServiceType.OPENDAP) {
            return NetcdfDataset.acquireDODS(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (svctype == ServiceType.CdmRemote) {
            return NetcdfDataset.acquireRemote(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (svctype == ServiceType.DAP4) {
            return NetcdfDataset.acquireDap4(cache, factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        if (svctype == ServiceType.NCML) {
            String url = allprotocols.size() == 0 ? "file:" + trueurl : location;
            return NetcdfDataset.acquireNcml(cache, factory, hashKey, url, buffer_size, cancelTask, spiObject);
        }
        if (svctype == ServiceType.THREDDS) {
            DataFactory tdf = new DataFactory();
            Formatter log = new Formatter();
            NetcdfDataset ncfile = tdf.openDataset(location, false, cancelTask, log);
            if (ncfile == null) {
                throw new IOException(log.toString());
            }
            return ncfile;
        }
        if (svctype != ServiceType.HTTPServer && svctype != null) {
            throw new IOException("Unknown service type: " + svctype.toString());
        }
        if (cache != null) {
            if (factory == null) {
                factory = defaultNetcdfFileFactory;
            }
            return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
        }
        return NetcdfFile.open(location, buffer_size, cancelTask, spiObject);
    }

    static ServiceType decodePathExtension(String path) {
        if (path.endsWith(".dds") || path.endsWith(".das") || path.endsWith(".dods")) {
            return ServiceType.OPENDAP;
        }
        if (path.endsWith(".dmr") || path.endsWith(".dap") || path.endsWith(".dsr")) {
            return ServiceType.DAP4;
        }
        if (path.endsWith(".xml") || path.endsWith(".ncml")) {
            return ServiceType.NCML;
        }
        return null;
    }

    @Urlencoded
    static ServiceType decodeLeadProtocol(String protocol) throws IOException {
        if (protocol.equals("dods")) {
            return ServiceType.OPENDAP;
        }
        if (protocol.equals("dap4")) {
            return ServiceType.DAP4;
        }
        if (protocol.equals("httpserver") || protocol.equals("nodods")) {
            return ServiceType.HTTPServer;
        }
        if (protocol.equals("cdmremote")) {
            return ServiceType.CdmRemote;
        }
        if (protocol.equals("thredds")) {
            return ServiceType.THREDDS;
        }
        return null;
    }

    @Urlencoded
    private static ServiceType disambiguateHttp(String location) throws IOException {
        ServiceType result = NetcdfDataset.checkIfDods(location);
        if (result != null) {
            return result;
        }
        result = NetcdfDataset.checkIfDap4(location);
        if (result != null) {
            return result;
        }
        try (HTTPMethod method = HTTPFactory.Head(location);){
            String v;
            int statusCode = method.execute();
            if (statusCode >= 300) {
                if (statusCode == 401) {
                    throw new IOException("Unauthorized to open dataset " + location);
                }
                throw new IOException(location + " is not a valid URL, return status=" + statusCode);
            }
            Header h = method.getResponseHeader("Content-Description");
            if (h != null && h.getValue() != null && (v = h.getValue()).equalsIgnoreCase("ncstream")) {
                ServiceType serviceType = ServiceType.CdmRemote;
                return serviceType;
            }
            ServiceType serviceType = null;
            return serviceType;
        }
    }

    private static boolean checkIfRemoteNcml(String location) throws IOException {
        boolean isRemoteNcml = false;
        if (NetcdfDataset.decodePathExtension(location) == ServiceType.NCML) {
            try (HTTPMethod method = HTTPFactory.Get(location);){
                method.setRange(0L, 128L);
                method.setRequestHeader("accept-encoding", "identity");
                int statusCode = method.execute();
                if (statusCode >= 300) {
                    if (statusCode == 401) {
                        throw new IOException("Unauthorized to open dataset " + location);
                    }
                    if (statusCode == 406) {
                        String msg = location + " - this server does not support returning content without any encoding.";
                        msg = msg + " Please download the file locally. Return status=" + statusCode;
                        throw new IOException(msg);
                    }
                    throw new IOException(location + " is not a valid URL, return status=" + statusCode);
                }
                String strResponse = method.getResponseAsString();
                if (strResponse.contains("<netcdf ") && strResponse.contains("unidata.ucar.edu/namespaces/netcdf/ncml")) {
                    isRemoteNcml = true;
                }
            }
        }
        return isRemoteNcml;
    }

    private static ServiceType checkIfDods(String location) throws IOException {
        int len = location.length();
        if (location.endsWith(".dds")) {
            location = location.substring(0, len - ".dds".length());
        }
        if (location.endsWith(".das")) {
            location = location.substring(0, len - ".das".length());
        }
        if (location.endsWith(".dods")) {
            location = location.substring(0, len - ".dods".length());
        }
        try (HTTPMethod method = HTTPFactory.Get(location + ".dds");){
            Header h;
            int status = method.execute();
            if (status == 200 && (h = method.getResponseHeader("Content-Description")) != null && h.getValue() != null) {
                String v = h.getValue();
                if (v.equalsIgnoreCase("dods-dds") || v.equalsIgnoreCase("dods_dds")) {
                    ServiceType serviceType = ServiceType.OPENDAP;
                    return serviceType;
                }
                throw new IOException("OPeNDAP Server Error= " + method.getResponseAsString());
            }
            if (status == 401) {
                throw new IOException("Unauthorized to open dataset " + location);
            }
            ServiceType serviceType = null;
            return serviceType;
        }
    }

    private static ServiceType checkIfDap4(String location) throws IOException {
        if (location.endsWith(".dap")) {
            location = location.substring(0, location.length() - ".dap".length());
        } else if (location.endsWith(".dmr")) {
            location = location.substring(0, location.length() - ".dmr".length());
        } else if (location.endsWith(".dsr")) {
            location = location.substring(0, location.length() - ".dsr".length());
        }
        try (HTTPMethod method = HTTPFactory.Get(location + ".dmr");){
            String v;
            Header h;
            int status = method.execute();
            if (status == 200 && (h = method.getResponseHeader("Content-Type")) != null && h.getValue() != null && (v = h.getValue()).startsWith("application/vnd.opendap.org")) {
                ServiceType serviceType = ServiceType.DAP4;
                return serviceType;
            }
            if (status == 401) {
                throw new IOException("Unauthorized to open dataset " + location);
            }
            ServiceType serviceType = null;
            return serviceType;
        }
    }

    static ServiceType searchFragment(String fragment) {
        if (fragment.length() == 0) {
            return null;
        }
        Map<String, String> map = NetcdfDataset.parseFragment(fragment);
        if (map == null) {
            return null;
        }
        String protocol = map.get("protocol");
        if (protocol != null) {
            if (protocol.equalsIgnoreCase("dap") || protocol.equalsIgnoreCase("dods")) {
                return ServiceType.OPENDAP;
            }
            if (protocol.equalsIgnoreCase("dap4")) {
                return ServiceType.DAP4;
            }
            if (protocol.equalsIgnoreCase("cdmremote")) {
                return ServiceType.CdmRemote;
            }
            if (protocol.equalsIgnoreCase("thredds")) {
                return ServiceType.THREDDS;
            }
            if (protocol.equalsIgnoreCase("ncmdl")) {
                return ServiceType.NCML;
            }
        }
        return null;
    }

    static Map<String, String> parseFragment(String fragment) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (fragment != null && fragment.length() >= 0) {
            String[] pairs;
            if (fragment.charAt(0) == '#') {
                fragment = fragment.substring(1);
            }
            block4: for (String pair : pairs = fragment.split("[ \t]*[&][ \t]*")) {
                String[] pieces = pair.split("[ \t]*[=][ \t]*");
                switch (pieces.length) {
                    case 1: {
                        map.put(EscapeStrings.unescapeURL(pieces[0]).toLowerCase(), "true");
                        continue block4;
                    }
                    case 2: {
                        map.put(EscapeStrings.unescapeURL(pieces[0]).toLowerCase(), EscapeStrings.unescapeURL(pieces[1]).toLowerCase());
                        continue block4;
                    }
                    default: {
                        return null;
                    }
                }
            }
        }
        return map;
    }

    private static NetcdfFile acquireDODS(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return NetcdfDataset.openDodsByReflection(location, cancelTask);
        }
        if (factory == null) {
            factory = new DodsFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile acquireDap4(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return NetcdfDataset.openDap4ByReflection(location, cancelTask);
        }
        if (factory == null) {
            factory = new Dap4Factory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile openDodsByReflection(String location, CancelTask cancelTask) throws IOException {
        Constructor<?> con;
        try {
            Class<?> c = NetcdfDataset.class.getClassLoader().loadClass("ucar.nc2.dods.DODSNetcdfFile");
            con = c.getConstructor(String.class, CancelTask.class);
        }
        catch (ClassNotFoundException e) {
            log.info("opendap.jar is not on class path or is incorrect version");
            throw new IOException("opendap.jar is not on classpath or is incorrect version");
        }
        catch (Throwable e) {
            log.error("Error openDodsByReflection: ", e);
            throw new IOException("opendap.jar is not on classpath or is incorrect version");
        }
        try {
            NetcdfFile file = (NetcdfFile)con.newInstance(location, cancelTask);
            return file;
        }
        catch (Exception e) {
            log.error("Error openDodsByReflection: ", e.getCause());
            throw new IOException(e.getCause());
        }
    }

    private static NetcdfFile openDap4ByReflection(String location, CancelTask cancelTask) throws IOException {
        String target = "dap4.cdm.DapNetcdfFile";
        try {
            Class<?> dap4class = NetcdfDataset.class.getClassLoader().loadClass(target);
            Constructor<?> constructormethod = dap4class.getConstructor(String.class, CancelTask.class);
            NetcdfFile file = (NetcdfFile)constructormethod.newInstance(location, cancelTask);
            return file;
        }
        catch (ClassNotFoundException e) {
            String msg = "DapNetcdfFile is not on class path or is incorrect version: " + target;
            log.error(msg);
            throw new IOException(msg);
        }
        catch (NoSuchMethodException e) {
            String msg = "DapNetcdfFile constructor not found";
            log.error(msg);
            throw new IOException(msg);
        }
        catch (InstantiationException e) {
            String msg = "DapNetcdfFileFactory constructor cannot be invoked";
            log.error(msg);
            throw new IOException(msg);
        }
        catch (IllegalAccessException iace) {
            String msg = "DapNetcdfFile constructor cannot be invoked";
            log.error(msg);
            throw new IOException(msg, iace);
        }
        catch (IllegalArgumentException iare) {
            String msg = "DapNetcdfFile constructor: illegal argument";
            log.error(msg);
            throw new IOException(msg, iare);
        }
        catch (InvocationTargetException ite) {
            String msg = "DapNetcdfFile constructor failed: " + ite.getCause().getMessage();
            log.error(msg);
            throw new IOException(msg, ite);
        }
    }

    private static NetcdfFile acquireNcml(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return NcMLReader.readNcML(location, cancelTask);
        }
        if (factory == null) {
            factory = new NcMLFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    private static NetcdfFile acquireRemote(FileCache cache, FileFactory factory, Object hashKey, String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
        if (cache == null) {
            return new CdmRemote(location);
        }
        if (factory == null) {
            factory = new RemoteFactory();
        }
        return (NetcdfFile)cache.acquire(factory, hashKey, location, buffer_size, cancelTask, spiObject);
    }

    public Aggregation getAggregation() {
        return this.agg;
    }

    public void setAggregation(Aggregation agg) {
        this.agg = agg;
    }

    public List<CoordinateSystem> getCoordinateSystems() {
        return this.coordSys;
    }

    public String getConventionUsed() {
        return this.convUsed;
    }

    public EnumSet<Enhance> getEnhanceMode() {
        return this.enhanceMode;
    }

    public List<CoordinateTransform> getCoordinateTransforms() {
        return this.coordTransforms;
    }

    public List<CoordinateAxis> getCoordinateAxes() {
        return this.coordAxes;
    }

    public void clearCoordinateSystems() {
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        for (Variable v : this.getVariables()) {
            VariableEnhanced ve = (VariableEnhanced)((Object)v);
            ve.clearCoordinateSystems();
        }
        this.enhanceMode.remove((Object)Enhance.CoordSystems);
    }

    public CoordinateAxis findCoordinateAxis(AxisType type) {
        if (type == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (type != v.getAxisType()) continue;
            return v;
        }
        return null;
    }

    public CoordinateAxis findCoordinateAxis(String fullName) {
        if (fullName == null) {
            return null;
        }
        for (CoordinateAxis v : this.coordAxes) {
            if (!fullName.equals(v.getFullName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateSystem findCoordinateSystem(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateSystem v : this.coordSys) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    public CoordinateTransform findCoordinateTransform(String name) {
        if (name == null) {
            return null;
        }
        for (CoordinateTransform v : this.coordTransforms) {
            if (!name.equals(v.getName())) continue;
            return v;
        }
        return null;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.agg != null) {
            this.agg.persistWrite();
            this.agg.close();
        }
        if (this.cache != null && this.cache.release(this)) {
            return;
        }
        if (this.orgFile != null) {
            this.orgFile.close();
        }
        this.orgFile = null;
    }

    @Override
    public void release() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.release();
        }
    }

    @Override
    public void reacquire() throws IOException {
        if (this.orgFile != null) {
            this.orgFile.reacquire();
        }
    }

    @Override
    public long getLastModified() {
        if (this.agg != null) {
            return this.agg.getLastModified();
        }
        return this.orgFile != null ? this.orgFile.getLastModified() : 0L;
    }

    @Override
    public void empty() {
        super.empty();
        this.coordSys = new ArrayList<CoordinateSystem>();
        this.coordAxes = new ArrayList<CoordinateAxis>();
        this.coordTransforms = new ArrayList<CoordinateTransform>();
        this.convUsed = null;
    }

    @Override
    public boolean syncExtend() throws IOException {
        boolean wasExtended;
        if (this.agg != null) {
            return this.agg.syncExtend();
        }
        if (this.orgFile != null && (wasExtended = this.orgFile.syncExtend())) {
            Dimension ndim = this.orgFile.getUnlimitedDimension();
            int newLength = ndim.getLength();
            Dimension udim = this.getUnlimitedDimension();
            udim.setLength(newLength);
            for (Variable v : this.getVariables()) {
                if (!v.isUnlimited()) continue;
                v.setDimensions(v.getDimensions());
            }
            return true;
        }
        return false;
    }

    @Override
    public void writeNcML(OutputStream os, String uri) throws IOException {
        new NcMLWriter().writeXML(this, os, uri);
    }

    public void writeNcMLG(OutputStream os, boolean showCoords, String uri) throws IOException {
        new NcMLGWriter().writeXML(this, os, showCoords, uri);
    }

    public NetcdfDataset(NetcdfFile ncfile) throws IOException {
        this(ncfile, defaultEnhanceMode);
    }

    public NetcdfDataset(NetcdfFile ncfile, boolean enhance) throws IOException {
        this(ncfile, enhance ? defaultEnhanceMode : null);
    }

    public NetcdfDataset(NetcdfFile ncfile, Set<Enhance> mode) throws IOException {
        super(ncfile);
        this.orgFile = ncfile;
        this.spi = null;
        this.convertGroup(this.getRootGroup(), ncfile.getRootGroup());
        this.finish();
        NetcdfDataset.enhance(this, mode, null);
    }

    private void convertGroup(Group g, Group from) {
        for (EnumTypedef et : from.getEnumTypedefs()) {
            g.addEnumeration(et);
        }
        for (Dimension d : from.getDimensions()) {
            g.addDimension(new Dimension(d.getShortName(), d));
        }
        for (Attribute a : from.getAttributes()) {
            g.addAttribute(a);
        }
        for (Variable v : from.getVariables()) {
            g.addVariable(this.convertVariable(g, v));
        }
        for (Group nested : from.getGroups()) {
            Group nnested = new Group(this, g, nested.getShortName());
            g.addGroup(nnested);
            this.convertGroup(nnested, nested);
        }
    }

    private Variable convertVariable(Group g, Variable v) {
        Variable newVar = v instanceof Sequence ? new SequenceDS(g, (Sequence)v) : (v instanceof Structure ? new StructureDS(g, (Structure)v) : new VariableDS(g, v, false));
        return newVar;
    }

    @Override
    protected Boolean makeRecordStructure() {
        if (this.orgFile == null) {
            return false;
        }
        Boolean hasRecord = (Boolean)this.orgFile.sendIospMessage("AddRecordStructure");
        if (hasRecord == null || !hasRecord.booleanValue()) {
            return false;
        }
        Variable orgV = this.orgFile.getRootGroup().findVariable("record");
        if (orgV == null || !(orgV instanceof Structure)) {
            return false;
        }
        Structure orgStructure = (Structure)orgV;
        Dimension udim = this.getUnlimitedDimension();
        if (udim == null) {
            return false;
        }
        Group root = this.getRootGroup();
        StructureDS newStructure = new StructureDS(this, root, null, "record", udim.getShortName(), null, null);
        newStructure.setOriginalVariable(orgStructure);
        for (Variable v : this.getVariables()) {
            VariableDS memberV;
            if (!v.isUnlimited()) continue;
            try {
                memberV = (VariableDS)v.slice(0, 0);
            }
            catch (InvalidRangeException e) {
                log.error("Cant slice variable " + v);
                return false;
            }
            memberV.setParentStructure(newStructure);
            newStructure.addMemberVariable(memberV);
        }
        root.addVariable(newStructure);
        this.finish();
        return true;
    }

    public void sort() {
        Collections.sort(this.variables, new VariableComparator());
        Collections.sort(this.coordAxes, new VariableComparator());
    }

    public NetcdfDataset() {
    }

    public NetcdfFile getReferencedFile() {
        return this.orgFile;
    }

    @Override
    public IOServiceProvider getIosp() {
        return this.orgFile == null ? null : this.orgFile.getIosp();
    }

    public void setReferencedFile(NetcdfFile ncfile) {
        this.orgFile = ncfile;
    }

    @Override
    protected String toStringDebug(Object o) {
        return "";
    }

    public void addCoordinateSystem(CoordinateSystem cs) {
        this.coordSys.add(cs);
    }

    public void addCoordinateTransform(CoordinateTransform ct) {
        if (!this.coordTransforms.contains(ct)) {
            this.coordTransforms.add(ct);
        }
    }

    public CoordinateAxis addCoordinateAxis(VariableDS v) {
        if (v == null) {
            return null;
        }
        CoordinateAxis oldVar = this.findCoordinateAxis(v.getFullName());
        if (oldVar != null) {
            this.coordAxes.remove(oldVar);
        }
        CoordinateAxis ca = v instanceof CoordinateAxis ? (CoordinateAxis)v : CoordinateAxis.factory(this, v);
        this.coordAxes.add(ca);
        if (v.isMemberOfStructure()) {
            Structure parentOrg = v.getParentStructure();
            Structure parent = (Structure)this.findVariable(parentOrg.getFullNameEscaped());
            parent.replaceMemberVariable(ca);
        } else {
            this.removeVariable(v.getParentGroup(), v.getShortName());
            this.addVariable(ca.getParentGroup(), ca);
        }
        return ca;
    }

    @Override
    public Variable addVariable(Group g, Variable v) {
        if (!(v instanceof VariableDS) && !(v instanceof StructureDS)) {
            throw new IllegalArgumentException("NetcdfDataset variables must be VariableEnhanced objects");
        }
        return super.addVariable(g, v);
    }

    public CoordSysBuilderIF enhance() throws IOException {
        return NetcdfDataset.enhance(this, defaultEnhanceMode, null);
    }

    public void enhance(Set<Enhance> mode) throws IOException {
        NetcdfDataset.enhance(this, mode, null);
    }

    public boolean enhanceNeeded(Set<Enhance> want) throws IOException {
        if (want == null) {
            return false;
        }
        for (Enhance mode : want) {
            if (this.enhanceMode.contains((Object)mode)) continue;
            return true;
        }
        return false;
    }

    public void setValues(Variable v, int npts, double start, double incr) {
        if ((long)npts != v.getSize()) {
            throw new IllegalArgumentException("bad npts = " + npts + " should be " + v.getSize());
        }
        Array data = Array.makeArray(v.getDataType(), npts, start, incr);
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public void setValues(Variable v, List<String> values) throws IllegalArgumentException {
        Array data = Array.makeArray(v.getDataType(), v.isUnsigned(), values);
        if (data.getSize() != v.getSize()) {
            throw new IllegalArgumentException("Incorrect number of values specified for the Variable " + v.getFullName() + " needed= " + v.getSize() + " given=" + data.getSize());
        }
        if (v.getRank() != 1) {
            data = data.reshape(v.getShape());
        }
        v.setCachedData(data, true);
    }

    public static Array makeArray(DataType dtype, List<String> stringValues) throws NumberFormatException {
        return Array.makeArray(dtype, stringValues);
    }

    @Override
    public void getDetailInfo(Formatter f) {
        f.format("NetcdfDataset location= %s%n", this.getLocation());
        f.format("  title= %s%n", this.getTitle());
        f.format("  id= %s%n", this.getId());
        f.format("  fileType= %s%n", this.getFileTypeId());
        f.format("  fileDesc= %s%n", this.getFileTypeDescription());
        f.format("  class= %s%n", this.getClass().getName());
        if (this.agg == null) {
            f.format("  has no Aggregation element%n", new Object[0]);
        } else {
            f.format("%nAggregation:%n", new Object[0]);
            this.agg.getDetailInfo(f);
        }
        if (this.orgFile == null) {
            f.format("  has no referenced NetcdfFile%n", new Object[0]);
            this.showCached(f);
            this.showProxies(f);
        } else {
            f.format("%nReferenced File:%n", new Object[0]);
            f.format("%s", this.orgFile.getDetailInfo());
        }
    }

    void dumpClasses(Group g, PrintWriter out) {
        out.println("Dimensions:");
        for (Dimension ds : g.getDimensions()) {
            out.println("  " + ds.getShortName() + " " + ds.getClass().getName());
        }
        out.println("Atributes:");
        for (Attribute a : g.getAttributes()) {
            out.println("  " + a.getShortName() + " " + a.getClass().getName());
        }
        out.println("Variables:");
        this.dumpVariables(g.getVariables(), out);
        out.println("Groups:");
        for (Group nested : g.getGroups()) {
            out.println("  " + nested.getFullName() + " " + nested.getClass().getName());
            this.dumpClasses(nested, out);
        }
    }

    private void dumpVariables(List<Variable> vars, PrintWriter out) {
        for (Variable v : vars) {
            out.print("  " + v.getFullName() + " " + v.getClass().getName());
            if (v instanceof CoordinateAxis) {
                out.println("  " + (Object)((Object)((CoordinateAxis)v).getAxisType()));
            } else {
                out.println();
            }
            if (!(v instanceof Structure)) continue;
            this.dumpVariables(((Structure)v).getVariables(), out);
        }
    }

    public static void debugDump(PrintWriter out, NetcdfDataset ncd) {
        String referencedLocation = ncd.orgFile == null ? "(null)" : ncd.orgFile.getLocation();
        out.println("\nNetcdfDataset dump = " + ncd.getLocation() + " url= " + referencedLocation + "\n");
        ncd.dumpClasses(ncd.getRootGroup(), out);
    }

    @Override
    public String getFileTypeId() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeId();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeId();
        }
        return "N/A";
    }

    @Override
    public String getFileTypeDescription() {
        if (this.orgFile != null) {
            return this.orgFile.getFileTypeDescription();
        }
        if (this.agg != null) {
            return this.agg.getFileTypeDescription();
        }
        return "N/A";
    }

    public void check(Formatter f) {
        for (Variable v : this.getVariables()) {
            Variable orgVar;
            VariableDS vds = (VariableDS)v;
            if (vds.getOriginalDataType() != vds.getDataType()) {
                f.format("Variable %s has type %s, org = %s%n", new Object[]{vds.getFullName(), vds.getOriginalDataType(), vds.getDataType()});
            }
            if (vds.getOriginalVariable() == null || (orgVar = vds.getOriginalVariable()).getRank() == vds.getRank()) continue;
            f.format("Variable %s has rank %d, org = %d%n", vds.getFullName(), vds.getRank(), orgVar.getRank());
        }
    }

    public static void main(String[] arg) throws IOException {
        String usage = "usage: ucar.nc2.dataset.NetcdfDataset -in <fileIn> -out <fileOut> [-isLargeFile] [-netcdf4]";
        if (arg.length < 4) {
            System.out.println(usage);
            System.exit(0);
        }
        boolean isLargeFile = false;
        boolean netcdf4 = false;
        String datasetIn = null;
        String datasetOut = null;
        for (int i = 0; i < arg.length; ++i) {
            String s = arg[i];
            if (s.equalsIgnoreCase("-in")) {
                datasetIn = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-out")) {
                datasetOut = arg[i + 1];
            }
            if (s.equalsIgnoreCase("-isLargeFile")) {
                isLargeFile = true;
            }
            if (!s.equalsIgnoreCase("-netcdf4")) continue;
            netcdf4 = true;
        }
        if (datasetIn == null || datasetOut == null) {
            System.out.println(usage);
            System.exit(0);
        }
        CancelTaskImpl cancel = new CancelTaskImpl();
        NetcdfFile ncfileIn = NetcdfDataset.openFile(datasetIn, cancel);
        System.out.printf("NetcdfDatataset read from %s write to %s ", datasetIn, datasetOut);
        NetcdfFileWriter.Version version = netcdf4 ? NetcdfFileWriter.Version.netcdf4 : NetcdfFileWriter.Version.netcdf3;
        FileWriter2 writer = new FileWriter2(ncfileIn, datasetOut, version, null);
        writer.getNetcdfFileWriter().setLargeFile(isLargeFile);
        NetcdfFile ncfileOut = writer.write(cancel);
        if (ncfileOut != null) {
            ncfileOut.close();
        }
        ncfileIn.close();
        cancel.setDone(true);
        System.out.printf("%s%n", cancel);
    }

    private static class VariableComparator
    implements Comparator {
        private VariableComparator() {
        }

        public int compare(Object o1, Object o2) {
            String cs2;
            VariableEnhanced v1 = (VariableEnhanced)o1;
            VariableEnhanced v2 = (VariableEnhanced)o2;
            List<CoordinateSystem> list1 = v1.getCoordinateSystems();
            String cs1 = list1.size() > 0 ? list1.get(0).getName() : "";
            List<CoordinateSystem> list2 = v2.getCoordinateSystems();
            String string = cs2 = list2.size() > 0 ? list2.get(0).getName() : "";
            if (cs2.equals(cs1)) {
                return v1.getShortName().compareToIgnoreCase(v2.getShortName());
            }
            return cs1.compareToIgnoreCase(cs2);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }
    }

    private static class RemoteFactory
    implements FileFactory {
        private RemoteFactory() {
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return new CdmRemote(location);
        }
    }

    private static class NcMLFactory
    implements FileFactory {
        private NcMLFactory() {
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return NcMLReader.readNcML(location, cancelTask);
        }
    }

    private static class Dap4Factory
    implements FileFactory {
        private Dap4Factory() {
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return NetcdfDataset.openDap4ByReflection(location, cancelTask);
        }
    }

    private static class DodsFactory
    implements FileFactory {
        private DodsFactory() {
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object spiObject) throws IOException {
            return NetcdfDataset.openDodsByReflection(location, cancelTask);
        }
    }

    private static class MyNetcdfDatasetFactory
    implements FileFactory {
        String location;
        EnumSet<Enhance> enhanceMode;

        MyNetcdfDatasetFactory(String location, Set<Enhance> enhanceMode) {
            this.location = location;
            this.enhanceMode = enhanceMode == null ? EnumSet.noneOf(Enhance.class) : EnumSet.copyOf(enhanceMode);
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openDataset(location, this.enhanceMode, buffer_size, cancelTask, iospMessage);
        }

        public int hashCode() {
            int result = this.location.hashCode();
            result += 37 * result + this.enhanceMode.hashCode();
            return result;
        }
    }

    private static class MyNetcdfFileFactory
    implements FileFactory {
        private MyNetcdfFileFactory() {
        }

        @Override
        public NetcdfFile open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
            return NetcdfDataset.openFile(location, buffer_size, cancelTask, iospMessage);
        }
    }

    public static enum Enhance {
        ScaleMissing,
        ScaleMissingDefer,
        CoordSystems,
        ConvertEnums;

    }
}

