/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateND;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTime2DUnionizer;

public class CoordinateSharer<T> {
    private static final Logger logger = LoggerFactory.getLogger(CoordinateSharer.class);
    boolean isRuntimeUnion = false;
    Set<Coordinate> runtimeBuilders = new HashSet<Coordinate>();
    Set<Coordinate> timeBuilders = new HashSet<Coordinate>();
    Set<Coordinate> timeIntvBuilders = new HashSet<Coordinate>();
    Set<Coordinate> vertBuilders = new HashSet<Coordinate>();
    Set<Coordinate> ensBuilders = new HashSet<Coordinate>();
    Set<Coordinate> time2DBuilders = new HashSet<Coordinate>();
    List<Coordinate> unionCoords = new ArrayList<Coordinate>();
    Map<Coordinate, Integer> coordMap;
    CoordinateRuntime.Builder2 runtimeAllBuilder;
    CoordinateTime2DUnionizer time2DUnionizer;
    CoordinateTime2DUnionizer timeIntv2DUnionizer;
    CoordinateRuntime runtimeAll;
    CoordinateTime2D time2Dall;
    CoordinateTime2D timeIntv2Dall;
    private Map<Coordinate, Coordinate> swap = new HashMap<Coordinate, Coordinate>();

    public CoordinateSharer(boolean isRuntimeUnion) {
    }

    public void addCoordinate(Coordinate coord) {
        switch (coord.getType()) {
            case runtime: {
                this.runtimeBuilders.add(coord);
                break;
            }
            case time: {
                this.timeBuilders.add(coord);
                break;
            }
            case timeIntv: {
                this.timeIntvBuilders.add(coord);
                break;
            }
            case time2D: {
                this.time2DBuilders.add(coord);
                break;
            }
            case vert: {
                this.vertBuilders.add(coord);
                break;
            }
            case ens: {
                this.ensBuilders.add(coord);
            }
        }
    }

    public void addCoords(List<Coordinate> coords) {
        CoordinateRuntime runtime = null;
        for (Coordinate coord : coords) {
            switch (coord.getType()) {
                case runtime: {
                    runtime = (CoordinateRuntime)coord;
                    if (this.isRuntimeUnion) {
                        if (this.runtimeAllBuilder == null) {
                            this.runtimeAllBuilder = new CoordinateRuntime.Builder2(runtime.getTimeUnits());
                        }
                        this.runtimeAllBuilder.addAll(coord);
                        break;
                    }
                    this.runtimeBuilders.add(coord);
                    break;
                }
                case time: {
                    this.timeBuilders.add(coord);
                    break;
                }
                case timeIntv: {
                    this.timeIntvBuilders.add(coord);
                    break;
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)coord;
                    if (this.isRuntimeUnion) {
                        if (time2D.isTimeInterval()) {
                            if (this.timeIntv2DUnionizer == null) {
                                this.timeIntv2DUnionizer = new CoordinateTime2DUnionizer(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode(), true);
                            }
                            this.timeIntv2DUnionizer.addAll(time2D);
                        } else {
                            if (this.time2DUnionizer == null) {
                                this.time2DUnionizer = new CoordinateTime2DUnionizer(time2D.isTimeInterval(), time2D.getTimeUnit(), coord.getCode(), true);
                            }
                            this.time2DUnionizer.addAll(time2D);
                        }
                    } else {
                        this.time2DBuilders.add(coord);
                    }
                    CoordinateRuntime runtimeFrom2D = time2D.getRuntimeCoordinate();
                    if (runtimeFrom2D.equals(runtime)) break;
                    System.out.println("CoordinateSharer runtimes differ");
                    break;
                }
                case vert: {
                    this.vertBuilders.add(coord);
                    break;
                }
                case ens: {
                    this.ensBuilders.add(coord);
                }
            }
        }
    }

    public void finish() {
        if (this.isRuntimeUnion) {
            this.runtimeAll = (CoordinateRuntime)this.runtimeAllBuilder.finish();
            this.unionCoords.add(this.runtimeAll);
            if (this.time2DUnionizer != null) {
                this.time2DUnionizer.setRuntimeCoords(this.runtimeAll);
                this.time2Dall = (CoordinateTime2D)this.time2DUnionizer.finish();
                this.unionCoords.add(this.time2Dall);
            }
            if (this.timeIntv2DUnionizer != null) {
                this.timeIntv2DUnionizer.setRuntimeCoords(this.runtimeAll);
                this.timeIntv2Dall = (CoordinateTime2D)this.timeIntv2DUnionizer.finish();
                this.unionCoords.add(this.timeIntv2Dall);
            }
        } else {
            for (Coordinate coordinate : this.runtimeBuilders) {
                this.unionCoords.add(coordinate);
            }
            Iterator<Coordinate> coord2Dset = new HashSet();
            for (Coordinate coord : this.time2DBuilders) {
                CoordinateTime2D coord2D = (CoordinateTime2D)coord;
                CoordinateTime2DUnionizer unionizer = new CoordinateTime2DUnionizer(coord2D.isTimeInterval(), coord2D.getTimeUnit(), coord2D.getCode(), true);
                unionizer.addAll(coord2D);
                unionizer.finish();
                CoordinateTime2D result = (CoordinateTime2D)unionizer.getCoordinate();
                if (result.isOrthogonal() || result.isRegular()) {
                    if (!((HashSet)((Object)coord2Dset)).contains(result)) {
                        this.unionCoords.add(result);
                        ((HashSet)((Object)coord2Dset)).add(result);
                    }
                    this.swap.put(coord, result);
                    continue;
                }
                this.unionCoords.add(coord2D);
                ((HashSet)((Object)coord2Dset)).add(coord2D);
            }
        }
        for (Coordinate coordinate : this.timeBuilders) {
            this.unionCoords.add(coordinate);
        }
        for (Coordinate coordinate : this.timeIntvBuilders) {
            this.unionCoords.add(coordinate);
        }
        for (Coordinate coordinate : this.vertBuilders) {
            this.unionCoords.add(coordinate);
        }
        for (Coordinate coordinate : this.ensBuilders) {
            this.unionCoords.add(coordinate);
        }
        this.coordMap = new HashMap<Coordinate, Integer>();
        for (int i = 0; i < this.unionCoords.size(); ++i) {
            this.coordMap.put(this.unionCoords.get(i), i);
        }
    }

    public List<Coordinate> getUnionCoords() {
        return this.unionCoords;
    }

    public CoordinateND<T> reindexCoordND(CoordinateND<T> prev) {
        boolean needReindex = false;
        for (Coordinate coord : prev.getCoordinates()) {
            if (this.isRuntimeUnion && coord.getType() == Coordinate.Type.runtime && !coord.equals(this.runtimeAll)) {
                needReindex = true;
            }
            if (null == this.swap.get(coord)) continue;
            needReindex = true;
        }
        if (!needReindex) {
            return prev;
        }
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        for (Coordinate prevCoord : prev.getCoordinates()) {
            if (this.isRuntimeUnion) {
                if (prevCoord.getType() == Coordinate.Type.runtime) {
                    coords.add(this.runtimeAll);
                    continue;
                }
                if (prevCoord.getType() == Coordinate.Type.time2D) {
                    CoordinateTime2D time2D = (CoordinateTime2D)prevCoord;
                    if (time2D.isTimeInterval()) {
                        coords.add(this.timeIntv2Dall);
                        continue;
                    }
                    coords.add(this.time2Dall);
                    continue;
                }
                coords.add(prevCoord);
                continue;
            }
            Coordinate newCoord = this.swap.get(prevCoord);
            if (newCoord != null) {
                coords.add(newCoord);
                continue;
            }
            coords.add(prevCoord);
        }
        return new CoordinateND.Builder<T>().reindex(coords, prev);
    }

    public List<Integer> reindex2shared(List<Coordinate> prev) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Coordinate coord : prev) {
            Integer idx;
            Coordinate swapCoord = this.swap.get(coord);
            if (swapCoord != null) {
                coord = swapCoord;
            }
            if ((idx = this.getIndexIntoShared(coord)) == null) {
                Formatter f = new Formatter();
                this.showInfo(f);
                f.format("%nprev:%n", new Object[0]);
                for (Coordinate c : prev) {
                    f.format(" %d == (%s) %s%n", c.hashCode(), c, c.getName());
                }
                System.out.printf("%s%n", f.toString());
                logger.error("CoordinateSharer cant find coordinate " + coord.getName(), new Throwable());
                continue;
            }
            result.add(idx);
        }
        return result;
    }

    private Integer getIndexIntoShared(Coordinate prev) {
        if (this.isRuntimeUnion) {
            switch (prev.getType()) {
                case runtime: {
                    return this.coordMap.get(this.runtimeAll);
                }
                case time2D: {
                    CoordinateTime2D time2D = (CoordinateTime2D)prev;
                    if (time2D.isTimeInterval()) {
                        return this.coordMap.get(this.timeIntv2Dall);
                    }
                    return this.coordMap.get(this.time2Dall);
                }
            }
            return this.coordMap.get(prev);
        }
        return this.coordMap.get(prev);
    }

    public void showInfo(Formatter sb) {
        sb.format("unionCoords:%n", new Object[0]);
        for (Coordinate coordinate : this.unionCoords) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%ncoordMap:%n", new Object[0]);
        for (Coordinate coordinate : this.coordMap.keySet()) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%ntime2DBuilders:%n", new Object[0]);
        for (Coordinate coordinate : this.time2DBuilders) {
            sb.format(" %d == (%s) %s%n", coordinate.hashCode(), coordinate, coordinate.getName());
        }
        sb.format("%nswap:%n", new Object[0]);
        for (Map.Entry entry : this.swap.entrySet()) {
            sb.format(" %d (%s) %s -> %d (%s) %s%n", ((Coordinate)entry.getKey()).hashCode(), entry.getKey(), ((Coordinate)entry.getKey()).getName(), ((Coordinate)entry.getValue()).hashCode(), entry.getValue(), ((Coordinate)entry.getValue()).getName());
        }
    }
}

