/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.wcs.v1_1_0.WcsException;

public class ExceptionReport {
    protected static final Namespace owsNS = Namespace.getNamespace("http://www.opengis.net/ows");
    private Document exceptionReport;

    public ExceptionReport(WcsException exception) {
        this(Collections.singletonList(exception));
    }

    public ExceptionReport(List<WcsException> exceptions) {
        Element rootElem = new Element("ExceptionReport", owsNS);
        rootElem.addNamespaceDeclaration(owsNS);
        rootElem.setAttribute("version", "1.0.0");
        if (exceptions != null) {
            for (WcsException curException : exceptions) {
                Element exceptionElem = new Element("Exception", owsNS);
                exceptionElem.setAttribute("code", curException.getCode().toString());
                if (curException.getLocator() != null && !curException.getLocator().equals("")) {
                    exceptionElem.setAttribute("locator", curException.getLocator());
                }
                if (curException.getTextMessages() != null) {
                    for (String curMessage : curException.getTextMessages()) {
                        Element excTextElem = new Element("ExceptionText", owsNS);
                        excTextElem.addContent(curMessage);
                        exceptionElem.addContent(excTextElem);
                    }
                }
                rootElem.addContent(exceptionElem);
            }
        }
        this.exceptionReport = new Document(rootElem);
    }

    public Document getExceptionReport() {
        return this.exceptionReport;
    }

    public void writeExceptionReport(PrintWriter pw) throws IOException {
        XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
        xmlOutputter.output(this.exceptionReport, (Writer)pw);
    }
}

