/*
 * Decompiled with CFR 0.152.
 */
package edu.wisc.ssec.mcidas.adde;

import edu.wisc.ssec.mcidas.McIDASUtil;
import edu.wisc.ssec.mcidas.adde.AddeDatasetURL;
import java.util.Date;

public class AddeImageURL
extends AddeDatasetURL {
    public static final String KEY_BAND = "BAND";
    public static final String KEY_POS = "POS";
    public static final String KEY_ID = "ID";
    public static final String KEY_LATLON = "LATLON";
    public static final String KEY_LINEELE = "LINELE";
    public static final String KEY_LOC = "LOC";
    public static final String KEY_MAG = "MAG";
    public static final String KEY_NUM = "NUM";
    public static final String KEY_PLACE = "PLACE";
    public static final String KEY_SIZE = "SIZE";
    public static final String KEY_SPAC = "SPAC";
    public static final String KEY_UNIT = "UNIT";
    public static final String KEY_NAV = "NAV";
    public static final String KEY_AUX = "AUX";
    public static final String KEY_DOC = "DOC";
    public static final String KEY_DAY = "DAY";
    public static final String KEY_TIME = "TIME";
    private int lines;
    private int elements;
    private int emag = 1;
    private int lmag = 1;
    private static String DEFAULT_PLACE_VALUE = "ULEFT";
    private static String DEFAULT_LOCATE_KEY = "LINELE";
    private static String DEFAULT_LOCATE_VALUE = "0 0";
    private String locateKey = DEFAULT_LOCATE_KEY;
    private String placeValue = DEFAULT_PLACE_VALUE;
    private String locateValue = DEFAULT_LOCATE_VALUE;
    private String band = "ALL";
    private String unit = "X";
    private String navType = "X";
    private String auxValue = "YES";
    private String docValue = "X";
    private int spacing = -1;
    private String locationId = null;
    private int pos = 0;
    private Date startDate = null;
    private Date endDate = null;
    private String timeCoverage = "I";

    public AddeImageURL() {
    }

    public AddeImageURL(String host, String requestType, String group, String descriptor) {
        this(host, requestType, group, descriptor, null);
    }

    public AddeImageURL(String host, String requestType, String group, String descriptor, String query) {
        super(host, requestType, group, descriptor, query);
    }

    public AddeImageURL(String host, String requestType, String group, String descriptor, String locateKey, String locateValue, String placeValue, int lines, int elements, int lmag, int emag, String band, String unit, int spacing) {
        super(host, requestType, group, descriptor);
        this.locateKey = locateKey;
        this.locateValue = locateValue;
        this.placeValue = placeValue;
        this.lines = lines;
        this.elements = elements;
        this.lmag = lmag;
        this.emag = emag;
        this.band = band;
        this.unit = unit;
        this.spacing = spacing;
    }

    public String getPlaceValue() {
        return this.placeValue;
    }

    public String getLocateKey() {
        return this.locateKey;
    }

    public String getLocateValue() {
        return this.locateValue;
    }

    public int getLines() {
        return this.lines;
    }

    public int getElements() {
        return this.elements;
    }

    public int getElementMag() {
        return this.emag;
    }

    public int getLineMag() {
        return this.lmag;
    }

    public void setLocateKey(String value) {
        this.locateKey = value;
    }

    public void setLocateValue(String value) {
        this.locateValue = value;
    }

    public void setPlaceValue(String value) {
        this.placeValue = value;
    }

    public void setLines(int value) {
        this.lines = value;
    }

    public void setElements(int value) {
        this.elements = value;
    }

    public void setElementMag(int value) {
        this.emag = value;
    }

    public void setLineMag(int value) {
        this.lmag = value;
    }

    public void setSpacing(int value) {
        this.spacing = value;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setBand(String value) {
        this.band = value;
    }

    public String getBand() {
        return this.band;
    }

    public void setUnit(String value) {
        this.unit = value;
    }

    public String getUnit() {
        return this.unit;
    }

    public void setNavType(String value) {
        this.navType = value;
    }

    public String getNavType() {
        return this.navType;
    }

    public void setId(String value) {
        this.locationId = value;
    }

    public String getId() {
        return this.locationId;
    }

    public void setDatasetPosition(int value) {
        this.pos = value;
    }

    public int getDatasetPosition() {
        return this.pos;
    }

    public void setStartDate(Date value) {
        this.startDate = value;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setEndDate(Date value) {
        this.endDate = value;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setTimeCoverage(String value) {
        this.timeCoverage = value;
    }

    public String getTimeCoverage() {
        return this.timeCoverage;
    }

    public void setAuxValue(String value) {
        this.auxValue = value;
    }

    public String getAuxValue() {
        return this.auxValue;
    }

    public void setDocValue(String value) {
        this.docValue = value;
    }

    public String getDocValue() {
        return this.docValue;
    }

    protected String makeQuery() {
        StringBuffer buf = new StringBuffer(super.makeQuery());
        if (this.getRequestType().equals("imagedata")) {
            this.appendKeyValue(buf, KEY_BAND, this.band);
            this.appendKeyValue(buf, this.getLocateKey(), this.getLocateValue());
            this.appendKeyValue(buf, KEY_PLACE, this.getPlaceValue());
            this.appendKeyValue(buf, KEY_SIZE, this.getLines() + " " + this.getElements());
            this.appendKeyValue(buf, KEY_UNIT, this.getUnit());
            this.appendKeyValue(buf, KEY_MAG, this.getLineMag() + " " + this.getElementMag());
            this.appendKeyValue(buf, KEY_SPAC, this.getSpacing() == -1 ? "X" : "" + this.getSpacing());
            this.appendKeyValue(buf, KEY_NAV, this.getNavType());
            this.appendKeyValue(buf, KEY_AUX, this.getAuxValue());
            this.appendKeyValue(buf, KEY_DOC, this.getDocValue());
        } else {
            this.appendKeyValue(buf, KEY_BAND, "ALL");
        }
        if (this.getId() != null) {
            this.appendKeyValue(buf, KEY_ID, this.getId());
        }
        this.appendDateOrPosString(buf);
        return buf.toString();
    }

    protected void appendDateOrPosString(StringBuffer buf) {
        if (this.getStartDate() == null && this.getEndDate() == null) {
            this.appendKeyValue(buf, KEY_POS, "" + this.getDatasetPosition());
        } else {
            int[] start = null;
            if (this.getStartDate() != null) {
                start = McIDASUtil.mcSecsToDayTime(this.getStartDate().getTime() / 1000L);
            }
            int[] end = null;
            if (this.getEndDate() != null) {
                end = McIDASUtil.mcSecsToDayTime(this.getEndDate().getTime() / 1000L);
            }
            StringBuffer day = new StringBuffer();
            StringBuffer time = new StringBuffer();
            if (start != null) {
                day.append("" + start[0]);
                time.append(McIDASUtil.mcHmsToStr(start[1]));
            }
            day.append(" ");
            time.append(" ");
            if (end != null) {
                if (this.getRequestType().equals("imagedirectory")) {
                    day.append("" + end[0]);
                }
                time.append("" + McIDASUtil.mcHmsToStr(end[1]));
            } else {
                time.append(McIDASUtil.mcHmsToStr(start[1]));
            }
            time.append(" ");
            time.append(this.getTimeCoverage());
            this.appendKeyValue(buf, KEY_DAY, day.toString().trim());
            this.appendKeyValue(buf, KEY_TIME, time.toString().trim());
            if (this.getRequestType().equals("imagedirectory")) {
                this.appendKeyValue(buf, KEY_POS, "ALL");
            }
        }
    }
}

