/*
 * Decompiled with CFR 0.152.
 */
package dods.util.geturl.gui;

import dods.dap.DAS;
import dods.dap.DConnect;
import dods.dap.DDS;
import dods.dap.DataDDS;
import dods.util.geturl.gui.StatusWindow;
import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class GeturlFrame
extends Frame {
    protected boolean isApplet;
    protected TextField urlField;
    protected TextArea outputArea;
    protected Button getDASButton;
    protected Button getDDSButton;
    protected Button getDataButton;

    public GeturlFrame(boolean isApplet) {
        super("DODS Geturl Applet");
        this.setSize(640, 480);
        this.isApplet = isApplet;
        GridBagLayout gbl = new GridBagLayout();
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(gbl);
        gbc.anchor = 13;
        gbc.gridwidth = 1;
        gbc.gridy = 0;
        Label urlLabel = new Label("URL:");
        gbl.setConstraints(urlLabel, gbc);
        this.add(urlLabel);
        gbc.anchor = 17;
        gbc.gridwidth = 4;
        this.urlField = new TextField(70);
        gbl.setConstraints(this.urlField, gbc);
        this.add(this.urlField);
        gbc.gridwidth = 1;
        gbc.gridy = 1;
        this.getDASButton = new Button("Get DAS");
        this.getDASButton.addActionListener(new GetDASListener());
        gbl.setConstraints(this.getDASButton, gbc);
        this.add(this.getDASButton);
        this.getDDSButton = new Button("Get DDS");
        this.getDDSButton.addActionListener(new GetDDSListener());
        gbl.setConstraints(this.getDDSButton, gbc);
        this.add(this.getDDSButton);
        this.getDataButton = new Button("Get Data");
        this.getDataButton.addActionListener(new GetDataListener());
        gbl.setConstraints(this.getDataButton, gbc);
        this.add(this.getDataButton);
        gbc.gridwidth = 5;
        gbc.gridy = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.insets = new Insets(0, 5, 0, 5);
        this.outputArea = new TextArea(100, 200);
        this.outputArea.setEditable(false);
        gbl.setConstraints(this.outputArea, gbc);
        this.add(this.outputArea);
        this.addWindowListener(new WindowClosedListener(this));
        this.show();
    }

    private void setButtonsEnabled(boolean b) {
        this.getDASButton.setEnabled(b);
        this.getDDSButton.setEnabled(b);
        this.getDataButton.setEnabled(b);
    }

    private class WindowClosedListener
    extends WindowAdapter {
        GeturlFrame myFrame;

        WindowClosedListener(GeturlFrame myFrame) {
            this.myFrame = myFrame;
        }

        public void windowClosing(WindowEvent evt) {
            this.myFrame.dispose();
            if (!this.myFrame.isApplet) {
                System.exit(0);
            }
        }
    }

    private class GetDataListener
    implements ActionListener,
    Runnable {
        private GetDataListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread runThread = new Thread(this);
                runThread.start();
            }
            catch (IllegalThreadStateException e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect url = new DConnect(GeturlFrame.this.urlField.getText());
                DataDDS dds = url.getData(new StatusWindow(GeturlFrame.this.urlField.getText()));
                CharArrayWriter aw = new CharArrayWriter();
                dds.printVal(new PrintWriter(aw));
                GeturlFrame.this.outputArea.setText(aw.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }

    private class GetDDSListener
    implements ActionListener,
    Runnable {
        private GetDDSListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread runThread = new Thread(this);
                runThread.start();
            }
            catch (IllegalThreadStateException e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect url = new DConnect(GeturlFrame.this.urlField.getText());
                DDS dds = url.getDDS();
                CharArrayWriter aw = new CharArrayWriter();
                dds.print(new PrintWriter(aw));
                GeturlFrame.this.outputArea.setText(aw.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }

    private class GetDASListener
    implements ActionListener,
    Runnable {
        private GetDASListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                GeturlFrame.this.setButtonsEnabled(false);
                Thread runThread = new Thread(this);
                runThread.start();
            }
            catch (IllegalThreadStateException e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }

        public void run() {
            try {
                DConnect url = new DConnect(GeturlFrame.this.urlField.getText());
                DAS das = url.getDAS();
                CharArrayWriter aw = new CharArrayWriter();
                das.print(new PrintWriter(aw));
                GeturlFrame.this.outputArea.setText(aw.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
            catch (Exception e) {
                GeturlFrame.this.outputArea.setText(e.toString());
                GeturlFrame.this.setButtonsEnabled(true);
            }
        }
    }
}

