/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.EnvironmentMutableConfig;
import com.sleepycat.je.config.EnvironmentParams;
import com.sleepycat.je.dbi.DbConfigManager;
import java.util.Properties;
import java.util.concurrent.TimeUnit;

public class EnvironmentConfig
extends EnvironmentMutableConfig {
    public static final EnvironmentConfig DEFAULT = new EnvironmentConfig();
    public static final String MAX_MEMORY = "je.maxMemory";
    public static final String MAX_MEMORY_PERCENT = "je.maxMemoryPercent";
    public static final String SHARED_CACHE = "je.sharedCache";
    public static final String ENV_RECOVERY_FORCE_CHECKPOINT = "je.env.recoveryForceCheckpoint";
    public static final String ENV_RUN_IN_COMPRESSOR = "je.env.runINCompressor";
    public static final String ENV_RUN_CHECKPOINTER = "je.env.runCheckpointer";
    public static final String ENV_RUN_CLEANER = "je.env.runCleaner";
    public static final String ENV_BACKGROUND_READ_LIMIT = "je.env.backgroundReadLimit";
    public static final String ENV_BACKGROUND_WRITE_LIMIT = "je.env.backgroundWriteLimit";
    public static final String ENV_BACKGROUND_SLEEP_INTERVAL = "je.env.backgroundSleepInterval";
    public static final String ENV_CHECK_LEAKS = "je.env.checkLeaks";
    public static final String ENV_FORCED_YIELD = "je.env.forcedYield";
    public static final String ENV_IS_TRANSACTIONAL = "je.env.isTransactional";
    public static final String ENV_IS_LOCKING = "je.env.isLocking";
    public static final String ENV_READ_ONLY = "je.env.isReadOnly";
    public static final String ENV_FAIR_LATCHES = "je.env.fairLatches";
    public static final String ENV_DB_EVICTION = "je.env.dbEviction";
    public static final String ADLER32_CHUNK_SIZE = "je.adler32.chunkSize";
    public static final String LOG_TOTAL_BUFFER_BYTES = "je.log.totalBufferBytes";
    public static final String LOG_NUM_BUFFERS = "je.log.numBuffers";
    public static final String LOG_BUFFER_SIZE = "je.log.bufferSize";
    public static final String LOG_FAULT_READ_SIZE = "je.log.faultReadSize";
    public static final String LOG_ITERATOR_READ_SIZE = "je.log.iteratorReadSize";
    public static final String LOG_ITERATOR_MAX_SIZE = "je.log.iteratorMaxSize";
    public static final String LOG_FILE_MAX = "je.log.fileMax";
    public static final String LOG_CHECKSUM_READ = "je.log.checksumRead";
    public static final String LOG_VERIFY_CHECKSUMS = "je.log.verifyChecksums";
    public static final String LOG_MEM_ONLY = "je.log.memOnly";
    public static final String LOG_FILE_CACHE_SIZE = "je.log.fileCacheSize";
    public static final String LOG_FSYNC_TIMEOUT = "je.log.fsyncTimeout";
    public static final String LOG_USE_ODSYNC = "je.log.useODSYNC";
    public static final String LOG_USE_NIO = "je.log.useNIO";
    public static final String LOG_USE_WRITE_QUEUE = "je.log.useWriteQueue";
    public static final String LOG_WRITE_QUEUE_SIZE = "je.log.writeQueueSize";
    public static final String LOG_DIRECT_NIO = "je.log.directNIO";
    public static final String LOG_CHUNKED_NIO = "je.log.chunkedNIO";
    public static final String NODE_MAX_ENTRIES = "je.nodeMaxEntries";
    public static final String NODE_DUP_TREE_MAX_ENTRIES = "je.nodeDupTreeMaxEntries";
    public static final String TREE_MAX_DELTA = "je.tree.maxDelta";
    public static final String TREE_BIN_DELTA = "je.tree.binDelta";
    public static final String TREE_MIN_MEMORY = "je.tree.minMemory";
    public static final String COMPRESSOR_WAKEUP_INTERVAL = "je.compressor.wakeupInterval";
    public static final String COMPRESSOR_DEADLOCK_RETRY = "je.compressor.deadlockRetry";
    public static final String COMPRESSOR_LOCK_TIMEOUT = "je.compressor.lockTimeout";
    public static final String COMPRESSOR_PURGE_ROOT = "je.compressor.purgeRoot";
    public static final String EVICTOR_EVICT_BYTES = "je.evictor.evictBytes";
    public static final String EVICTOR_NODES_PER_SCAN = "je.evictor.nodesPerScan";
    public static final String EVICTOR_DEADLOCK_RETRY = "je.evictor.deadlockRetry";
    public static final String EVICTOR_LRU_ONLY = "je.evictor.lruOnly";
    public static final String EVICTOR_FORCED_YIELD = "je.evictor.forcedYield";
    public static final String CHECKPOINTER_BYTES_INTERVAL = "je.checkpointer.bytesInterval";
    public static final String CHECKPOINTER_WAKEUP_INTERVAL = "je.checkpointer.wakeupInterval";
    public static final String CHECKPOINTER_DEADLOCK_RETRY = "je.checkpointer.deadlockRetry";
    public static final String CHECKPOINTER_HIGH_PRIORITY = "je.checkpointer.highPriority";
    public static final String CLEANER_MIN_UTILIZATION = "je.cleaner.minUtilization";
    public static final String CLEANER_MIN_FILE_UTILIZATION = "je.cleaner.minFileUtilization";
    public static final String CLEANER_BYTES_INTERVAL = "je.cleaner.bytesInterval";
    public static final String CLEANER_FETCH_OBSOLETE_SIZE = "je.cleaner.fetchObsoleteSize";
    public static final String CLEANER_DEADLOCK_RETRY = "je.cleaner.deadlockRetry";
    public static final String CLEANER_LOCK_TIMEOUT = "je.cleaner.lockTimeout";
    public static final String CLEANER_EXPUNGE = "je.cleaner.expunge";
    public static final String CLEANER_MIN_AGE = "je.cleaner.minAge";
    public static final String CLEANER_MAX_BATCH_FILES = "je.cleaner.maxBatchFiles";
    public static final String CLEANER_READ_SIZE = "je.cleaner.readSize";
    public static final String CLEANER_DETAIL_MAX_MEMORY_PERCENTAGE = "je.cleaner.detailMaxMemoryPercentage";
    public static final String CLEANER_FORCE_CLEAN_FILES = "je.cleaner.forceCleanFiles";
    public static final String CLEANER_UPGRADE_TO_LOG_VERSION = "je.cleaner.upgradeToLogVersion";
    public static final String CLEANER_THREADS = "je.cleaner.threads";
    public static final String CLEANER_LOOK_AHEAD_CACHE_SIZE = "je.cleaner.lookAheadCacheSize";
    public static final String CLEANER_FOREGROUND_PROACTIVE_MIGRATION = "je.cleaner.foregroundProactiveMigration";
    public static final String CLEANER_BACKGROUND_PROACTIVE_MIGRATION = "je.cleaner.backgroundProactiveMigration";
    public static final String LOCK_N_LOCK_TABLES = "je.lock.nLockTables";
    public static final String LOCK_TIMEOUT = "je.lock.timeout";
    public static final String LOCK_OLD_LOCK_EXCEPTIONS = "je.lock.oldLockExceptions";
    public static final String TXN_TIMEOUT = "je.txn.timeout";
    public static final String TXN_SERIALIZABLE_ISOLATION = "je.txn.serializableIsolation";
    public static final String TXN_DURABILITY = "je.txn.durability";
    public static final String TXN_DEADLOCK_STACK_TRACE = "je.txn.deadlockStackTrace";
    public static final String TXN_DUMP_LOCKS = "je.txn.dumpLocks";
    public static final String TRACE_FILE = "java.util.logging.FileHandler.on";
    public static final String TRACE_CONSOLE = "java.util.logging.ConsoleHandler.on";
    public static final String TRACE_DB = "java.util.logging.DbLogHandler.on";
    public static final String TRACE_FILE_LIMIT = "java.util.logging.FileHandler.limit";
    public static final String TRACE_FILE_COUNT = "java.util.logging.FileHandler.count";
    public static final String TRACE_LEVEL = "java.util.logging.level";
    public static final String CONSOLE_LOGGING_LEVEL = "com.sleepycat.je.util.ConsoleHandler.level";
    public static final String FILE_LOGGING_LEVEL = "com.sleepycat.je.util.FileHandler.level";
    public static final String TRACE_LEVEL_LOCK_MANAGER = "java.util.logging.level.lockMgr";
    public static final String TRACE_LEVEL_RECOVERY = "java.util.logging.level.recovery";
    public static final String TRACE_LEVEL_EVICTOR = "java.util.logging.level.evictor";
    public static final String TRACE_LEVEL_CLEANER = "java.util.logging.level.cleaner";
    private boolean createUP = true;
    private boolean checkpointUP = true;
    private boolean allowCreate = false;
    private boolean txnReadCommitted = false;
    private String nodeName = null;

    public EnvironmentConfig() {
    }

    public EnvironmentConfig(Properties properties) throws IllegalArgumentException {
        super(properties);
    }

    public EnvironmentConfig setAllowCreate(boolean allowCreate) {
        this.allowCreate = allowCreate;
        return this;
    }

    public boolean getAllowCreate() {
        return this.allowCreate;
    }

    public EnvironmentConfig setLockTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, EnvironmentParams.LOCK_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public void setLockTimeout(long timeout) throws IllegalArgumentException {
        this.setLockTimeout(timeout, TimeUnit.MICROSECONDS);
    }

    public long getLockTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, EnvironmentParams.LOCK_TIMEOUT, unit);
    }

    public long getLockTimeout() {
        return this.getLockTimeout(TimeUnit.MICROSECONDS);
    }

    public EnvironmentConfig setReadOnly(boolean readOnly) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_RDONLY, readOnly, this.validateParams);
        return this;
    }

    public boolean getReadOnly() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_RDONLY);
    }

    public EnvironmentConfig setTransactional(boolean transactional) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_INIT_TXN, transactional, this.validateParams);
        return this;
    }

    public boolean getTransactional() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_INIT_TXN);
    }

    public EnvironmentConfig setLocking(boolean locking) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_INIT_LOCKING, locking, this.validateParams);
        return this;
    }

    public boolean getLocking() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_INIT_LOCKING);
    }

    public EnvironmentConfig setTxnTimeout(long timeout, TimeUnit unit) throws IllegalArgumentException {
        DbConfigManager.setDurationVal(this.props, EnvironmentParams.TXN_TIMEOUT, timeout, unit, this.validateParams);
        return this;
    }

    public void setTxnTimeout(long timeout) throws IllegalArgumentException {
        this.setTxnTimeout(timeout, TimeUnit.MICROSECONDS);
    }

    public long getTxnTimeout(TimeUnit unit) {
        return DbConfigManager.getDurationVal(this.props, EnvironmentParams.TXN_TIMEOUT, unit);
    }

    public long getTxnTimeout() {
        return this.getTxnTimeout(TimeUnit.MICROSECONDS);
    }

    public EnvironmentConfig setTxnSerializableIsolation(boolean txnSerializableIsolation) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION, txnSerializableIsolation, this.validateParams);
        return this;
    }

    public boolean getTxnSerializableIsolation() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.TXN_SERIALIZABLE_ISOLATION);
    }

    void setTxnReadCommitted(boolean txnReadCommitted) {
        this.txnReadCommitted = txnReadCommitted;
    }

    boolean getTxnReadCommitted() {
        return this.txnReadCommitted;
    }

    public EnvironmentConfig setSharedCache(boolean sharedCache) {
        DbConfigManager.setBooleanVal(this.props, EnvironmentParams.ENV_SHARED_CACHE, sharedCache, this.validateParams);
        return this;
    }

    public boolean getSharedCache() {
        return DbConfigManager.getBooleanVal(this.props, EnvironmentParams.ENV_SHARED_CACHE);
    }

    public EnvironmentConfig setNodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public EnvironmentConfig setConfigParam(String paramName, String value) throws IllegalArgumentException {
        DbConfigManager.setConfigParam(this.props, paramName, value, false, this.validateParams, false, true);
        return this;
    }

    void setCreateUP(boolean createUP) {
        this.createUP = createUP;
    }

    boolean getCreateUP() {
        return this.createUP;
    }

    void setCheckpointUP(boolean checkpointUP) {
        this.checkpointUP = checkpointUP;
    }

    boolean getCheckpointUP() {
        return this.checkpointUP;
    }

    public EnvironmentConfig clone() {
        return (EnvironmentConfig)super.clone();
    }

    public String toString() {
        return "allowCreate=" + this.allowCreate + "\n" + super.toString();
    }
}

