/*
 * Decompiled with CFR 0.152.
 */
package com.coverity.security;

public class Escape {
    public static String html(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block16: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': {
                    output.append("&#x09;");
                    continue block16;
                }
                case '\n': {
                    output.append("&#x0A;");
                    continue block16;
                }
                case '\f': {
                    output.append("&#x0C;");
                    continue block16;
                }
                case '\r': {
                    output.append("&#x0D;");
                    continue block16;
                }
                case '\'': {
                    output.append("&#39;");
                    continue block16;
                }
                case '\\': {
                    output.append("&#x5C;");
                    continue block16;
                }
                case ' ': {
                    output.append("&#x20;");
                    continue block16;
                }
                case '/': {
                    output.append("&#x2F;");
                    continue block16;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block16;
                }
                case '<': {
                    output.append("&lt;");
                    continue block16;
                }
                case '>': {
                    output.append("&gt;");
                    continue block16;
                }
                case '&': {
                    output.append("&amp;");
                    continue block16;
                }
                case '\u2028': {
                    output.append("&#x2028;");
                    continue block16;
                }
                case '\u2029': {
                    output.append("&#x2029;");
                    continue block16;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String htmlText(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block7: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\'': {
                    output.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    output.append("&quot;");
                    continue block7;
                }
                case '<': {
                    output.append("&lt;");
                    continue block7;
                }
                case '>': {
                    output.append("&gt;");
                    continue block7;
                }
                case '&': {
                    output.append("&amp;");
                    continue block7;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String uriParam(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block30: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': {
                    output.append("%09");
                    continue block30;
                }
                case '\n': {
                    output.append("%0A");
                    continue block30;
                }
                case '\f': {
                    output.append("%0C");
                    continue block30;
                }
                case '\r': {
                    output.append("%0D");
                    continue block30;
                }
                case ' ': {
                    output.append("%20");
                    continue block30;
                }
                case '!': {
                    output.append("%21");
                    continue block30;
                }
                case '\"': {
                    output.append("%22");
                    continue block30;
                }
                case '#': {
                    output.append("%23");
                    continue block30;
                }
                case '$': {
                    output.append("%24");
                    continue block30;
                }
                case '%': {
                    output.append("%25");
                    continue block30;
                }
                case '&': {
                    output.append("%26");
                    continue block30;
                }
                case '\'': {
                    output.append("%27");
                    continue block30;
                }
                case '(': {
                    output.append("%28");
                    continue block30;
                }
                case ')': {
                    output.append("%29");
                    continue block30;
                }
                case '*': {
                    output.append("%2A");
                    continue block30;
                }
                case '+': {
                    output.append("%2B");
                    continue block30;
                }
                case ',': {
                    output.append("%2C");
                    continue block30;
                }
                case '.': {
                    output.append("%2E");
                    continue block30;
                }
                case '/': {
                    output.append("%2F");
                    continue block30;
                }
                case ':': {
                    output.append("%3A");
                    continue block30;
                }
                case ';': {
                    output.append("%3B");
                    continue block30;
                }
                case '<': {
                    output.append("%3C");
                    continue block30;
                }
                case '=': {
                    output.append("%3D");
                    continue block30;
                }
                case '>': {
                    output.append("%3E");
                    continue block30;
                }
                case '?': {
                    output.append("%3F");
                    continue block30;
                }
                case '@': {
                    output.append("%40");
                    continue block30;
                }
                case '[': {
                    output.append("%5B");
                    continue block30;
                }
                case ']': {
                    output.append("%5D");
                    continue block30;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String uri(String input) {
        return Escape.uriParam(input);
    }

    public static String jsString(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block18: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\b': {
                    output.append("\\u0008");
                    continue block18;
                }
                case '\t': {
                    output.append("\\u0009");
                    continue block18;
                }
                case '\n': {
                    output.append("\\u000A");
                    continue block18;
                }
                case '\u000b': {
                    output.append("\\u000B");
                    continue block18;
                }
                case '\f': {
                    output.append("\\u000C");
                    continue block18;
                }
                case '\r': {
                    output.append("\\u000D");
                    continue block18;
                }
                case '\'': {
                    output.append("\\u0027");
                    continue block18;
                }
                case '\"': {
                    output.append("\\u0022");
                    continue block18;
                }
                case '\\': {
                    output.append("\\u005C");
                    continue block18;
                }
                case '%': {
                    output.append("\\u0025");
                    continue block18;
                }
                case '&': {
                    output.append("\\u0026");
                    continue block18;
                }
                case '/': {
                    output.append("\\u002F");
                    continue block18;
                }
                case '<': {
                    output.append("\\u003C");
                    continue block18;
                }
                case '>': {
                    output.append("\\u003E");
                    continue block18;
                }
                case '\u2028': {
                    output.append("\\u2028");
                    continue block18;
                }
                case '\u2029': {
                    output.append("\\u2029");
                    continue block18;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String jsRegex(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block24: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\t': {
                    output.append("\\t");
                    continue block24;
                }
                case '\n': {
                    output.append("\\n");
                    continue block24;
                }
                case '\u000b': {
                    output.append("\\v");
                    continue block24;
                }
                case '\f': {
                    output.append("\\f");
                    continue block24;
                }
                case '\r': {
                    output.append("\\r");
                    continue block24;
                }
                case '\\': {
                    output.append("\\\\");
                    continue block24;
                }
                case '/': {
                    output.append("\\/");
                    continue block24;
                }
                case '(': {
                    output.append("\\(");
                    continue block24;
                }
                case '[': {
                    output.append("\\[");
                    continue block24;
                }
                case '{': {
                    output.append("\\{");
                    continue block24;
                }
                case ']': {
                    output.append("\\]");
                    continue block24;
                }
                case ')': {
                    output.append("\\)");
                    continue block24;
                }
                case '}': {
                    output.append("\\}");
                    continue block24;
                }
                case '*': {
                    output.append("\\*");
                    continue block24;
                }
                case '+': {
                    output.append("\\+");
                    continue block24;
                }
                case '-': {
                    output.append("\\-");
                    continue block24;
                }
                case '.': {
                    output.append("\\.");
                    continue block24;
                }
                case '?': {
                    output.append("\\?");
                    continue block24;
                }
                case '!': {
                    output.append("\\!");
                    continue block24;
                }
                case '^': {
                    output.append("\\^");
                    continue block24;
                }
                case '$': {
                    output.append("\\$");
                    continue block24;
                }
                case '|': {
                    output.append("\\|");
                    continue block24;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String cssString(String input) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        block16: for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            switch (c) {
                case '\b': {
                    output.append("\\08 ");
                    continue block16;
                }
                case '\t': {
                    output.append("\\09 ");
                    continue block16;
                }
                case '\n': {
                    output.append("\\0A ");
                    continue block16;
                }
                case '\f': {
                    output.append("\\0C ");
                    continue block16;
                }
                case '\r': {
                    output.append("\\0D ");
                    continue block16;
                }
                case '\'': {
                    output.append("\\27 ");
                    continue block16;
                }
                case '\"': {
                    output.append("\\22 ");
                    continue block16;
                }
                case '\\': {
                    output.append("\\5C ");
                    continue block16;
                }
                case '&': {
                    output.append("\\26 ");
                    continue block16;
                }
                case '/': {
                    output.append("\\2F ");
                    continue block16;
                }
                case '<': {
                    output.append("\\3C ");
                    continue block16;
                }
                case '>': {
                    output.append("\\3E ");
                    continue block16;
                }
                case '\u2028': {
                    output.append("\\002028 ");
                    continue block16;
                }
                case '\u2029': {
                    output.append("\\002029 ");
                    continue block16;
                }
                default: {
                    output.append(c);
                }
            }
        }
        return output.toString();
    }

    public static String sqlLikeClause(String input) {
        return Escape.sqlLikeClause(input, '@');
    }

    public static String sqlLikeClause(String input, char escape) {
        if (input == null) {
            return null;
        }
        int length = input.length();
        StringBuilder output = Escape.allocateStringBuilder(length);
        for (int i = 0; i < length; ++i) {
            char c = input.charAt(i);
            if (c == escape || c == '_' || c == '%') {
                output.append(escape);
            }
            output.append(c);
        }
        return output.toString();
    }

    private static StringBuilder allocateStringBuilder(int length) {
        int buflen = length;
        if (length * 2 > 0) {
            buflen = length * 2;
        }
        return new StringBuilder(buflen);
    }
}

