/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.internal.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Stack;
import javax.measure.format.MeasurementParseException;
import tech.units.indriya.function.RationalNumber;
import tech.units.indriya.internal.function.calc.Calculator;

public class RationalNumberScanner {
    private final CharSequence csq;
    private final ParsePosition cursor;
    private final NumberFormat numberFormat;
    private boolean divisionCharacterDetected = false;

    public RationalNumberScanner(CharSequence csq, ParsePosition cursor, NumberFormat numberFormat) {
        this.csq = csq;
        this.cursor = cursor;
        this.numberFormat = numberFormat;
    }

    private int scanForStart(int pos) {
        while (pos < this.csq.length()) {
            char c = this.csq.charAt(pos);
            if (!Character.isWhitespace(c)) {
                return pos;
            }
            ++pos;
        }
        return pos;
    }

    private int scanForEnd(int pos) {
        this.divisionCharacterDetected = false;
        while (pos < this.csq.length()) {
            char c = this.csq.charAt(pos);
            if (c == RationalNumber.DIVISION_CHARACTER) {
                this.divisionCharacterDetected = true;
                break;
            }
            if (Character.isWhitespace(c)) break;
            ++pos;
        }
        this.cursor.setIndex(pos + 1);
        return pos;
    }

    public Number getNumber() {
        Stack<String> numberLiterals = new Stack<String>();
        do {
            int startDecimal = this.scanForStart(this.cursor.getIndex());
            int endDecimal = this.scanForEnd(startDecimal + 1);
            String numberLiteral = this.csq.subSequence(startDecimal, endDecimal).toString();
            numberLiterals.push(numberLiteral);
        } while (this.divisionCharacterDetected);
        if (numberLiterals.size() == 2) {
            BigInteger divisor = new BigInteger((String)numberLiterals.pop());
            BigInteger dividend = new BigInteger((String)numberLiterals.pop());
            return RationalNumber.of(dividend, divisor);
        }
        if (numberLiterals.size() == 1) {
            String numberLiteral = (String)numberLiterals.pop();
            if (this.numberFormat == null) {
                try {
                    BigDecimal bigDecimal = new BigDecimal(numberLiteral);
                    return Calculator.of(bigDecimal).peek();
                }
                catch (Exception e) {
                    throw new MeasurementParseException("Failed to parse number-literal '" + numberLiteral + "'.");
                }
            }
            try {
                return this.numberFormat.parse(numberLiteral);
            }
            catch (ParseException e) {
                throw new MeasurementParseException(e);
            }
        }
        throw new MeasurementParseException("Unexpected number of number-literals in '" + this.csq + "'");
    }
}

