/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.geotools.metadata.i18n.Errors;
import org.geotools.util.ClassChanger;
import org.geotools.util.Classes;
import org.geotools.util.NumberRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.opengis.util.Cloneable;

public class RangeSet<T extends Comparable<? super T>>
extends AbstractSet<Range<T>>
implements SortedSet<Range<T>>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 2439002271813328080L;
    private static final Comparator<Range> COMPARATOR = new Comparator<Range>(){

        @Override
        public int compare(Range r1, Range r2) {
            int cmin = r1.getMinValue().compareTo(r2.getMinValue());
            int cmax = r1.getMaxValue().compareTo(r2.getMaxValue());
            if (cmin == 0) {
                cmin = (r1.isMinIncluded() ? -1 : 0) - (r2.isMinIncluded() ? -1 : 0);
            }
            if (cmax == 0) {
                cmax = (r1.isMaxIncluded() ? 1 : 0) - (r2.isMaxIncluded() ? 1 : 0);
            }
            if (cmin == cmax) {
                return cmax;
            }
            if (cmin == 0) {
                return cmax;
            }
            if (cmax == 0) {
                return cmin;
            }
            throw new IllegalArgumentException("Unordered ranges");
        }
    };
    private final Class<T> elementClass;
    private final Class<?> relaxedClass;
    private final Class<?> arrayElementClass;
    private final byte arrayElementCode;
    private Object array;
    private int modCount;
    private final boolean isPrimitive;
    private final boolean useClassChanger;
    private final boolean isNumeric;

    public RangeSet(Class<T> type) throws IllegalArgumentException {
        if (!Comparable.class.isAssignableFrom(type)) {
            throw new IllegalArgumentException(Errors.format(123, type));
        }
        Class<T> elementType = ClassChanger.getTransformedClass(type);
        this.useClassChanger = elementType != type;
        this.elementClass = type;
        this.arrayElementClass = Classes.wrapperToPrimitive(elementType);
        this.arrayElementCode = Classes.getEnumConstant(this.arrayElementClass);
        this.isPrimitive = this.arrayElementClass.isPrimitive();
        this.isNumeric = Number.class.isAssignableFrom(type);
        this.relaxedClass = this.isNumeric ? Number.class : type;
    }

    private <T> Comparable<T> toArrayElement(Comparable<T> value) {
        if (!this.relaxedClass.isInstance(value)) {
            throw new IllegalArgumentException(value == null ? Errors.format(143, "value") : Errors.format(61, value.getClass(), this.elementClass));
        }
        if (this.useClassChanger) {
            try {
                value = (Comparable)ClassChanger.toNumber(value);
            }
            catch (ClassNotFoundException cause) {
                ClassCastException exception = new ClassCastException(Errors.format(61, value.getClass(), this.elementClass));
                exception.initCause(cause);
                throw exception;
            }
        }
        return value;
    }

    @Override
    public Comparator<Range<T>> comparator() {
        return COMPARATOR;
    }

    @Override
    public void clear() {
        this.array = null;
        ++this.modCount;
    }

    @Override
    public int size() {
        return this.array != null ? Array.getLength(this.array) / 2 : 0;
    }

    @Override
    public boolean add(Range<T> range) {
        if (!range.isMinIncluded() || !range.isMaxIncluded()) {
            throw new UnsupportedOperationException("Open interval not yet supported");
        }
        return this.add((Comparable)range.getMinValue(), (Comparable)range.getMaxValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    public <N> boolean add(Comparable<? super N> min, Comparable<? super N> max) throws IllegalArgumentException {
        int n;
        int i1;
        int i0;
        int modCountChk;
        Comparable upper;
        block14: {
            block16: {
                Comparable lower = this.toArrayElement(min);
                if (lower.compareTo(upper = this.toArrayElement(max)) > 0) {
                    throw new IllegalArgumentException(Errors.format(14, min, max));
                }
                if (this.array == null) {
                    ++this.modCount;
                    this.array = Array.newInstance(this.arrayElementClass, 2);
                    Array.set(this.array, 0, lower);
                    Array.set(this.array, 1, upper);
                    return true;
                }
                modCountChk = this.modCount++;
                i0 = this.binarySearch(lower);
                if (i0 >= 0) break block16;
                if (((i0 ^= 0xFFFFFFFF) & 1) != 0) {
                    lower = (Comparable)Array.get(this.array, --i0);
                    i1 = this.binarySearch(upper);
                    break block14;
                } else if (i0 != Array.getLength(this.array) && (i1 = this.binarySearch(upper)) != ~i0) {
                    Array.set(this.array, i0, lower);
                    break block14;
                } else {
                    ++this.modCount;
                    Object old = this.array;
                    int length = Array.getLength(this.array);
                    this.array = Array.newInstance(this.arrayElementClass, length + 2);
                    System.arraycopy(old, 0, this.array, 0, i0);
                    System.arraycopy(old, i0, this.array, i0 + 2, length - i0);
                    Array.set(this.array, i0 + 0, lower);
                    Array.set(this.array, i0 + 1, upper);
                    return true;
                }
            }
            i0 &= 0xFFFFFFFE;
            i1 = this.binarySearch(upper);
        }
        if (i1 < 0) {
            if (((i1 ^= 0xFFFFFFFF) & 1) != 0) {
                upper = (Comparable)Array.get(this.array, i1);
            } else {
                ++this.modCount;
                Array.set(this.array, --i1, upper);
            }
        } else {
            i1 |= 1;
        }
        assert ((i0 & 1) == 0) : i0;
        assert ((i1 & 1) != 0) : i1;
        if ((n = i1 - ++i0) > 0) {
            ++this.modCount;
            Object old = this.array;
            int length = Array.getLength(this.array);
            this.array = Array.newInstance(this.arrayElementClass, length - n);
            System.arraycopy(old, 0, this.array, 0, i0);
            System.arraycopy(old, i1, this.array, i0, length - i1);
        }
        assert ((Array.getLength(this.array) & 1) == 0);
        if (modCountChk == this.modCount) return false;
        return true;
    }

    public boolean add(byte lower, byte upper) throws IllegalArgumentException {
        return this.add(Byte.valueOf(lower), Byte.valueOf(upper));
    }

    public boolean add(short lower, short upper) throws IllegalArgumentException {
        return this.add(Short.valueOf(lower), Short.valueOf(upper));
    }

    public boolean add(int lower, int upper) throws IllegalArgumentException {
        return this.add(Integer.valueOf(lower), Integer.valueOf(upper));
    }

    public boolean add(long lower, long upper) throws IllegalArgumentException {
        return this.add(Long.valueOf(lower), Long.valueOf(upper));
    }

    public boolean add(float lower, float upper) throws IllegalArgumentException {
        return this.add(Float.valueOf(lower), Float.valueOf(upper));
    }

    public boolean add(double lower, double upper) throws IllegalArgumentException {
        return this.add(Double.valueOf(lower), Double.valueOf(upper));
    }

    /*
     * Enabled aggressive block sorting
     */
    public <N> boolean remove(Comparable<? super N> min, Comparable<? super N> max) throws IllegalArgumentException {
        int n;
        Comparable<? super N> upper;
        Comparable<N> lower = this.toArrayElement(min);
        if (lower.compareTo(upper = this.toArrayElement(max)) >= 0) {
            throw new IllegalArgumentException(Errors.format(14, min, max));
        }
        if (this.array == null) {
            return false;
        }
        int modCountChk = this.modCount++;
        int i0 = this.binarySearch(lower);
        int i1 = this.binarySearch(upper);
        if (i0 < 0) {
            if (((i0 ^= 0xFFFFFFFF) & 1) != 0) {
                if (i1 == ~i0) {
                    Object old = this.array;
                    int length = Array.getLength(this.array);
                    this.array = Array.newInstance(this.arrayElementClass, length + 2);
                    System.arraycopy(old, 0, this.array, 0, i0);
                    System.arraycopy(old, i0, this.array, i0 + 2, length - i0);
                    Array.set(this.array, i0 + 0, lower);
                    Array.set(this.array, i0 + 1, upper);
                    return true;
                }
                Array.set(this.array, i0, lower);
            } else {
                --i0;
            }
        } else if ((i0 & 1) == 0) {
            --i0;
        }
        if (i1 < 0) {
            if (((i1 ^= 0xFFFFFFFF) & 1) != 0) {
                ++this.modCount;
                Array.set(this.array, --i1, upper);
            }
        } else {
            i1 &= 0xFFFFFFFE;
        }
        assert ((i0 & 1) != 0) : i0;
        assert ((i1 & 1) == 0) : i1;
        if ((n = i1 - ++i0) > 0) {
            ++this.modCount;
            Object old = this.array;
            int length = Array.getLength(this.array);
            this.array = Array.newInstance(this.arrayElementClass, length - n);
            System.arraycopy(old, 0, this.array, 0, i0);
            System.arraycopy(old, i1, this.array, i0, length - i1);
        }
        assert ((Array.getLength(this.array) & 1) == 0);
        if (modCountChk == this.modCount) return false;
        return true;
    }

    public boolean remove(byte lower, byte upper) throws IllegalArgumentException {
        return this.remove(Byte.valueOf(lower), Byte.valueOf(upper));
    }

    public boolean remove(short lower, short upper) throws IllegalArgumentException {
        return this.remove(Short.valueOf(lower), Short.valueOf(upper));
    }

    public boolean remove(int lower, int upper) throws IllegalArgumentException {
        return this.remove(Integer.valueOf(lower), Integer.valueOf(upper));
    }

    public boolean remove(long lower, long upper) throws IllegalArgumentException {
        return this.remove(Long.valueOf(lower), Long.valueOf(upper));
    }

    public boolean remove(float lower, float upper) throws IllegalArgumentException {
        return this.remove(Float.valueOf(lower), Float.valueOf(upper));
    }

    public boolean remove(double lower, double upper) throws IllegalArgumentException {
        return this.remove(Double.valueOf(lower), Double.valueOf(upper));
    }

    private int binarySearch(Comparable value) {
        switch (this.arrayElementCode) {
            case 8: {
                return Arrays.binarySearch((double[])this.array, ((Number)((Object)value)).doubleValue());
            }
            case 7: {
                return Arrays.binarySearch((float[])this.array, ((Number)((Object)value)).floatValue());
            }
            case 6: {
                return Arrays.binarySearch((long[])this.array, ((Number)((Object)value)).longValue());
            }
            case 5: {
                return Arrays.binarySearch((int[])this.array, ((Number)((Object)value)).intValue());
            }
            case 4: {
                return Arrays.binarySearch((short[])this.array, ((Number)((Object)value)).shortValue());
            }
            case 3: {
                return Arrays.binarySearch((byte[])this.array, ((Number)((Object)value)).byteValue());
            }
            case 2: {
                return Arrays.binarySearch((char[])this.array, ((Character)value).charValue());
            }
        }
        return Arrays.binarySearch((Object[])this.array, value);
    }

    private Range<T> newRange(T lower, T upper) {
        if (this.isNumeric) {
            NumberRange<T> result = new NumberRange<T>(this.elementClass, lower, upper);
            return result;
        }
        return new Range<T>(this.elementClass, lower, upper);
    }

    private T get(int index) {
        Comparable value = (Comparable)Array.get(this.array, index);
        if (this.useClassChanger) {
            try {
                value = ClassChanger.toComparable((Number)((Object)value), this.elementClass);
            }
            catch (ClassNotFoundException exception) {
                throw new IllegalStateException(exception);
            }
        }
        return (T)((Comparable)this.elementClass.cast(value));
    }

    public final double getMinValueAsDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        return this.isPrimitive ? Array.getDouble(this.array, index) : ((Number)Array.get(this.array, index *= 2)).doubleValue();
    }

    public final double getMaxValueAsDouble(int index) throws IndexOutOfBoundsException, ClassCastException {
        index = 2 * index + 1;
        return this.isPrimitive ? Array.getDouble(this.array, index) : ((Number)Array.get(this.array, index)).doubleValue();
    }

    public <T> int indexOfRange(Comparable<T> value) {
        int index = this.binarySearch(this.toArrayElement(value));
        if (index < 0 && ((index ^= 0xFFFFFFFF) & 1) == 0) {
            return -1;
        }
        assert (this.newRange(this.get(2 * (index /= 2)), this.get(2 * index + 1)).contains(value)) : value;
        return index;
    }

    @Override
    public boolean contains(Object object) {
        int index;
        Range range = (Range)object;
        if (this.elementClass.equals(range.elementClass) && range.isMinIncluded() && range.isMaxIncluded() && (index = this.binarySearch(this.toArrayElement((Comparable<T>)range.getMinValue()))) >= 0 && (index & 1) == 0) {
            int c = this.get(index + 1).compareTo(range.getMaxValue());
            return c == 0;
        }
        return false;
    }

    @Override
    public Range<T> first() throws NoSuchElementException {
        if (this.array != null && Array.getLength(this.array) != 0) {
            return this.newRange(this.get(0), this.get(1));
        }
        throw new NoSuchElementException();
    }

    @Override
    public Range<T> last() throws NoSuchElementException {
        int length;
        if (this.array != null && (length = Array.getLength(this.array)) != 0) {
            return this.newRange(this.get(length - 2), this.get(length - 1));
        }
        throw new NoSuchElementException();
    }

    @Override
    public SortedSet<Range<T>> subSet(Range<T> lower, Range<T> upper) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public SortedSet<Range<T>> headSet(Range<T> upper) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public SortedSet<Range<T>> tailSet(Range<T> lower) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    public java.util.Iterator<Range<T>> iterator() {
        return new Iterator();
    }

    @Override
    public int hashCode() {
        int code = this.elementClass.hashCode();
        if (this.array != null) {
            int i = Array.getLength(this.array);
            while ((i -= 8) >= 0) {
                code = code * 37 + Array.get(this.array, i).hashCode();
            }
        }
        return code;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass().equals(this.getClass())) {
            RangeSet that = (RangeSet)object;
            if (Utilities.equals(this.elementClass, that.elementClass)) {
                switch (this.arrayElementCode) {
                    case 8: {
                        return Arrays.equals((double[])this.array, (double[])that.array);
                    }
                    case 7: {
                        return Arrays.equals((float[])this.array, (float[])that.array);
                    }
                    case 6: {
                        return Arrays.equals((long[])this.array, (long[])that.array);
                    }
                    case 5: {
                        return Arrays.equals((int[])this.array, (int[])that.array);
                    }
                    case 4: {
                        return Arrays.equals((short[])this.array, (short[])that.array);
                    }
                    case 3: {
                        return Arrays.equals((byte[])this.array, (byte[])that.array);
                    }
                    case 2: {
                        return Arrays.equals((char[])this.array, (char[])that.array);
                    }
                }
                return Arrays.equals((Object[])this.array, (Object[])that.array);
            }
        }
        return false;
    }

    @Override
    public RangeSet clone() {
        RangeSet set;
        try {
            set = (RangeSet)super.clone();
        }
        catch (CloneNotSupportedException exception) {
            throw new AssertionError((Object)exception);
        }
        switch (set.arrayElementCode) {
            case 8: {
                set.array = ((double[])set.array).clone();
                break;
            }
            case 7: {
                set.array = ((float[])set.array).clone();
                break;
            }
            case 6: {
                set.array = ((long[])set.array).clone();
                break;
            }
            case 5: {
                set.array = ((int[])set.array).clone();
                break;
            }
            case 4: {
                set.array = ((short[])set.array).clone();
                break;
            }
            case 3: {
                set.array = ((byte[])set.array).clone();
                break;
            }
            case 2: {
                set.array = ((char[])set.array).clone();
                break;
            }
            default: {
                set.array = ((Object[])set.array).clone();
            }
        }
        return set;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(Classes.getShortClassName(this));
        buffer.append('[');
        boolean first = true;
        for (Range<T> range : this) {
            if (!first) {
                buffer.append(',');
            }
            buffer.append('{').append(range.getMinValue()).append("..").append(range.getMaxValue()).append('}');
            first = false;
        }
        return buffer.append(']').toString();
    }

    private final class Iterator
    implements java.util.Iterator<Range<T>> {
        private int modCount;
        private int length;
        private int position;

        private Iterator() {
            this.modCount = RangeSet.this.modCount;
            this.length = RangeSet.this.array != null ? Array.getLength(RangeSet.this.array) : 0;
        }

        @Override
        public boolean hasNext() {
            return this.position < this.length;
        }

        @Override
        public Range<T> next() {
            if (this.hasNext()) {
                Comparable lower = RangeSet.this.get(this.position++);
                Comparable upper = RangeSet.this.get(this.position++);
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
                return RangeSet.this.newRange(lower, upper);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.position != 0) {
                if (RangeSet.this.modCount != this.modCount) {
                    throw new ConcurrentModificationException();
                }
            } else {
                throw new IllegalStateException();
            }
            Object newArray = Array.newInstance(RangeSet.this.arrayElementClass, this.length -= 2);
            System.arraycopy(RangeSet.this.array, this.position, newArray, this.position -= 2, this.length - this.position);
            System.arraycopy(RangeSet.this.array, 0, newArray, 0, this.position);
            RangeSet.this.array = newArray;
            this.modCount = ++RangeSet.this.modCount;
        }
    }
}

